package com.gateway.connector.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipUtils {
	public static byte[] gzip(byte[] bt) {
		byte[] bout = null;
		if (bt != null) {

			ByteArrayOutputStream out = new ByteArrayOutputStream();
			try {
				GZIPOutputStream gzip = new GZIPOutputStream(out);
				gzip.write(bt);
				gzip.close();
				bout = out.toByteArray();
				out.close();
				gzip = null;
			} catch (Exception localException) {
			}
			out = null;
		}
		return bout;
	}

	public static byte[] ungzip(byte[] inByte) {
		byte[] bout = null;
		try {
			if (inByte != null) {
				ByteArrayInputStream in = new ByteArrayInputStream(inByte);
				GZIPInputStream gzin = new GZIPInputStream(in);
				ByteArrayOutputStream out = new ByteArrayOutputStream();

				byte[] buf = new byte[4096];

				int nlen = -1;
				while ((nlen = gzin.read(buf, 0, buf.length)) > -1) {
					out.write(buf, 0, nlen);
				}
				gzin.close();

				bout = out.toByteArray();
				out.close();

				gzin = null;
				out = null;
				buf = null;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return bout;
	}
}
