package com.gateway.connector.utils;

import java.lang.Thread.UncaughtExceptionHandler;
import java.util.concurrent.LinkedBlockingQueue;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncBase<T> {
	private LinkedBlockingQueue<T> queue;
	protected final Logger logger = LoggerFactory.getLogger(getClass());

	public Thread thread;
	protected boolean isStop = false;
	public String className = null;
	protected static int maxSize = Integer.MAX_VALUE;

	public AsyncBase() {
		this(true, maxSize);
	}

	public AsyncBase(int maxSize) {
		this(true, maxSize);
	}

	public class ExceptionHandler implements UncaughtExceptionHandler {
		public void uncaughtException(Thread t, Throwable e) {
			logger.error("An exception has been captured\n");
			logger.error("Thread: {}\n", t.getName());
			logger.error("Exception: {}: {}\n", e.getClass().getSimpleName(), e.getMessage());
			logger.error("Stack Trace: {}\n", e);
			logger.error("Thread status: {}\n", t.getState());
		}
	}

	public AsyncBase(boolean paramBoolean, int maxSize) {

		queue = new LinkedBlockingQueue<T>(maxSize);

		this.thread = new Thread(new Runnable() {
			public final void run() {
				while (!isStop)
					try {
						logger.debug("{} process begin", className);
						T obj = queue.take();
						logger.debug("{} process data[{}]", className, obj);
						process(obj);
						logger.debug("{} process end", className);
					} catch (InterruptedException e) {
					} catch (Exception localException) {
						logger.warn("deliver process error[{}]", localException);
					}
				logger.debug("{} exit", className);
			}
		});
		this.thread.setUncaughtExceptionHandler(new ExceptionHandler());
		if (paramBoolean) {
			start();
			return;
		}
		this.isStop = true;
	}

	public Thread getThread() {
		return this.thread;
	}

	public LinkedBlockingQueue<T> getQueue() {
		return this.queue;
	}

	public void start() {
		className = this.className != null ? this.className : getClass().getSimpleName();
		this.logger.debug("{} start", className);
		if (!StringUtils.isEmpty(className))
			this.thread.setName(className);
		this.isStop = false;
		if (!this.thread.isAlive())
			this.thread.start();
	}

	protected void process(T paramT) {
	}

	private long printTime;

	public void add(T paramT) {

		boolean flag = queue.offer(paramT);
		if (!flag) {

			logger.warn("queue[{}] is full[size:{}],so drop[{}]", className, queue.size(), paramT);
		}
		if (queue.size() > 100) {
			boolean isPrint = true;
			long currentTime = System.currentTimeMillis();
			if (currentTime - printTime < 1000 * 10) {				
				isPrint = false;
			}
			if (isPrint) {
				printTime = currentTime;
				logger.warn("queue[{}] is critical[size:{}]", className, queue.size());
			}
		}
	}

	public void dispose() {
		this.isStop = true;
		try {

			if (this.thread.isAlive()) {
				this.thread.interrupt();
			}
		} catch (Exception e) {

		}
		logger.debug("{} stop", className);
	}
}
