package com.gateway.connector.tcp.server;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * topic<->session管理
 * 
 * @author deshuai.kong
 *
 */
public class TopicManager {

	private final static Logger logger = LoggerFactory.getLogger(TopicManager.class);
	private ConcurrentHashMap<String, CopyOnWriteArraySet<String>> topicHm = new ConcurrentHashMap<String, CopyOnWriteArraySet<String>>();

	public ConcurrentHashMap<String, CopyOnWriteArraySet<String>> getTopics() {
		return topicHm;
	}

	public synchronized boolean add(String sessionid, String topic) {// 添加
		boolean flag = false;
		if (StringUtils.isNoneEmpty(sessionid)) {
			CopyOnWriteArraySet<String> cas = topicHm.get(sessionid);
			if (cas == null) {
				cas = new CopyOnWriteArraySet<String>();
				topicHm.put(sessionid, cas);
			}
			if (!cas.contains(topic)) {
				cas.add(topic);
				logger.debug("add topic " + sessionid+":"+topic + " from sessions!");
			}
			
			flag = true;
		}
		return flag;
	}

	public synchronized boolean remove(String sessionid, String topic) {// 删除
		boolean flag = true;
		CopyOnWriteArraySet<String> cas = topicHm.get(sessionid);
		if (cas != null) {
			cas.remove(topic);
		}

		return flag;
	}

	public synchronized boolean clear(String sessionid) {// 清除topic
		boolean flag = false;
		topicHm.remove(sessionid);
		logger.debug("clear topic " + sessionid + " from sessions!");
		flag = true;
		return flag;
	}
}
