
package com.gateway.connector.tcp.server;

import com.gateway.connector.tcp.codec.TcpProtoDecoder;
import com.gateway.connector.tcp.codec.TcpProtoEncoder;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.logging.LoggingHandler;

@ChannelHandler.Sharable
public class ServerChannelInitializer extends ChannelInitializer<SocketChannel> {

	private ApiProxy apiProxy;
	private boolean isGzip;

	public ServerChannelInitializer(boolean isGzip, ApiProxy apiProxy) {
		this.apiProxy = apiProxy;
		this.isGzip = isGzip;
	}

	@Override
	protected void initChannel(SocketChannel socketChannel) throws Exception {

		ChannelPipeline pipeline = socketChannel.pipeline();
		pipeline.addLast(new LoggingHandler());

		pipeline.addLast("decoder", new TcpProtoDecoder(isGzip));
		pipeline.addLast("encoder", new TcpProtoEncoder(isGzip));
		pipeline.addLast(new TcpServerHandler(apiProxy));

	}
}
