package com.gateway.connector.tcp.client;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.gateway.connector.proto.Cmd;
import com.gateway.connector.proto.Format;
import com.gateway.connector.proto.Proto;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;

@ChannelHandler.Sharable
public class TcpClientHandler extends SimpleChannelInboundHandler<Proto> {
	private IClientListener listener;
	private ReadProtoProcess rsprpp = null;
	private ReadProtoProcess notifyrpp = null;
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	public TcpClientHandler(ReadProtoProcess rsprpp,ReadProtoProcess notifyrpp,IClientListener listener) {
		this.rsprpp=rsprpp;
		this.notifyrpp=notifyrpp;
		this.listener = listener;
	}

	@Override
	public void channelReadComplete(ChannelHandlerContext ctx) {
		ctx.flush();
	}

	@Override
	public void channelActive(ChannelHandlerContext ctx) {
	 
		if (listener != null) {
			listener.onConnect();
		}

	}

	@Override
	public void channelInactive(ChannelHandlerContext ctx) {
		 
		logger.info("channelInactive from (" + ctx.channel().remoteAddress() + ")");
		if (listener != null) {
			listener.onDisConnect();
		}
		ctx.fireChannelInactive();
	}

	@Override
	public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
	 
		logger.error("exceptionCaught:" + cause);
		if (listener != null) {
			listener.onException(cause);
		}
	}

	@Override
	protected void channelRead0(ChannelHandlerContext ctx, Proto msg) throws Exception {
		if (msg.getFormat() == Format.REPLY || msg.getCmd() == Cmd.CONNECT) {
			rsprpp.add(msg);
		} else if (msg.getFormat() == Format.NOTIFY) {
			notifyrpp.add(msg);
		}

	}
}
