package com.gateway.connector.tcp.client;

import com.gateway.connector.proto.Proto;
/**
 * 客户端连接事件
 * @author deshuai.kong
 *
 */
public interface IClientListener {
	/**
	 * 连接成功
	 */
    void onConnect();
    /**
     * 登录结果
     * @param proto
     */
    void onLoginResult(Proto proto);

    /**
     * 连接断开
     */
    void onDisConnect();

    /**
     * 异常
     * @param throwable
     */
    void onException(Throwable throwable);

    /**
     * 回调消息
     * @param msg
     */
    void onMessage(Proto msg);
 
}
