/*
 * Decompiled with CFR 0.152.
 */
package bld.read.report.excel.impl;

import bld.generator.report.utils.ExcelUtils;
import bld.read.report.excel.ReadExcel;
import bld.read.report.excel.annotation.ExcelReadColumn;
import bld.read.report.excel.annotation.ExcelReadSheet;
import bld.read.report.excel.domain.ExcelRead;
import bld.read.report.excel.domain.RowSheetRead;
import bld.read.report.excel.domain.SheetRead;
import bld.read.report.utils.ExcelType;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Component;

@Component
public class ReadExcelImpl
implements ReadExcel {
    private static final String SET = "set";
    private static final Log logger = LogFactory.getLog(ReadExcelImpl.class);

    public ExcelRead convertExcelToEntity(ExcelRead excelRead) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(excelRead.getReportExcel());
        return this.convertExcelToEntity(excelRead, inputStream);
    }

    public ExcelRead convertExcelToEntity(ExcelRead excelRead, String pathFile) throws Exception {
        FileInputStream inputStream = new FileInputStream(pathFile);
        return this.convertExcelToEntity(excelRead, inputStream);
    }

    private <T extends RowSheetRead> ExcelRead convertExcelToEntity(ExcelRead excelRead, InputStream inputStream) throws Exception {
        Object workbook = null;
        workbook = ExcelType.XLS.equals((Object)excelRead.getExcelType()) ? new HSSFWorkbook(inputStream) : new XSSFWorkbook(inputStream);
        block0: for (Class<SheetRead<?>> classSheet : excelRead.getListClassSheet()) {
            SheetRead<?> sheetType = classSheet.newInstance();
            excelRead.getMapSheet().put(classSheet, sheetType);
            ExcelReadSheet excelReadSheet = (ExcelReadSheet)ExcelUtils.getAnnotation(classSheet, ExcelReadSheet.class);
            logger.info((Object)("Sheet: " + excelReadSheet.nameSheet()));
            Sheet worksheet = workbook.getSheet(excelReadSheet.nameSheet());
            Row header = worksheet.getRow(excelReadSheet.startRow());
            Map<String, Integer> mapColumns = this.getMapColumns(header, excelReadSheet);
            int startRow = excelReadSheet.startRow() + 1;
            ParameterizedType classType = (ParameterizedType)classSheet.getGenericSuperclass();
            Class genericClassType = (Class)classType.getActualTypeArguments()[0];
            HashMap<String, Method> mapMethod = new HashMap<String, Method>();
            this.setMapMethod(mapMethod, genericClassType.getSuperclass().getMethods());
            this.setMapMethod(mapMethod, genericClassType.getMethods());
            logger.info((Object)("Generic class type: " + genericClassType.getName()));
            for (int indexRow = startRow; indexRow <= worksheet.getPhysicalNumberOfRows(); ++indexRow) {
                RowSheetRead rowSheetRead = (RowSheetRead)genericClassType.newInstance();
                Row row = worksheet.getRow(indexRow);
                if (row == null) continue;
                HashSet<Field> listField = new HashSet<Field>(Arrays.asList(rowSheetRead.getClass().getDeclaredFields()));
                listField.addAll(Arrays.asList(rowSheetRead.getClass().getSuperclass().getDeclaredFields()));
                boolean rowEmpty = true;
                for (Field field : listField) {
                    String stringValue;
                    if (!field.isAnnotationPresent(ExcelReadColumn.class)) continue;
                    ExcelReadColumn excelReadColumn = field.getAnnotation(ExcelReadColumn.class);
                    if (!mapColumns.containsKey(excelReadColumn.name())) {
                        throw new Exception("Not exist the column: " + excelReadColumn.name());
                    }
                    int indexColumn = mapColumns.get(excelReadColumn.name());
                    Cell cell = row.getCell(indexColumn);
                    if (cell == null || cell.getCellType() == CellType.BLANK) continue;
                    String nameMethod = SET + ("" + field.getName().charAt(0)).toUpperCase() + field.getName().substring(1);
                    logger.info((Object)("Set Function: " + nameMethod));
                    Class<?> classField = field.getType();
                    logger.info((Object)("The field " + field.getName() + " is of " + classField.getSimpleName() + " type"));
                    Object value = null;
                    if (Number.class.isAssignableFrom(classField)) {
                        Double numberValue = cell.getNumericCellValue();
                        if (Integer.class.isAssignableFrom(classField)) {
                            value = numberValue.intValue();
                        } else if (BigDecimal.class.isAssignableFrom(classField)) {
                            value = BigDecimal.valueOf(numberValue);
                        } else if (Float.class.isAssignableFrom(classField)) {
                            value = new Float(numberValue);
                        } else if (Long.class.isAssignableFrom(classField)) {
                            value = numberValue.longValue();
                        }
                    } else if (String.class.isAssignableFrom(classField)) {
                        stringValue = cell.getStringCellValue().trim();
                        value = stringValue.isEmpty() ? null : stringValue;
                    } else if (Calendar.class.isAssignableFrom(classField)) {
                        Calendar calendar = Calendar.getInstance();
                        Date dateValue = cell.getDateCellValue();
                        calendar.setTime(dateValue);
                        value = calendar;
                    } else if (Date.class.isAssignableFrom(classField)) {
                        value = cell.getDateCellValue();
                    } else if (Boolean.class.isAssignableFrom(classField)) {
                        value = cell.getBooleanCellValue();
                    } else if (Character.class.isAssignableFrom(classField)) {
                        stringValue = cell.getStringCellValue();
                        value = stringValue.length() > 0 ? Character.valueOf(stringValue.charAt(0)) : null;
                    } else {
                        logger.info((Object)("The type \"" + field.getType().getSimpleName() + "\" is not manage"));
                    }
                    if (value == null) continue;
                    String nameColumn = ("" + field.getName().charAt(0)).toUpperCase() + field.getName().substring(1);
                    logger.info((Object)(nameColumn + ": " + value));
                    Method method = (Method)mapMethod.get(SET + nameColumn);
                    method.invoke((Object)rowSheetRead, value);
                    rowEmpty = false;
                }
                if (rowEmpty) continue block0;
                sheetType.getListRowSheet().add(rowSheetRead);
            }
        }
        return excelRead;
    }

    private void setMapMethod(Map<String, Method> mapMethod, Method[] listMethod) {
        for (Method method : listMethod) {
            mapMethod.put(method.getName(), method);
        }
    }

    private Map<String, Integer> getMapColumns(Row header, ExcelReadSheet excelReadSheet) {
        Cell cell;
        HashMap<String, Integer> mapColumn = new HashMap<String, Integer>();
        int i = excelReadSheet.startColumn();
        Iterator cellIterator = header.cellIterator();
        while (cellIterator.hasNext() && (cell = (Cell)cellIterator.next()) != null && !StringUtils.isEmpty((CharSequence)cell.getStringCellValue())) {
            mapColumn.put(cell.getStringCellValue(), i);
            ++i;
        }
        return mapColumn;
    }
}

