/*
 * Decompiled with CFR 0.152.
 */
package bld.generator.report.utils;

import java.io.FileOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.text.WordUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ExcelUtils
implements ApplicationContextAware {
    private static final String BLD_GENERATOR = "bld.generator";
    public static final String ANNOTATIONS = "annotations";
    public static final String ANNOTATION_DATA = "annotationData";
    private static ApplicationContext applicationContext;

    public static <T extends Annotation> T getAnnotation(Class<?> classExcel, Class<T> classAnnotation) throws Exception {
        if (!classExcel.isAnnotationPresent(classAnnotation)) {
            throw new Exception("Annotation " + classAnnotation.getSimpleName() + " is not presented on " + classExcel.getSimpleName());
        }
        return classExcel.getAnnotation(classAnnotation);
    }

    public static <T extends Annotation> T getAnnotation(Field field, Class<T> classAnnotation) throws Exception {
        if (!field.isAnnotationPresent(classAnnotation)) {
            throw new Exception("Annotation " + classAnnotation.getSimpleName() + " is not presented on " + field.getName());
        }
        return field.getAnnotation(classAnnotation);
    }

    public static <T, K extends Annotation> T reflectionAnnotation(T entity, K annotation) {
        ArrayList<Field> listField = new ArrayList<Field>();
        Class<?> classT = entity.getClass();
        do {
            listField.addAll(Arrays.asList(classT.getDeclaredFields()));
        } while ((classT = classT.getSuperclass()).getSuperclass() != null && !classT.getName().equals(Object.class.getName()));
        HashMap<String, Field> mapField = new HashMap<String, Field>();
        for (Field field : listField) {
            mapField.put(field.getName(), field);
        }
        Class<?> classAnnotation = annotation.getClass();
        Class<?> classEntity = entity.getClass();
        List<Method> listMethod = Arrays.asList(classAnnotation.getMethods());
        for (Method method : listMethod) {
            if (!mapField.containsKey(method.getName())) continue;
            Field field = (Field)mapField.get(method.getName());
            Object value = null;
            String nameField = field.getName();
            String setMethod = "set" + ("" + nameField.charAt(0)).toUpperCase() + nameField.substring(1);
            Class<?> classField = field.getType();
            try {
                value = method.invoke(annotation, new Object[0]);
                try {
                    classEntity.getMethod(setMethod, classField).invoke(entity, value);
                }
                catch (Exception e) {
                    if (!Annotation.class.isAssignableFrom(value.getClass()) || !field.getType().getName().startsWith(BLD_GENERATOR)) continue;
                    Annotation fieldAnnotation = (Annotation)value;
                    value = ExcelUtils.reflectionAnnotation(classField.newInstance(), fieldAnnotation);
                    classEntity.getMethod(setMethod, classField).invoke(entity, value);
                }
            }
            catch (Exception exception) {}
        }
        return entity;
    }

    public static void addAnnotation(Class<?> classe, Class<? extends Annotation> classAnnotation, Annotation annotation) throws Exception {
        Field annotationFieldData = Class.class.getDeclaredField(ANNOTATION_DATA);
        annotationFieldData.setAccessible(true);
        Object annotationData = annotationFieldData.get(classe);
        Field annotationsField = annotationData.getClass().getDeclaredField(ANNOTATIONS);
        annotationsField.setAccessible(true);
        Map annotations = (Map)annotationsField.get(annotationData);
        annotations.put(classAnnotation, annotation);
    }

    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        applicationContext = ac;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static String getNameParameter(String parameter) {
        parameter = WordUtils.capitalize((String)parameter.replace("_", " ")).replace(" ", "");
        return (parameter.charAt(0) + "").toLowerCase() + parameter.substring(1);
    }

    public static void writeToFile(String pathFile, String fileName, String typeFile, byte[] dati) {
        try {
            FileOutputStream fos = new FileOutputStream(pathFile + fileName + typeFile);
            fos.write(dati);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String calcoloCoordinateFunction(int row, int column) {
        int mod = 0;
        int div = column;
        String coordinata = "";
        do {
            mod = div % 26;
            div = div / 26 - 1;
            coordinata = Character.toString((char)(mod += 65)) + coordinata;
        } while (div >= 0);
        coordinata = coordinata + row;
        return coordinata;
    }

    public static String getKeyColumn(Sheet sheet, String key) {
        if (!key.contains(".")) {
            key = sheet.getSheetName() + "." + key;
        }
        return key;
    }

    public static Set<Field> getListField(Class<?> classComponentExcel) {
        HashSet<Field> listField = new HashSet<Field>();
        Class<?> classApp = classComponentExcel;
        do {
            listField.addAll(Arrays.asList(classApp.getDeclaredFields()));
        } while ((classApp = classApp.getSuperclass()).getSuperclass() != null && !classApp.getName().equals(Object.class.getName()));
        return listField;
    }
}

