/*
 * Decompiled with CFR 0.152.
 */
package bld.generator.report.excel.impl;

import bld.generator.report.excel.DynamicColumn;
import bld.generator.report.excel.ExcelHyperlink;
import bld.generator.report.excel.RowSheet;
import bld.generator.report.excel.SheetComponent;
import bld.generator.report.excel.SheetData;
import bld.generator.report.excel.SheetSummary;
import bld.generator.report.excel.annotation.ExcelBorder;
import bld.generator.report.excel.annotation.ExcelCellLayout;
import bld.generator.report.excel.annotation.ExcelColumn;
import bld.generator.report.excel.annotation.ExcelDate;
import bld.generator.report.excel.annotation.ExcelFont;
import bld.generator.report.excel.annotation.ExcelFunction;
import bld.generator.report.excel.annotation.ExcelFunctionRow;
import bld.generator.report.excel.annotation.ExcelFunctionRows;
import bld.generator.report.excel.annotation.ExcelHeaderLayout;
import bld.generator.report.excel.annotation.ExcelMarginSheet;
import bld.generator.report.excel.annotation.ExcelRgbColor;
import bld.generator.report.excel.annotation.ExcelSheetLayout;
import bld.generator.report.excel.annotation.ExcelSummary;
import bld.generator.report.excel.comparator.SheetColumnComparator;
import bld.generator.report.excel.constant.ColumnDateFormat;
import bld.generator.report.excel.constant.RowStartEndType;
import bld.generator.report.excel.data.ExtraColumnAnnotation;
import bld.generator.report.excel.data.InfoColumn;
import bld.generator.report.excel.data.LayoutCell;
import bld.generator.report.excel.data.MergeCell;
import bld.generator.report.excel.data.SheetHeader;
import bld.generator.report.utils.ExcelUtils;
import bld.generator.report.utils.ValueProps;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.springframework.beans.factory.annotation.Autowired;

public class SuperGenerateExcelImpl {
    private static final int FLAT_ANGLE = 180;
    private static final String PATTERN = "\\$\\{.*?}";
    private static final String $ = "${";
    protected static final SimpleDateFormat SDF = new SimpleDateFormat(ColumnDateFormat.DD_MM_YYYY.getValue());
    protected CellStyle mergeCalcoloCells = null;
    protected Map<LayoutCell, CellStyle> mapCellStyle = new HashMap<LayoutCell, CellStyle>();
    protected Map<LayoutCell, CellStyle> mapCellHeaderStyle = new HashMap<LayoutCell, CellStyle>();
    private static final Log logger = LogFactory.getLog(SuperGenerateExcelImpl.class);
    private static final int WIDTH_CELL_STANDARD = 22;
    protected Map<String, InfoColumn> mapFieldColumn = new HashMap<String, InfoColumn>();
    @Autowired
    protected ValueProps valueProps;

    protected CellStyle createCellStyle(Workbook workbook, ExcelHeaderLayout layout) {
        CellStyle cellStyleHeader = workbook.createCellStyle();
        ExcelRgbColor rgbFont = layout.rgbFont();
        ExcelRgbColor rgbForeground = layout.rgbForeground();
        Font font = this.getFont(workbook, layout.font());
        if (workbook instanceof HSSFWorkbook) {
            HSSFPalette paletteFont = ((HSSFWorkbook)workbook).getCustomPalette();
            short colorFont = 20;
            paletteFont.setColorAtIndex(colorFont, rgbFont.red(), rgbFont.green(), rgbFont.blue());
            ((HSSFFont)font).setColor(colorFont);
            short colorForeground = 45;
            HSSFPalette palette = ((HSSFWorkbook)workbook).getCustomPalette();
            palette.setColorAtIndex(colorForeground, rgbForeground.red(), rgbForeground.green(), rgbForeground.blue());
            cellStyleHeader.setFillForegroundColor(colorForeground);
        } else {
            XSSFColor colorForeground = this.getColor(rgbForeground.red(), rgbForeground.green(), rgbForeground.blue());
            XSSFColor colorFont = this.getColor(rgbFont.red(), rgbFont.green(), rgbFont.blue());
            ((XSSFCellStyle)cellStyleHeader).setFillForegroundColor(colorForeground);
            ((XSSFFont)font).setColor(colorFont);
        }
        cellStyleHeader.setRotation((short)(layout.rotation() % 180));
        cellStyleHeader.setFont(font);
        cellStyleHeader.setFillPattern(layout.fillPatternType());
        cellStyleHeader.setAlignment(layout.horizontalAlignment());
        cellStyleHeader.setVerticalAlignment(layout.verticalAlignment());
        cellStyleHeader.setWrapText(layout.wrap());
        cellStyleHeader = this.getBorder(cellStyleHeader, layout.border());
        return cellStyleHeader;
    }

    protected CellStyle createCellStyle(Workbook workbook, ExcelCellLayout layout) throws Exception {
        return this.createCellStyle(workbook, layout, null);
    }

    protected CellStyle createCellStyle(Workbook workbook, ExcelCellLayout layout, ExcelDate excelDate) throws Exception {
        CellStyle cellStyle = workbook.createCellStyle();
        ExcelRgbColor rgbFont = layout.rgbFont();
        ExcelRgbColor rgbForeground = layout.rgbForeground();
        Font font = this.getFont(workbook, layout.font());
        if (workbook instanceof HSSFWorkbook) {
            HSSFPalette paletteFont = ((HSSFWorkbook)workbook).getCustomPalette();
            short colorFont = 20;
            paletteFont.setColorAtIndex(colorFont, rgbFont.red(), rgbFont.green(), rgbFont.blue());
            ((HSSFFont)font).setColor(colorFont);
            short colorForeground = 45;
            HSSFPalette palette = ((HSSFWorkbook)workbook).getCustomPalette();
            palette.setColorAtIndex(colorForeground, rgbForeground.red(), rgbForeground.green(), rgbForeground.blue());
            cellStyle.setFillForegroundColor(colorForeground);
        } else {
            XSSFColor colorForeground = this.getColor(rgbForeground.red(), rgbForeground.green(), rgbForeground.blue());
            XSSFColor colorFont = this.getColor(rgbFont.red(), rgbFont.green(), rgbFont.blue());
            ((XSSFCellStyle)cellStyle).setFillForegroundColor(colorForeground);
            ((XSSFFont)font).setColor(colorFont);
        }
        cellStyle.setFont(font);
        cellStyle.setFillPattern(layout.fillPatternType());
        cellStyle.setAlignment(layout.horizontalAlignment());
        cellStyle.setVerticalAlignment(layout.verticalAlignment());
        cellStyle = this.getBorder(cellStyle, layout.border());
        cellStyle.setWrapText(layout.wrap());
        if (excelDate != null) {
            cellStyle = this.dateCellStyle(workbook, cellStyle, excelDate.format().getValue());
        } else if (layout.precision() > -1) {
            String format = "0.";
            for (int i = 0; i < layout.precision(); ++i) {
                format = format + "0";
            }
            cellStyle = this.dateCellStyle(workbook, cellStyle, format);
        }
        return cellStyle;
    }

    protected Font getFont(Workbook workbook, ExcelFont excelFont) {
        Font font = workbook.createFont();
        font.setBold(excelFont.bold());
        font.setFontName(excelFont.font().getValue());
        font.setItalic(excelFont.italic());
        font.setUnderline(excelFont.underline().getValue());
        font.setFontHeight((short)(excelFont.size() * 20));
        return font;
    }

    protected XSSFColor getColor(byte ... rgbColor) {
        XSSFColor color = new XSSFColor();
        color.setRGB(rgbColor);
        return color;
    }

    protected CellStyle getBorder(CellStyle cellStyle, ExcelBorder excelBorder) {
        cellStyle.setBorderLeft(excelBorder.left());
        cellStyle.setBorderRight(excelBorder.right());
        cellStyle.setBorderTop(excelBorder.top());
        cellStyle.setBorderBottom(excelBorder.bottom());
        return cellStyle;
    }

    protected List<SheetHeader> getListSheetHeader(Class<?> classRow, Object entity) throws Exception {
        logger.debug((Object)("Row: " + classRow.getSimpleName()));
        HashSet<String> listTitolo = new HashSet<String>();
        ArrayList<SheetHeader> listSheetHeader = new ArrayList<SheetHeader>();
        Set<Field> listField = ExcelUtils.getListField(classRow);
        for (Field field : listField) {
            ExcelColumn sheetColumn = field.getAnnotation(ExcelColumn.class);
            if (sheetColumn == null || sheetColumn.ignore()) continue;
            Object value = null;
            if (entity != null) {
                value = new PropertyDescriptor(field.getName(), classRow).getReadMethod().invoke(entity, new Object[0]);
            }
            listSheetHeader.add(new SheetHeader(field, value));
            if (listTitolo.contains(sheetColumn.nameColumn())) {
                logger.warn((Object)("Exist another equal column with nameColum= \"" + sheetColumn.nameColumn() + "\" for the same sheet!!!"));
            }
            listTitolo.add(sheetColumn.nameColumn());
        }
        if (classRow.isAnnotationPresent(ExcelFunctionRows.class)) {
            SheetHeader sheetHeader;
            ExcelFunctionRows excelFunctionRows = classRow.getAnnotation(ExcelFunctionRows.class);
            for (ExcelFunctionRow excelFunctionRow : excelFunctionRows.excelFunctions()) {
                sheetHeader = new SheetHeader();
                sheetHeader.setExcelColumn(excelFunctionRow.excelColumn());
                sheetHeader.setExcelCellLayout(excelFunctionRow.excelCellsLayout());
                sheetHeader.setExcelFunction(excelFunctionRow.excelFunction());
                listSheetHeader.add(sheetHeader);
            }
            for (Annotation annotation : excelFunctionRows.excelFunctionMerges()) {
                sheetHeader = new SheetHeader();
                sheetHeader.setExcelColumn(annotation.excelColumn());
                sheetHeader.setExcelCellLayout(annotation.excelCellsLayout());
                sheetHeader.setExcelFunction(annotation.excelFunction());
                sheetHeader.setExcelMergeRow(annotation.excelMergeRow());
                listSheetHeader.add(sheetHeader);
            }
        }
        Collections.sort(listSheetHeader, new SheetColumnComparator());
        return listSheetHeader;
    }

    protected boolean setCellValueWillMerged(Workbook workbook, CellStyle cellStyle, Cell cell, SheetHeader sheetHeader) throws Exception {
        this.setCellValueExcel(workbook, cell, cellStyle, sheetHeader);
        return false;
    }

    protected void mergeRowAndRemoveMap(Workbook workbook, Sheet worksheet, Integer indexRow, Map<Integer, MergeCell> mapMergeRow, int numColumn) throws Exception {
        this.mergeRow(workbook, worksheet, indexRow, mapMergeRow, numColumn);
        mapMergeRow.remove(numColumn);
    }

    protected void mergeRow(Workbook workbook, Sheet worksheet, Integer indexRow, Map<Integer, MergeCell> mapMergeRow, int numColumn) throws Exception {
        MergeCell mergeRow = mapMergeRow.get(numColumn);
        mergeRow.setRowEnd(indexRow - 1);
        this.runMergeCell(workbook, worksheet, mergeRow);
    }

    protected void runMergeCell(Workbook workbook, Sheet worksheet, MergeCell mergeCell) throws Exception {
        this.setCellValueExcel(workbook, worksheet, mergeCell);
        if (mergeCell.getRowStart() < mergeCell.getRowEnd() || mergeCell.getColumnFrom() < mergeCell.getColumnTo()) {
            worksheet.addMergedRegion(new CellRangeAddress(mergeCell.getRowStart(), mergeCell.getRowEnd(), mergeCell.getColumnFrom(), mergeCell.getColumnTo()));
        }
    }

    protected void addComment(Workbook workbook, Sheet worksheet, Row row, Cell cellHeader, String commento) {
        Drawing drawing = worksheet.createDrawingPatriarch();
        ClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, 0, 1, 1, 1);
        anchor.setCol1(cellHeader.getColumnIndex());
        anchor.setCol2(cellHeader.getColumnIndex() + 2);
        anchor.setRow1(row.getRowNum());
        anchor.setRow2(row.getRowNum() + 2);
        Comment comment = drawing.createCellComment(anchor);
        if (comment instanceof HSSFComment) {
            ((HSSFComment)comment).setWrapText(22);
        }
        comment.setString(workbook.getCreationHelper().createRichTextString(commento));
        cellHeader.setCellComment(comment);
    }

    protected void setCellSommario(Workbook workbook, Sheet worksheet, SheetSummary sheetSummary, SheetHeader sheetHeader, Row row) throws Exception {
        ExcelSummary excelSummary = ExcelUtils.getAnnotation(sheetSummary.getClass(), ExcelSummary.class);
        LayoutCell layoutCellSummary = ExcelUtils.reflectionAnnotation(new LayoutCell(), excelSummary.layout());
        CellStyle cellStyleColumn0 = this.createCellStyle(workbook, excelSummary.layout());
        Cell cellColumn0 = row.createCell(0);
        this.setCellStyleExcel(cellStyleColumn0, cellColumn0, layoutCellSummary);
        cellColumn0.setCellValue(this.valueProps.valueProps(sheetHeader.getExcelColumn().nameColumn()));
        if (StringUtils.isNotBlank((CharSequence)sheetHeader.getExcelColumn().comment())) {
            this.addComment(workbook, worksheet, row, cellColumn0, sheetHeader.getExcelColumn().comment());
        }
        ExcelCellLayout excelCellLayout = ExcelUtils.getAnnotation(sheetHeader.getField(), ExcelCellLayout.class);
        ExcelDate excelDate = null;
        if (sheetHeader.getValue() instanceof Date || sheetHeader.getValue() instanceof Calendar) {
            excelDate = sheetHeader.getExcelDate();
        }
        CellStyle cellStyleColumn1 = this.createCellStyle(workbook, excelCellLayout, excelDate);
        Cell cellColumn1 = row.createCell(1);
        this.setCellValueExcel(workbook, cellColumn1, cellStyleColumn1, sheetHeader);
    }

    protected void setCellValueExcel(Workbook workbook, Sheet worksheet, Cell cell, CellStyle cellStyle, SheetHeader sheetHeader, Integer indexRow, Integer calRowStart, Integer calRowEnd) throws Exception {
        if (sheetHeader.getExcelFunction() != null) {
            this.setCellFormulaExcel(cell, cellStyle, sheetHeader, indexRow, calRowStart, calRowEnd, worksheet);
        } else {
            this.setCellValueExcel(workbook, cell, cellStyle, sheetHeader);
        }
    }

    private void setCellFormulaExcel(Cell cell, CellStyle cellStyle, SheetHeader sheetHeader, Integer indexRow, Integer calRowStart, Integer calRowEnd, Sheet worksheet) throws Exception {
        LayoutCell layoutCell = sheetHeader.getLayoutCell();
        this.setCellStyleExcel(cellStyle, cell, layoutCell);
        ExcelFunction excelFunction = sheetHeader.getExcelFunction();
        String function = excelFunction.function();
        function = this.makeFunction(worksheet, indexRow, function, RowStartEndType.ROW_EMPTY);
        if (excelFunction.anotherTable() && calRowStart != null && calRowEnd != null) {
            function = this.makeFunction(worksheet, calRowStart, function, RowStartEndType.ROW_START);
            function = this.makeFunction(worksheet, calRowEnd, function, RowStartEndType.ROW_END);
        }
        function = this.makeFunction(worksheet, indexRow, function, RowStartEndType.ROW_START);
        function = this.makeFunction(worksheet, indexRow, function, RowStartEndType.ROW_END);
        function = this.makeFunction(worksheet, indexRow, function, RowStartEndType.ROW_HEADER);
        logger.debug((Object)("Function: " + function));
        cell.setCellFormula(function);
    }

    private String makeFunction(Sheet worksheet, Integer indexRow, String function, RowStartEndType rowStartEndType) {
        Pattern p = Pattern.compile(PATTERN);
        Matcher m = p.matcher(function);
        while (m.find()) {
            String parameter = m.group();
            String keyParameter = parameter.replace($, "").replace(rowStartEndType.getValue() + "}", "").trim();
            if (!this.mapFieldColumn.containsKey(ExcelUtils.getKeyColumn(worksheet, keyParameter))) continue;
            InfoColumn infoColumn = this.mapFieldColumn.get(ExcelUtils.getKeyColumn(worksheet, keyParameter));
            int row = indexRow;
            if (RowStartEndType.ROW_HEADER.equals((Object)rowStartEndType)) {
                row = infoColumn.getRowHeader();
            }
            if (keyParameter.contains(".")) {
                String nameSheet = keyParameter.substring(0, keyParameter.lastIndexOf("."));
                function = function.replace(parameter, "'" + nameSheet.replace("'", "''") + "'!" + ExcelUtils.calcoloCoordinateFunction(row + 1, infoColumn.getColumnNum()));
                continue;
            }
            function = function.replace(parameter, ExcelUtils.calcoloCoordinateFunction(row + 1, infoColumn.getColumnNum()));
        }
        return function;
    }

    private void setCellValueExcel(Workbook workbook, Sheet worksheet, MergeCell mergeRow) throws Exception {
        if (mergeRow.getSheetHeader().getExcelFunction() != null) {
            this.setCellFormulaExcel(worksheet, mergeRow);
        } else {
            this.setCellValueExcel(workbook, mergeRow.getCellFrom(), mergeRow.getCellStyleFrom(), mergeRow.getSheetHeader());
        }
    }

    private void setCellFormulaExcel(Sheet worksheet, MergeCell mergeRow) throws Exception {
        SheetHeader sheetHeader = mergeRow.getSheetHeader();
        CellStyle cellStyle = mergeRow.getCellStyleFrom();
        Cell cell = mergeRow.getCellFrom();
        LayoutCell layoutCell = sheetHeader.getLayoutCell();
        this.setCellStyleExcel(cellStyle, cell, layoutCell);
        ExcelFunction excelFunction = sheetHeader.getExcelFunction();
        String function = excelFunction.function();
        function = this.makeFunction(worksheet, mergeRow.getRowStart(), function, RowStartEndType.ROW_EMPTY);
        if (excelFunction.anotherTable() && mergeRow.getCalRowStart() != null && mergeRow.getCalRowEnd() != null) {
            function = this.makeFunction(worksheet, mergeRow.getCalRowStart(), function, RowStartEndType.ROW_START);
            function = this.makeFunction(worksheet, mergeRow.getCalRowEnd(), function, RowStartEndType.ROW_END);
        }
        function = this.makeFunction(worksheet, mergeRow.getRowStart(), function, RowStartEndType.ROW_START);
        function = this.makeFunction(worksheet, mergeRow.getRowEnd(), function, RowStartEndType.ROW_END);
        function = this.makeFunction(worksheet, mergeRow.getRowStart(), function, RowStartEndType.ROW_HEADER);
        logger.debug((Object)("Function: " + function));
        cell.setCellFormula(function);
    }

    protected void setCellValueExcel(Workbook workbook, Cell cell, CellStyle cellStyle, SheetHeader sheetHeader) throws Exception {
        LayoutCell layoutCell = sheetHeader.getLayoutCell();
        this.setCellStyleExcel(cellStyle, cell, layoutCell);
        if (sheetHeader.getValue() instanceof Date) {
            cell.setCellValue((Date)sheetHeader.getValue());
        } else if (sheetHeader.getValue() instanceof Calendar) {
            cell.setCellValue((Calendar)sheetHeader.getValue());
        } else if (sheetHeader.getValue() instanceof String || sheetHeader.getValue() instanceof Character) {
            String value = null;
            if (sheetHeader.getValue() != null) {
                value = "" + sheetHeader.getValue();
            }
            cell.setCellValue(value);
        } else if (sheetHeader.getValue() instanceof Number) {
            cell.setCellValue(((Number)sheetHeader.getValue()).doubleValue());
        } else if (sheetHeader.getValue() instanceof Boolean) {
            cell.setCellValue(((Boolean)sheetHeader.getValue()).booleanValue());
        } else if (sheetHeader.getValue() instanceof ExcelHyperlink) {
            ExcelHyperlink excelHyperlink = (ExcelHyperlink)sheetHeader.getValue();
            CreationHelper createHelper = workbook.getCreationHelper();
            if (excelHyperlink.getHyperlinkType() == null) {
                throw new Exception("The field hyperlinkType is null");
            }
            if (StringUtils.isEmpty((CharSequence)excelHyperlink.getAddress())) {
                throw new Exception("The field address is null or is empty");
            }
            Hyperlink hyperlink = createHelper.createHyperlink(excelHyperlink.getHyperlinkType());
            String address = excelHyperlink.getAddress();
            if (HyperlinkType.DOCUMENT.equals((Object)excelHyperlink.getHyperlinkType())) {
                address = excelHyperlink.getAddressDocument();
            }
            hyperlink.setAddress(address);
            cell.setHyperlink(hyperlink);
            cell.setCellValue(excelHyperlink.getValue());
        }
    }

    private CellStyle dateCellStyle(Workbook workbook, CellStyle cellStyle, String format) throws Exception {
        CreationHelper helper = workbook.getCreationHelper();
        cellStyle.setDataFormat(helper.createDataFormat().getFormat(format));
        return cellStyle;
    }

    protected void setCellStyleExcel(CellStyle cellStyle, Cell cell, LayoutCell layoutCell) {
        if (!this.mapCellStyle.containsKey(layoutCell)) {
            this.mapCellStyle.put(layoutCell, cellStyle);
        }
        cell.setCellStyle(this.mapCellStyle.get(layoutCell));
    }

    public CellStyle getCellStyleHeader(Workbook workbook, Sheet worksheet, SheetComponent sheet) throws Exception {
        ExcelHeaderLayout layoutHeader = ExcelUtils.getAnnotation(sheet.getClass(), ExcelHeaderLayout.class);
        ExcelMarginSheet excelMarginSheet = ExcelUtils.getAnnotation(sheet.getClass(), ExcelMarginSheet.class);
        ExcelSheetLayout layoutSheet = ExcelUtils.getAnnotation(sheet.getClass(), ExcelSheetLayout.class);
        worksheet.setMargin((short)0, excelMarginSheet.left());
        worksheet.setMargin((short)1, excelMarginSheet.right());
        worksheet.setMargin((short)2, excelMarginSheet.top());
        worksheet.setMargin((short)3, excelMarginSheet.bottom());
        worksheet.getPrintSetup().setLandscape(layoutSheet.landscape());
        worksheet.setDefaultColumnWidth(5 * layoutHeader.cmWidthCell());
        worksheet.setDefaultRowHeight((short)(layoutHeader.cmHeightCell() * 568));
        if (layoutSheet.order() > -1) {
            workbook.setSheetOrder(worksheet.getSheetName(), layoutSheet.order());
        }
        return this.manageCellStyleHeader(workbook, worksheet, layoutHeader, null);
    }

    private CellStyle manageCellStyleHeader(Workbook workbook, Sheet worksheet, ExcelHeaderLayout layoutHeader, Integer numColumn) {
        CellStyle cellStyleHeader = null;
        LayoutCell layoutCellHeader = ExcelUtils.reflectionAnnotation(new LayoutCell(), layoutHeader);
        if (this.mapCellHeaderStyle.containsKey(layoutCellHeader)) {
            cellStyleHeader = this.mapCellHeaderStyle.get(layoutCellHeader);
        } else {
            cellStyleHeader = this.createCellStyle(workbook, layoutHeader);
            if (numColumn != null && layoutHeader.cmWidthCell() != 5) {
                worksheet.setColumnWidth(numColumn.intValue(), 1306 * layoutHeader.cmWidthCell());
            }
            this.mapCellHeaderStyle.put(layoutCellHeader, cellStyleHeader);
        }
        return cellStyleHeader;
    }

    protected <T extends RowSheet> List<SheetHeader> generateHeaderSheetData(Workbook workbook, Sheet worksheet, Row rowHeader, SheetData<T> sheetData, Integer indexRow) throws Exception {
        ExcelSheetLayout excelSheetLayout = ExcelUtils.getAnnotation(sheetData.getClass(), ExcelSheetLayout.class);
        List<SheetHeader> listSheetHeader = this.getListSheetHeader(sheetData.getRowClass(), null);
        if (sheetData instanceof DynamicColumn) {
            DynamicColumn sheetDynamicData = (DynamicColumn)((Object)sheetData);
            for (String keyMap : sheetDynamicData.getMapExtraColumnAnnotation().keySet()) {
                ExtraColumnAnnotation extraColumnAnnotation = sheetDynamicData.getMapExtraColumnAnnotation().get(keyMap);
                if (extraColumnAnnotation.getExcelColumn().ignore()) continue;
                SheetHeader sheetHeader = new SheetHeader();
                sheetHeader.setExcelCellLayout(extraColumnAnnotation.getExcelCellLayout());
                sheetHeader.setExcelColumn(extraColumnAnnotation.getExcelColumn());
                sheetHeader.setExcelDate(extraColumnAnnotation.getExcelDate());
                sheetHeader.setExcelMergeRow(extraColumnAnnotation.getExcelMergeRow());
                sheetHeader.setExcelHeaderLayout(extraColumnAnnotation.getExcelHeaderLayout());
                if (extraColumnAnnotation.getExcelFunction() != null) {
                    sheetHeader.setExcelFunction(extraColumnAnnotation.getExcelFunction());
                }
                sheetHeader.setKeyMap(keyMap);
                listSheetHeader.add(sheetHeader);
            }
            Collections.sort(listSheetHeader, new SheetColumnComparator());
        }
        int idRowHeader = indexRow + 1;
        worksheet.setRepeatingRows(CellRangeAddress.valueOf((String)(idRowHeader + ":" + idRowHeader)));
        CellStyle cellStyleHeader = this.getCellStyleHeader(workbook, worksheet, sheetData);
        int maxColumn = listSheetHeader.size() + excelSheetLayout.startColumn();
        for (int columnNum = excelSheetLayout.startColumn(); columnNum < maxColumn; ++columnNum) {
            int indexHeader = columnNum - excelSheetLayout.startColumn();
            Cell cellHeader = rowHeader.createCell(columnNum);
            SheetHeader sheetHeader = listSheetHeader.get(indexHeader);
            if (sheetHeader.getField() != null && sheetHeader.getField().isAnnotationPresent(ExcelHeaderLayout.class) || sheetHeader.getExcelHeaderLayout() != null) {
                ExcelHeaderLayout layoutHeader = null;
                layoutHeader = sheetHeader.getExcelHeaderLayout() != null ? sheetHeader.getExcelHeaderLayout() : ExcelUtils.getAnnotation(sheetHeader.getField(), ExcelHeaderLayout.class);
                CellStyle differentCellStyleHeader = this.manageCellStyleHeader(workbook, worksheet, layoutHeader, columnNum);
                cellHeader.setCellStyle(differentCellStyleHeader);
            } else {
                cellHeader.setCellStyle(cellStyleHeader);
            }
            ExcelColumn excelColumn = listSheetHeader.get(indexHeader).getExcelColumn();
            listSheetHeader.get(indexHeader).setNumColumn(columnNum);
            cellHeader.setCellValue(this.valueProps.valueProps(excelColumn.nameColumn()));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{excelColumn.comment()})) {
                this.addComment(workbook, worksheet, rowHeader, cellHeader, excelColumn.comment());
            }
            InfoColumn infoColumn = new InfoColumn(worksheet, sheetHeader, columnNum, indexRow);
            if (sheetHeader.getField() != null) {
                this.mapFieldColumn.put(ExcelUtils.getKeyColumn(worksheet, sheetHeader.getField().getName()), infoColumn);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)sheetHeader.getKeyMap())) {
                this.mapFieldColumn.put(ExcelUtils.getKeyColumn(worksheet, sheetHeader.getKeyMap()), infoColumn);
                continue;
            }
            if (sheetHeader.getExcelFunction() == null) continue;
            this.mapFieldColumn.put(ExcelUtils.getKeyColumn(worksheet, sheetHeader.getExcelFunction().nameFunction()), infoColumn);
        }
        return listSheetHeader;
    }
}

