/*
 * Decompiled with CFR 0.152.
 */
package bld.generator.report.excel.impl;

import bld.generator.report.excel.BaseSheet;
import bld.generator.report.excel.DynamicChart;
import bld.generator.report.excel.DynamicRowSheet;
import bld.generator.report.excel.FunctionsTotal;
import bld.generator.report.excel.MergeSheet;
import bld.generator.report.excel.RowSheet;
import bld.generator.report.excel.ScopeGenerateExcel;
import bld.generator.report.excel.SheetComponent;
import bld.generator.report.excel.SheetData;
import bld.generator.report.excel.SheetFunctionTotal;
import bld.generator.report.excel.SheetSummary;
import bld.generator.report.excel.annotation.ExcelCellLayout;
import bld.generator.report.excel.annotation.ExcelChart;
import bld.generator.report.excel.annotation.ExcelCharts;
import bld.generator.report.excel.annotation.ExcelDate;
import bld.generator.report.excel.annotation.ExcelFreezePane;
import bld.generator.report.excel.annotation.ExcelLabel;
import bld.generator.report.excel.annotation.ExcelSheetLayout;
import bld.generator.report.excel.annotation.ExcelSummary;
import bld.generator.report.excel.data.InfoColumn;
import bld.generator.report.excel.data.LayoutCell;
import bld.generator.report.excel.data.MergeCell;
import bld.generator.report.excel.data.SheetHeader;
import bld.generator.report.excel.impl.ReportExcel;
import bld.generator.report.excel.impl.SuperGenerateExcelImpl;
import bld.generator.report.utils.ExcelUtils;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.HeaderFooter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ScopeGenerateExcelImpl
extends SuperGenerateExcelImpl
implements ScopeGenerateExcel {
    private static final Log logger = LogFactory.getLog(ScopeGenerateExcelImpl.class);
    @Value(value="${path.xls:}")
    private String pathCopertinaXls;
    @Value(value="${path.xlsx:}")
    private String pathCopertinaXlsx;
    @Value(value="${resource.path.xls:}")
    private String resourcePathCopertinaXls;
    @Value(value="${resource.path.xlsx:}")
    private String resourcePathCopertinaXlsx;

    @Override
    public byte[] createFileXls(ReportExcel report) throws Exception {
        this.mergeCalcoloCells = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byteExcel = null;
        boolean isCopertina = true;
        HSSFWorkbook workbook = null;
        if (StringUtils.isNotBlank((CharSequence)this.pathCopertinaXls)) {
            FileInputStream inputstream = new FileInputStream(this.pathCopertinaXls);
            workbook = new HSSFWorkbook((InputStream)inputstream);
        } else if (StringUtils.isNotBlank((CharSequence)this.resourcePathCopertinaXls)) {
            InputStream inputstream = this.getClass().getResourceAsStream(this.resourcePathCopertinaXls);
            workbook = new HSSFWorkbook(inputstream);
        } else {
            workbook = new HSSFWorkbook();
            isCopertina = false;
        }
        this.setParametriCopertina(report, byteArrayOutputStream, (Workbook)workbook, isCopertina);
        byteExcel = byteArrayOutputStream.toByteArray();
        return byteExcel;
    }

    @Override
    public byte[] createFileXlsx(ReportExcel report) throws Exception {
        this.mergeCalcoloCells = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byteExcel = null;
        boolean isCopertina = true;
        XSSFWorkbook workbook = null;
        if (StringUtils.isNotBlank((CharSequence)this.pathCopertinaXlsx)) {
            FileInputStream inputstream = new FileInputStream(this.pathCopertinaXlsx);
            workbook = new XSSFWorkbook((InputStream)inputstream);
        } else if (StringUtils.isNotBlank((CharSequence)this.resourcePathCopertinaXlsx)) {
            InputStream inputstream = this.getClass().getResourceAsStream(this.resourcePathCopertinaXlsx);
            workbook = new XSSFWorkbook(inputstream);
        } else {
            workbook = new XSSFWorkbook();
            isCopertina = false;
        }
        this.setParametriCopertina(report, byteArrayOutputStream, (Workbook)workbook, isCopertina);
        byteExcel = byteArrayOutputStream.toByteArray();
        return byteExcel;
    }

    private void setParametriCopertina(ReportExcel report, ByteArrayOutputStream byteArrayOutputStream, Workbook workbook, boolean isCopertina) throws Exception {
        if (isCopertina) {
            Sheet worksheet = workbook.getSheetAt(0);
            CellStyle style = workbook.getSheetAt(0).getColumnStyle(0);
            style.setWrapText(true);
            Cell cell = worksheet.getRow(11).getCell(0);
            cell.setCellValue(report.getTitolo());
            cell = worksheet.getRow(17).getCell(0);
            cell.setCellValue(SDF.format(new Date()));
        }
        workbook = this.createSheet(report, workbook);
        workbook.write((OutputStream)byteArrayOutputStream);
        workbook.close();
    }

    private Workbook createSheet(ReportExcel report, Workbook workbook) throws Exception {
        List<BaseSheet> listSheet = report.getListBaseSheet();
        int indiceNomeSheet = 0;
        this.mapCellStyle = new HashMap();
        this.mapCellHeaderStyle = new HashMap();
        this.mapFieldColumn = new HashMap();
        for (BaseSheet sheet : listSheet) {
            Sheet worksheet = null;
            worksheet = sheet.getNameSheet() != null ? (workbook.getSheet(sheet.getNameSheet()) == null && sheet.getNameSheet().length() <= 30 ? workbook.createSheet(sheet.getNameSheet().replace("/", "")) : workbook.createSheet(indiceNomeSheet++ + sheet.getNameSheet().replace("/", ""))) : workbook.createSheet("Don't defined" + indiceNomeSheet++);
            Footer footer = worksheet.getFooter();
            footer.setRight("Page " + HeaderFooter.page() + " of " + HeaderFooter.numPages());
            if (sheet instanceof MergeSheet) {
                this.generateMergeSheet(workbook, worksheet, (MergeSheet)sheet);
            } else if (sheet instanceof SheetSummary) {
                this.generateSheetSommario(workbook, worksheet, (SheetSummary)sheet, 0);
            } else if (sheet instanceof SheetData) {
                this.generateSheetData(workbook, worksheet, (SheetData)sheet, 0, false);
            }
            workbook.getCreationHelper().createFormulaEvaluator().evaluateAll();
            worksheet.setForceFormulaRecalculation(true);
        }
        return workbook;
    }

    private void generateMergeSheet(Workbook workbook, Sheet worksheet, MergeSheet mergeSheet) throws Exception {
        Integer indexRow = new Integer(0);
        for (SheetComponent sheetComponent : mergeSheet.getListSheet()) {
            sheetComponent.setNameSheet(worksheet.getSheetName());
            if (sheetComponent instanceof SheetSummary) {
                indexRow = this.generateSheetSommario(workbook, worksheet, (SheetSummary)sheetComponent, indexRow);
            } else if (sheetComponent instanceof SheetData) {
                indexRow = this.generateSheetData(workbook, worksheet, (SheetData)sheetComponent, indexRow, true);
            }
            indexRow = indexRow + 2;
        }
    }

    private Integer generateSheetSommario(Workbook workbook, Sheet worksheet, SheetSummary sheetSummary, Integer indexRow) throws Exception {
        Integer n;
        Class<?> classSheet = sheetSummary.getClass();
        ExcelSummary titleSummary = classSheet.getAnnotation(ExcelSummary.class);
        if (titleSummary != null && StringUtils.isNotBlank((CharSequence)titleSummary.title())) {
            CellStyle cellStyleHeader = this.getCellStyleHeader(workbook, worksheet, sheetSummary);
            Row rowHeader = worksheet.createRow(indexRow.intValue());
            Cell cellHeader = rowHeader.createCell(0);
            cellHeader.setCellStyle(cellStyleHeader);
            cellHeader.setCellValue(titleSummary.title());
            if (StringUtils.isNotBlank((CharSequence)titleSummary.comment())) {
                this.addComment(workbook, worksheet, rowHeader, cellHeader, titleSummary.comment());
            }
            cellHeader = rowHeader.createCell(1);
            cellHeader.setCellStyle(cellStyleHeader);
            worksheet.addMergedRegion(new CellRangeAddress(indexRow.intValue(), indexRow.intValue(), 0, 1));
            Integer n2 = indexRow;
            n = indexRow = Integer.valueOf(indexRow + 1);
        }
        List<SheetHeader> listSheetHeader = this.getListSheetHeader(classSheet, sheetSummary);
        Row row = null;
        for (SheetHeader sheetHeader : listSheetHeader) {
            row = worksheet.createRow(indexRow.intValue());
            this.setCellSommario(workbook, worksheet, sheetSummary, sheetHeader, row);
            n = indexRow;
            Integer n3 = indexRow = Integer.valueOf(indexRow + 1);
        }
        return indexRow;
    }

    private Integer generateSheetData(Workbook workbook, Sheet worksheet, SheetData<? extends RowSheet> sheetData, Integer indexRow, boolean isMergeSheet) throws Exception {
        FunctionsTotal functionsTotal;
        indexRow = this.writeLabel(workbook, worksheet, sheetData, indexRow);
        int startRowSheet = indexRow + 1;
        Row rowHeader = worksheet.createRow(indexRow.intValue());
        List<SheetHeader> listSheetHeader = this.generateHeaderSheetData(workbook, worksheet, rowHeader, sheetData, indexRow);
        Integer n = indexRow;
        Integer n2 = indexRow = Integer.valueOf(indexRow + 1);
        ExcelSheetLayout excelSheetLayout = ExcelUtils.getAnnotation(sheetData.getClass(), ExcelSheetLayout.class);
        boolean start = true;
        HashMap<Integer, MergeCell> mapMergeRow = new HashMap<Integer, MergeCell>();
        RowSheet lastRowSheet = null;
        LinkedHashMap<String, String> mapChart = new LinkedHashMap<String, String>();
        String startKey = null;
        String endKey = null;
        Integer calRowStart = null;
        Integer calRowEnd = null;
        if (sheetData instanceof SheetFunctionTotal) {
            SheetFunctionTotal functionSheetData = (SheetFunctionTotal)sheetData;
            calRowStart = functionSheetData.getCalRowStart();
            calRowEnd = functionSheetData.getCalRowEnd();
        }
        if (!isMergeSheet && sheetData.getClass().isAnnotationPresent(ExcelFreezePane.class)) {
            ExcelFreezePane excelFreezePane = sheetData.getClass().getAnnotation(ExcelFreezePane.class);
            worksheet.createFreezePane(excelFreezePane.columnFreez(), excelFreezePane.rowFreez());
        }
        Row row = null;
        int maxColumn = listSheetHeader.size() + excelSheetLayout.startColumn();
        for (RowSheet rowSheet : sheetData.getListRowSheet()) {
            row = worksheet.createRow(indexRow.intValue());
            HashMap<String, Object> mapValue = new HashMap<String, Object>();
            CellStyle cellStyle = null;
            for (int numColumn = excelSheetLayout.startColumn(); numColumn < maxColumn; ++numColumn) {
                int indexHeader = numColumn - excelSheetLayout.startColumn();
                Cell cell = row.createCell(numColumn);
                SheetHeader sheetHeader = listSheetHeader.get(indexHeader);
                Field field = listSheetHeader.get(indexHeader).getField();
                Object value = null;
                if (sheetHeader.getField() != null) {
                    value = new PropertyDescriptor(field.getName(), rowSheet.getClass()).getReadMethod().invoke((Object)rowSheet, new Object[0]);
                    mapValue.put(field.getName(), value);
                } else if (StringUtils.isNotBlank((CharSequence)sheetHeader.getKeyMap())) {
                    DynamicRowSheet dynamicRowSheet = (DynamicRowSheet)rowSheet;
                    value = dynamicRowSheet.getMapValue().get(sheetHeader.getKeyMap());
                    mapValue.put(sheetHeader.getKeyMap(), value);
                }
                sheetHeader.setValue(value);
                if (start) {
                    ExcelCellLayout excelCellLayout = sheetHeader.getExcelCellLayout();
                    ExcelDate excelDate = null;
                    LayoutCell layoutCell = ExcelUtils.reflectionAnnotation(new LayoutCell(), excelCellLayout);
                    if (field != null && (Date.class.isAssignableFrom(field.getType()) || Calendar.class.isAssignableFrom(field.getType()))) {
                        excelDate = sheetHeader.getExcelDate();
                        layoutCell = ExcelUtils.reflectionAnnotation(layoutCell, excelDate);
                    }
                    if (!this.mapCellStyle.containsKey(layoutCell)) {
                        this.mapCellStyle.put(layoutCell, this.createCellStyle(workbook, excelCellLayout, excelDate));
                    }
                    cellStyle = (CellStyle)this.mapCellStyle.get(layoutCell);
                }
                boolean repeat = true;
                do {
                    MergeCell mergeRow = null;
                    Object valueBefore = null;
                    if (excelSheetLayout.notMerge() || !mapMergeRow.containsKey(numColumn)) {
                        if (!excelSheetLayout.notMerge() && sheetHeader.getExcelMergeRow() != null) {
                            mergeRow = new MergeCell();
                            mergeRow.setRowStart(indexRow);
                            mergeRow.setColumnFrom(numColumn);
                            mergeRow.setColumnTo(numColumn);
                            mergeRow.setSheetHeader((SheetHeader)sheetHeader.clone());
                            if (sheetHeader.getExcelFunction() == null) {
                                mergeRow.getSheetHeader().setValue(value);
                            }
                            mergeRow.setCellFrom(cell);
                            mergeRow.setCellStyleFrom(cellStyle);
                            if (sheetData instanceof SheetFunctionTotal) {
                                mergeRow.setCalRowStart(calRowStart);
                                mergeRow.setCalRowEnd(calRowEnd);
                            }
                            mapMergeRow.put(numColumn, mergeRow);
                        } else {
                            super.setCellValueExcel(workbook, worksheet, cell, cellStyle, sheetHeader, indexRow, calRowStart, calRowEnd);
                        }
                        repeat = false;
                        continue;
                    }
                    if (numColumn > excelSheetLayout.startColumn() && StringUtils.isBlank((CharSequence)sheetHeader.getExcelMergeRow().referenceField())) {
                        throw new Exception("Only first column can have the propetie \"referenceColumn\" is blank!!!");
                    }
                    if (field != null) {
                        valueBefore = new PropertyDescriptor(field.getName(), lastRowSheet.getClass()).getReadMethod().invoke((Object)lastRowSheet, new Object[0]);
                    }
                    if (StringUtils.isBlank((CharSequence)sheetHeader.getExcelMergeRow().referenceField())) {
                        if (sheetHeader.getValue() != valueBefore && !sheetHeader.getValue().equals(valueBefore)) {
                            super.mergeRowAndRemoveMap(workbook, worksheet, indexRow, mapMergeRow, numColumn);
                            continue;
                        }
                        repeat = this.setCellValueWillMerged(workbook, cellStyle, cell, sheetHeader);
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)sheetHeader.getExcelMergeRow().referenceField())) continue;
                    String referenceField = sheetHeader.getExcelMergeRow().referenceField();
                    Object valueRefColumn = new PropertyDescriptor(referenceField, rowSheet.getClass()).getReadMethod().invoke((Object)rowSheet, new Object[0]);
                    Object valueRefColumnBefore = new PropertyDescriptor(referenceField, lastRowSheet.getClass()).getReadMethod().invoke((Object)lastRowSheet, new Object[0]);
                    if (valueRefColumn != null && valueRefColumnBefore != null && !valueRefColumn.equals(valueRefColumnBefore) || sheetHeader.getValue() != valueBefore && !sheetHeader.getValue().equals(valueBefore)) {
                        this.mergeRowAndRemoveMap(workbook, worksheet, indexRow, mapMergeRow, numColumn);
                        continue;
                    }
                    repeat = this.setCellValueWillMerged(workbook, cellStyle, cell, sheetHeader);
                } while (repeat);
            }
            lastRowSheet = rowSheet;
            if (sheetData.getClass().isAnnotationPresent(ExcelCharts.class) || sheetData instanceof DynamicChart && CollectionUtils.isNotEmpty(((DynamicChart)sheetData).getListExcelChart())) {
                List<ExcelChart> listExcelChart = this.getExcelChart(sheetData);
                for (ExcelChart excelChart : listExcelChart) {
                    startKey = ExcelUtils.calcoloCoordinateFunction(indexRow + 1, ((InfoColumn)this.mapFieldColumn.get(ExcelUtils.getKeyColumn(worksheet, excelChart.startKeyChart()))).getColumnNum());
                    endKey = ExcelUtils.calcoloCoordinateFunction(indexRow + 1, ((InfoColumn)this.mapFieldColumn.get(ExcelUtils.getKeyColumn(worksheet, excelChart.endKeyChart()))).getColumnNum());
                    String keyChart = mapValue.get(excelChart.fieldTitle()).toString();
                    mapChart.put(keyChart, startKey + ":" + endKey);
                }
            }
            start = false;
            Integer n3 = indexRow;
            Integer n4 = indexRow = Integer.valueOf(indexRow + 1);
        }
        for (Integer n5 : mapMergeRow.keySet()) {
            super.mergeRow(workbook, worksheet, indexRow, mapMergeRow, n5);
        }
        if (excelSheetLayout.notMerge() && excelSheetLayout.sortAndFilter()) {
            String startCell = ExcelUtils.calcoloCoordinateFunction(startRowSheet, excelSheetLayout.startColumn());
            String string = ExcelUtils.calcoloCoordinateFunction(indexRow, listSheetHeader.size() + excelSheetLayout.startColumn() - 1);
            logger.debug((Object)(sheetData.getClass().getSimpleName() + "- " + startCell + ":" + string));
            worksheet.setAutoFilter(CellRangeAddress.valueOf((String)(startCell + ":" + string)));
        }
        if (sheetData instanceof FunctionsTotal && (functionsTotal = (FunctionsTotal)((Object)sheetData)).getSheetFunctionsTotal() != null) {
            Object t = functionsTotal.getSheetFunctionsTotal();
            ((SheetFunctionTotal)t).setCalRowStart(startRowSheet);
            ((SheetFunctionTotal)t).setCalRowEnd(indexRow - 1);
            indexRow = indexRow + 2;
            indexRow = this.generateSheetData(workbook, worksheet, (SheetData<? extends RowSheet>)t, indexRow, isMergeSheet);
        }
        if (!isMergeSheet && worksheet instanceof XSSFSheet && (sheetData.getClass().isAnnotationPresent(ExcelCharts.class) || sheetData instanceof DynamicChart && CollectionUtils.isNotEmpty(((DynamicChart)sheetData).getListExcelChart()))) {
            List<ExcelChart> listExcelChart = this.getExcelChart(sheetData);
            for (ExcelChart excelChart : listExcelChart) {
                startKey = ExcelUtils.calcoloCoordinateFunction(startRowSheet, ((InfoColumn)this.mapFieldColumn.get(ExcelUtils.getKeyColumn(worksheet, excelChart.startKeyChart()))).getColumnNum());
                endKey = ExcelUtils.calcoloCoordinateFunction(startRowSheet, ((InfoColumn)this.mapFieldColumn.get(ExcelUtils.getKeyColumn(worksheet, excelChart.endKeyChart()))).getColumnNum());
                String xAxis = startKey + ":" + endKey;
                indexRow = indexRow + 2;
                indexRow = this.generateChart((XSSFSheet)worksheet, mapChart, excelChart, indexRow, xAxis);
            }
        }
        return indexRow;
    }

    private List<ExcelChart> getExcelChart(SheetData<? extends RowSheet> sheetData) {
        List<ExcelChart> listExcelChart = null;
        listExcelChart = sheetData.getClass().isAnnotationPresent(ExcelCharts.class) ? Arrays.asList(sheetData.getClass().getAnnotation(ExcelCharts.class).excelCharts()) : ((DynamicChart)sheetData).getListExcelChart();
        return listExcelChart;
    }

    private Integer generateChart(XSSFSheet worksheet, Map<String, String> mapChart, ExcelChart excelChart, Integer indexRow, String xAxis) {
        XSSFDrawing drawing = worksheet.createDrawingPatriarch();
        Integer startChart = indexRow;
        indexRow = indexRow + excelChart.sizeRow();
        logger.debug((Object)("Start Chart: " + startChart));
        XSSFClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, 0, startChart.intValue(), excelChart.sizeColumn(), indexRow.intValue());
        XSSFChart chart = drawing.createChart(anchor);
        XDDFChartLegend legend = chart.getOrAddLegend();
        legend.setPosition(excelChart.legendPosition());
        XDDFCategoryAxis bottomAxis = chart.createCategoryAxis(AxisPosition.BOTTOM);
        XDDFValueAxis leftAxis = chart.createValueAxis(AxisPosition.LEFT);
        logger.debug((Object)("xAxis: " + xAxis));
        XDDFCategoryDataSource xs = XDDFDataSourcesFactory.fromStringCellRange((XSSFSheet)worksheet, (CellRangeAddress)CellRangeAddress.valueOf((String)xAxis));
        XDDFChartData lineChartData = chart.createData(excelChart.chartTypes(), (XDDFChartAxis)bottomAxis, leftAxis);
        XDDFChartData.Series series = null;
        for (String keyChart : mapChart.keySet()) {
            String seriesChart = mapChart.get(keyChart);
            logger.debug((Object)("seriesChart: " + seriesChart));
            series = lineChartData.addSeries((XDDFDataSource)xs, XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)worksheet, (CellRangeAddress)CellRangeAddress.valueOf((String)seriesChart)));
            series.setTitle(keyChart, null);
            series.setShowLeaderLines(true);
        }
        lineChartData.setVaryColors(Boolean.valueOf(true));
        chart.plot(lineChartData);
        return indexRow;
    }

    private Integer writeLabel(Workbook workbook, Sheet worksheet, BaseSheet sheet, Integer indexRow) throws Exception {
        Class<?> classSheet = sheet.getClass();
        Set<Field> listField = ExcelUtils.getListField(classSheet);
        for (Field field : listField) {
            if (!field.isAnnotationPresent(ExcelLabel.class)) continue;
            Row row = worksheet.createRow(indexRow.intValue());
            ExcelLabel excelLabel = field.getAnnotation(ExcelLabel.class);
            Object value = new PropertyDescriptor(field.getName(), classSheet).getReadMethod().invoke((Object)sheet, new Object[0]);
            if (value == null) break;
            if (!(value instanceof String)) {
                throw new Exception(field.getName() + " field type is not supported: required String");
            }
            if (!StringUtils.isNotBlank((CharSequence)value.toString())) break;
            CellStyle cellStype = this.createCellStyle(workbook, excelLabel.labelLayout(), null);
            SheetHeader sheetHeader = new SheetHeader();
            sheetHeader.setValue(value);
            sheetHeader.setExcelCellLayout(excelLabel.labelLayout());
            Cell cellStart = row.createCell(0);
            MergeCell mergeColumn = new MergeCell();
            mergeColumn.setCellFrom(cellStart);
            mergeColumn.setCellStyleFrom(cellStype);
            mergeColumn.setSheetHeader(sheetHeader);
            mergeColumn.setRowStart(indexRow);
            mergeColumn.setRowEnd(indexRow);
            mergeColumn.setColumnFrom(0);
            mergeColumn.setColumnTo(excelLabel.columnMerge() - 1);
            for (int indexColumn = 1; indexColumn < excelLabel.columnMerge(); ++indexColumn) {
                Cell cell = row.createCell(indexColumn);
                cell.setCellStyle(cellStype);
            }
            this.runMergeCell(workbook, worksheet, mergeColumn);
            indexRow = indexRow + 2;
            break;
        }
        return indexRow;
    }
}

