/*
 * Decompiled with CFR 0.152.
 */
package bld.generator.report.excel.data;

import bld.generator.report.excel.annotation.ExcelCellLayout;
import bld.generator.report.excel.annotation.ExcelColumn;
import bld.generator.report.excel.annotation.ExcelDate;
import bld.generator.report.excel.annotation.ExcelFunction;
import bld.generator.report.excel.annotation.ExcelHeaderLayout;
import bld.generator.report.excel.annotation.ExcelMergeRow;
import bld.generator.report.excel.data.LayoutCell;
import bld.generator.report.utils.ExcelUtils;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;

public class SheetHeader
implements Cloneable {
    private Field field;
    private Object value;
    private int numColumn;
    private ExcelDate excelDate;
    private ExcelColumn excelColumn;
    private ExcelCellLayout excelCellLayout;
    private ExcelMergeRow excelMergeRow;
    private ExcelHeaderLayout excelHeaderLayout;
    private ExcelFunction excelFunction;
    private String keyMap;

    public SheetHeader() {
    }

    public SheetHeader(Field field, Object value) throws Exception {
        this.field = field;
        this.value = value;
        if (field.isAnnotationPresent(ExcelMergeRow.class)) {
            this.setExcelMergeRow(field.getAnnotation(ExcelMergeRow.class));
        }
        this.getExcelColumn();
    }

    public void setExcelDate(ExcelDate excelDate) {
        this.excelDate = excelDate;
    }

    public void setExcelColumn(ExcelColumn excelColumn) {
        this.excelColumn = excelColumn;
    }

    public void setExcelCellLayout(ExcelCellLayout excelCellLayout) {
        this.excelCellLayout = excelCellLayout;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public ExcelColumn getExcelColumn() throws Exception {
        if (this.excelColumn == null) {
            this.excelColumn = ExcelUtils.getAnnotation(this.field, ExcelColumn.class);
        }
        return this.excelColumn;
    }

    public ExcelDate getExcelDate() throws Exception {
        if (this.excelDate == null && (Date.class.isAssignableFrom(this.field.getType()) || Calendar.class.isAssignableFrom(this.field.getType()))) {
            this.excelDate = ExcelUtils.getAnnotation(this.field, ExcelDate.class);
        }
        return this.excelDate;
    }

    public ExcelCellLayout getExcelCellLayout() throws Exception {
        if (this.excelCellLayout == null) {
            this.excelCellLayout = ExcelUtils.getAnnotation(this.field, ExcelCellLayout.class);
        }
        return this.excelCellLayout;
    }

    public int getNumColumn() {
        return this.numColumn;
    }

    public void setNumColumn(int numColumn) {
        this.numColumn = numColumn;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public ExcelColumn excelColumn() {
        return this.excelColumn;
    }

    public ExcelMergeRow getExcelMergeRow() {
        return this.excelMergeRow;
    }

    public void setExcelMergeRow(ExcelMergeRow excelMergeRow) {
        this.excelMergeRow = excelMergeRow;
    }

    public String getKeyMap() {
        return this.keyMap;
    }

    public void setKeyMap(String keyMap) {
        this.keyMap = keyMap;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public LayoutCell getLayoutCell() throws Exception {
        LayoutCell layoutCell = null;
        if (this.getExcelCellLayout() != null) {
            layoutCell = ExcelUtils.reflectionAnnotation(new LayoutCell(), this.getExcelCellLayout());
        }
        try {
            if (this.getExcelDate() != null) {
                layoutCell = ExcelUtils.reflectionAnnotation(layoutCell, this.getExcelDate());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return layoutCell;
    }

    public ExcelFunction getExcelFunction() {
        return this.excelFunction;
    }

    public void setExcelFunction(ExcelFunction excelFunction) {
        this.excelFunction = excelFunction;
    }

    public ExcelHeaderLayout getExcelHeaderLayout() {
        return this.excelHeaderLayout;
    }

    public void setExcelHeaderLayout(ExcelHeaderLayout excelHeaderLayout) {
        this.excelHeaderLayout = excelHeaderLayout;
    }
}

