/*
 * Decompiled with CFR 0.152.
 */
package bld.generator.report.excel.annotation.impl;

import bld.generator.report.excel.annotation.ExcelBorder;
import bld.generator.report.excel.annotation.ExcelCellLayout;
import bld.generator.report.excel.annotation.ExcelFont;
import bld.generator.report.excel.annotation.ExcelRgbColor;
import bld.generator.report.excel.constant.ExcelConstant;
import java.lang.annotation.Annotation;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class ExcelCellLayoutImpl
implements Cloneable {
    protected boolean wrap;
    protected VerticalAlignment verticalAlignment;
    protected ExcelRgbColor rgbForeground;
    protected ExcelRgbColor rgbFont;
    protected int precision;
    protected HorizontalAlignment horizontalAlignment;
    protected ExcelFont font;
    protected FillPatternType fillPatternType;
    protected ExcelBorder border;

    public ExcelCellLayout getExcelCellLayout() {
        ExcelCellLayout excelCellLayout = new ExcelCellLayout(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ExcelCellLayout.class;
            }

            @Override
            public boolean wrap() {
                return ExcelCellLayoutImpl.this.wrap;
            }

            @Override
            public VerticalAlignment verticalAlignment() {
                return ExcelCellLayoutImpl.this.verticalAlignment;
            }

            @Override
            public ExcelRgbColor rgbForeground() {
                return ExcelCellLayoutImpl.this.rgbForeground;
            }

            @Override
            public ExcelRgbColor rgbFont() {
                return ExcelCellLayoutImpl.this.rgbFont;
            }

            @Override
            public int precision() {
                return ExcelCellLayoutImpl.this.precision;
            }

            @Override
            public HorizontalAlignment horizontalAlignment() {
                return ExcelCellLayoutImpl.this.horizontalAlignment;
            }

            @Override
            public ExcelFont font() {
                return ExcelCellLayoutImpl.this.font;
            }

            @Override
            public FillPatternType fillPatternType() {
                return ExcelCellLayoutImpl.this.fillPatternType;
            }

            @Override
            public ExcelBorder border() {
                return ExcelCellLayoutImpl.this.border;
            }
        };
        return excelCellLayout;
    }

    public ExcelCellLayoutImpl(boolean wrap, VerticalAlignment verticalAlignment, ExcelRgbColor rgbForeground, ExcelRgbColor rgbFont, int precision, HorizontalAlignment horizontalAlignment, ExcelFont font, FillPatternType fillPatternType, ExcelBorder border) {
        this.wrap = wrap;
        this.verticalAlignment = verticalAlignment;
        this.rgbForeground = rgbForeground;
        this.rgbFont = rgbFont;
        this.precision = precision;
        this.horizontalAlignment = horizontalAlignment;
        this.font = font;
        this.fillPatternType = fillPatternType;
        this.border = border;
    }

    public ExcelCellLayoutImpl() {
        this.wrap = true;
        this.verticalAlignment = VerticalAlignment.CENTER;
        this.rgbForeground = ExcelConstant.RGB_FOREGROUND.getExcelRgbColor();
        this.rgbFont = ExcelConstant.RGB_FONT.getExcelRgbColor();
        this.precision = -1;
        this.horizontalAlignment = HorizontalAlignment.RIGHT;
        this.font = ExcelConstant.FONT.getExcelFont();
        this.fillPatternType = FillPatternType.SOLID_FOREGROUND;
        this.border = ExcelConstant.BORDER.getExcelBorder();
    }

    public String toString() {
        return "ExcelCellLayoutImpl [wrap=" + this.wrap + ", verticalAlignment=" + this.verticalAlignment + ", rgbForeground=" + this.rgbForeground + ", rgbFont=" + this.rgbFont + ", precision=" + this.precision + ", horizontalAlignment=" + this.horizontalAlignment + ", font=" + this.font + ", fillPatternType=" + this.fillPatternType + ", border=" + this.border + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.border == null ? 0 : this.border.hashCode());
        result = 31 * result + (this.fillPatternType == null ? 0 : this.fillPatternType.hashCode());
        result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
        result = 31 * result + (this.horizontalAlignment == null ? 0 : this.horizontalAlignment.hashCode());
        result = 31 * result + this.precision;
        result = 31 * result + (this.rgbFont == null ? 0 : this.rgbFont.hashCode());
        result = 31 * result + (this.rgbForeground == null ? 0 : this.rgbForeground.hashCode());
        result = 31 * result + (this.verticalAlignment == null ? 0 : this.verticalAlignment.hashCode());
        result = 31 * result + (this.wrap ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExcelCellLayoutImpl other = (ExcelCellLayoutImpl)obj;
        if (this.border == null ? other.border != null : !this.border.equals(other.border)) {
            return false;
        }
        if (this.fillPatternType != other.fillPatternType) {
            return false;
        }
        if (this.font == null ? other.font != null : !this.font.equals(other.font)) {
            return false;
        }
        if (this.horizontalAlignment != other.horizontalAlignment) {
            return false;
        }
        if (this.precision != other.precision) {
            return false;
        }
        if (this.rgbFont == null ? other.rgbFont != null : !this.rgbFont.equals(other.rgbFont)) {
            return false;
        }
        if (this.rgbForeground == null ? other.rgbForeground != null : !this.rgbForeground.equals(other.rgbForeground)) {
            return false;
        }
        if (this.verticalAlignment != other.verticalAlignment) {
            return false;
        }
        return this.wrap == other.wrap;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public ExcelRgbColor getRgbForeground() {
        return this.rgbForeground;
    }

    public void setRgbForeground(ExcelRgbColor rgbForeground) {
        this.rgbForeground = rgbForeground;
    }

    public ExcelRgbColor getRgbFont() {
        return this.rgbFont;
    }

    public void setRgbFont(ExcelRgbColor rgbFont) {
        this.rgbFont = rgbFont;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public ExcelFont getFont() {
        return this.font;
    }

    public void setFont(ExcelFont font) {
        this.font = font;
    }

    public FillPatternType getFillPatternType() {
        return this.fillPatternType;
    }

    public void setFillPatternType(FillPatternType fillPatternType) {
        this.fillPatternType = fillPatternType;
    }

    public ExcelBorder getBorder() {
        return this.border;
    }

    public void setBorder(ExcelBorder border) {
        this.border = border;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

