/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.csv;

import blasd.apex.csv.IZeroCopyConsumer;
import blasd.apex.csv.IZeroCopyDoubleConsumer;
import blasd.apex.csv.IZeroCopyIntConsumer;
import blasd.apex.csv.IZeroCopyLongConsumer;
import com.google.common.primitives.Ints;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleBinaryOperator;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.LongBinaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCopyConsumers {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ZeroCopyConsumers.class);

    public static IZeroCopyConsumer intConsumer(IntConsumer intConsumer) {
        return ZeroCopyConsumers.intBinaryOperator((rowIndex, r) -> {
            intConsumer.accept(r);
            return rowIndex;
        });
    }

    public static IZeroCopyConsumer intBinaryOperator(final IntBinaryOperator rowAndValueOperator) {
        final AtomicLong rowIndex = new AtomicLong();
        return new IZeroCopyIntConsumer(){

            @Override
            public void nextRowIsMissing() {
                rowIndex.incrementAndGet();
                LOGGER.trace("No data for row #{}", (Object)rowIndex);
            }

            @Override
            public void nextRowIsInvalid(CharSequence charSequence) {
                rowIndex.incrementAndGet();
                LOGGER.trace("Invalid data for row #{}: {}", (Object)rowIndex, (Object)charSequence);
            }

            @Override
            public void accept(int value) {
                rowAndValueOperator.applyAsInt(Ints.checkedCast((long)rowIndex.get()), value);
                rowIndex.incrementAndGet();
            }

            @Override
            public long nextValueRowIndex() {
                return rowIndex.get();
            }
        };
    }

    public static IZeroCopyConsumer longBinaryOperator(final LongBinaryOperator intBinaryOperator) {
        final AtomicLong rowIndex = new AtomicLong();
        return new IZeroCopyLongConsumer(){

            @Override
            public void nextRowIsMissing() {
                rowIndex.incrementAndGet();
                LOGGER.trace("No data for row #{}", (Object)rowIndex);
            }

            @Override
            public void nextRowIsInvalid(CharSequence charSequence) {
                rowIndex.incrementAndGet();
                LOGGER.trace("Invalid data for row #{}: {}", (Object)rowIndex, (Object)charSequence);
            }

            @Override
            public void accept(long value) {
                intBinaryOperator.applyAsLong(rowIndex.get(), value);
                rowIndex.incrementAndGet();
            }

            @Override
            public long nextValueRowIndex() {
                return rowIndex.get();
            }
        };
    }

    public static IZeroCopyConsumer doubleBinaryOperator(final DoubleBinaryOperator intBinaryOperator) {
        final AtomicLong rowIndex = new AtomicLong();
        return new IZeroCopyDoubleConsumer(){

            @Override
            public void nextRowIsMissing() {
                rowIndex.incrementAndGet();
                LOGGER.trace("No data for row #{}", (Object)rowIndex);
            }

            @Override
            public void nextRowIsInvalid(CharSequence charSequence) {
                rowIndex.incrementAndGet();
                LOGGER.trace("Invalid data for row #{}: {}", (Object)rowIndex, (Object)charSequence);
            }

            @Override
            public void accept(double value) {
                intBinaryOperator.applyAsDouble(rowIndex.get(), value);
                rowIndex.incrementAndGet();
            }

            @Override
            public long nextValueRowIndex() {
                return rowIndex.get();
            }
        };
    }
}

