/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.csv;

import blasd.apex.core.primitive.ApexParserHelper;
import blasd.apex.core.primitive.Jdk9CharSequenceParsers;
import blasd.apex.csv.IZeroCopyCSVParser;
import blasd.apex.csv.IZeroCopyConsumer;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.CharBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCopyCSVParser
implements IZeroCopyCSVParser {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ZeroCopyCSVParser.class);
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    protected final int bufferSize;

    public ZeroCopyCSVParser() {
        this.bufferSize = 1024;
    }

    public ZeroCopyCSVParser(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public void parse(Reader reader, char separator, List<IZeroCopyConsumer> consumers) throws IOException {
        consumers.stream().filter(Objects::nonNull).forEach(consumer -> {
            if (consumer instanceof IntConsumer) {
                LOGGER.trace("We like IntConsumer");
            } else if (consumer instanceof LongConsumer) {
                LOGGER.trace("We like LongConsumer");
            } else if (consumer instanceof DoubleConsumer) {
                LOGGER.trace("We like DoubleConsumer");
            } else if (consumer instanceof Consumer) {
                LOGGER.trace("We hope it is a Consumer<CharSequence>");
            } else {
                throw new IllegalArgumentException("You need to be any java.util.function.*Consumer");
            }
        });
        IntFunction<IZeroCopyConsumer> indexToConsumer = index -> {
            if (index < consumers.size()) {
                return (IZeroCopyConsumer)consumers.get(index);
            }
            return null;
        };
        CharBuffer charBuffer = CharBuffer.allocate(this.bufferSize);
        CharBuffer nextValue = CharBuffer.allocate(this.bufferSize);
        charBuffer.position(charBuffer.limit());
        boolean moreToRead = true;
        int columnIndex = -1;
        char[] buffer = new char[charBuffer.capacity()];
        while (moreToRead) {
            charBuffer.compact();
            int nbRead = reader.read(buffer, 0, Math.min(buffer.length, charBuffer.remaining()));
            if (nbRead > 0) {
                charBuffer.put(buffer, 0, nbRead);
            }
            if (nbRead == 0) {
                throw new IllegalStateException("Unable to read data");
            }
            charBuffer.flip();
            if (nbRead < 0) {
                moreToRead = false;
            }
            while (charBuffer.hasRemaining()) {
                char nextChar = charBuffer.get();
                if (nextChar == separator) {
                    columnIndex = this.flushColumn(indexToConsumer, nextValue, columnIndex, true);
                    continue;
                }
                if (nextChar == '\r' || nextChar == '\n') {
                    columnIndex = this.flushColumn(indexToConsumer, nextValue, columnIndex, false);
                    this.warnConsumersWithoutColumn(indexToConsumer, columnIndex, consumers.size());
                    columnIndex = -1;
                    continue;
                }
                if (columnIndex < 0 && nextValue.position() == 0) {
                    ++columnIndex;
                }
                nextValue.put(nextChar);
            }
            if (moreToRead) continue;
            columnIndex = this.flushColumn(indexToConsumer, nextValue, columnIndex, false);
            this.warnConsumersWithoutColumn(indexToConsumer, columnIndex, consumers.size());
        }
    }

    public Stream<String[]> parseAsStringArrays(final Reader reader, final char separator) {
        final CharBuffer charBuffer = CharBuffer.allocate(this.bufferSize);
        charBuffer.position(charBuffer.limit());
        final AtomicBoolean moreToRead = new AtomicBoolean(true);
        final AtomicInteger columnIndex = new AtomicInteger(0);
        final char[] buffer = new char[charBuffer.capacity()];
        final CharBuffer nextValue = CharBuffer.allocate(this.bufferSize);
        final LinkedList pendingStrings = new LinkedList();
        Youpi consumer = new Youpi(pendingStrings);
        final IntFunction<IZeroCopyConsumer> indexToConsumer = index -> consumer;
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<String[]>(Long.MAX_VALUE, 0){

            @Override
            public boolean tryAdvance(Consumer<? super String[]> action) {
                boolean actionHasBeenTriggered = false;
                while ((moreToRead.get() || charBuffer.hasRemaining()) && !actionHasBeenTriggered) {
                    this.fillBuffer(reader, charBuffer, moreToRead, buffer);
                    while (charBuffer.hasRemaining() && !actionHasBeenTriggered) {
                        actionHasBeenTriggered = this.processBuffer(separator, charBuffer, columnIndex, nextValue, pendingStrings, indexToConsumer, action);
                    }
                    if (moreToRead.get() || charBuffer.hasRemaining() || actionHasBeenTriggered) continue;
                    columnIndex.set(ZeroCopyCSVParser.this.flushColumn(indexToConsumer, nextValue, columnIndex.get(), false));
                    ZeroCopyCSVParser.this.warnConsumersWithoutColumn(indexToConsumer, columnIndex.get(), -1);
                }
                return actionHasBeenTriggered;
            }

            protected void fillBuffer(Reader reader2, CharBuffer charBuffer2, AtomicBoolean moreToRead2, char[] buffer2) {
                if (moreToRead2.get() && !charBuffer2.hasRemaining()) {
                    int nbRead;
                    charBuffer2.compact();
                    try {
                        nbRead = reader2.read(buffer2, 0, Math.min(buffer2.length, charBuffer2.remaining()));
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    if (nbRead > 0) {
                        charBuffer2.put(buffer2, 0, nbRead);
                    }
                    if (nbRead == 0) {
                        throw new IllegalStateException("Unable to read data");
                    }
                    charBuffer2.flip();
                    if (nbRead < 0) {
                        moreToRead2.set(false);
                    }
                }
            }

            protected boolean processBuffer(char separator2, CharBuffer charBuffer2, AtomicInteger columnIndex2, CharBuffer nextValue2, List<String> pendingStrings2, IntFunction<IZeroCopyConsumer> indexToConsumer2, Consumer<? super String[]> action) {
                boolean actionHasBeenTriggered = false;
                char nextChar = charBuffer2.get();
                if (nextChar == separator2) {
                    columnIndex2.set(ZeroCopyCSVParser.this.flushColumn(indexToConsumer2, nextValue2, columnIndex2.get(), true));
                } else if (nextChar == '\r' || nextChar == '\n') {
                    columnIndex2.set(ZeroCopyCSVParser.this.flushColumn(indexToConsumer2, nextValue2, columnIndex2.get(), false));
                    ZeroCopyCSVParser.this.warnConsumersWithoutColumn(indexToConsumer2, columnIndex2.get(), -1);
                    if (!pendingStrings2.isEmpty()) {
                        if (action != null) {
                            action.accept((String[])pendingStrings2.toArray(new String[pendingStrings2.size()]));
                        }
                        pendingStrings2.clear();
                        actionHasBeenTriggered = true;
                    }
                    columnIndex2.set(-1);
                } else {
                    if (columnIndex2.get() < 0 && nextValue2.position() == 0) {
                        columnIndex2.incrementAndGet();
                    }
                    nextValue2.put(nextChar);
                }
                return actionHasBeenTriggered;
            }
        }, false);
    }

    protected void warnConsumersWithoutColumn(IntFunction<IZeroCopyConsumer> consumers, int columnIndex, int maxIndex) {
        if (columnIndex < 0) {
            return;
        }
        for (int i = columnIndex; i < maxIndex; ++i) {
            IZeroCopyConsumer consumer = consumers.apply(i);
            if (consumer == null) continue;
            consumer.nextRowIsMissing();
        }
    }

    protected int flushColumn(IntFunction<IZeroCopyConsumer> consumers, CharBuffer nextValue, int flushedColumnIndex, boolean hasMoreSameRow) {
        if (flushedColumnIndex <= -1) {
            assert (nextValue.position() == 0);
            if (hasMoreSameRow) {
                IZeroCopyConsumer consumer = consumers.apply(0);
                if (consumer != null) {
                    consumer.nextRowIsMissing();
                }
                return 1;
            }
            return -1;
        }
        nextValue.flip();
        IZeroCopyConsumer consumer = consumers.apply(flushedColumnIndex);
        if (consumer != null) {
            if (nextValue.hasRemaining()) {
                this.flushContent(consumer, nextValue, flushedColumnIndex);
            } else {
                consumer.nextRowIsMissing();
            }
        }
        nextValue.limit(nextValue.position());
        nextValue.compact();
        return flushedColumnIndex + 1;
    }

    protected void flushContent(IZeroCopyConsumer consumer, CharSequence charBuffer, int columnIndex) {
        block14: {
            if (consumer == null) {
                return;
            }
            CharSequence subSequence = charBuffer;
            try {
                if (consumer instanceof IntConsumer) {
                    if (subSequence.length() == 0) {
                        consumer.nextRowIsMissing();
                    } else {
                        ((IntConsumer)((Object)consumer)).accept(Jdk9CharSequenceParsers.parseInt((CharSequence)subSequence, (int)0, (int)charBuffer.length(), (int)10));
                    }
                    break block14;
                }
                if (consumer instanceof LongConsumer) {
                    if (subSequence.length() == 0) {
                        consumer.nextRowIsMissing();
                    } else {
                        ((LongConsumer)((Object)consumer)).accept(Jdk9CharSequenceParsers.parseLong((CharSequence)subSequence, (int)0, (int)charBuffer.length(), (int)10));
                    }
                    break block14;
                }
                if (consumer instanceof DoubleConsumer) {
                    if (subSequence.length() == 0) {
                        consumer.nextRowIsMissing();
                    } else {
                        ((DoubleConsumer)((Object)consumer)).accept(ApexParserHelper.parseDouble((CharSequence)subSequence));
                    }
                    break block14;
                }
                if (consumer instanceof Consumer) {
                    ((Consumer)((Object)consumer)).accept(subSequence);
                    break block14;
                }
                throw new IllegalArgumentException("Not a consumer ?!");
            }
            catch (NumberFormatException e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Ouch on " + subSequence, (Throwable)e);
                }
                consumer.nextRowIsInvalid(subSequence);
            }
        }
    }

    private final class Youpi
    implements IZeroCopyConsumer,
    Consumer<CharSequence> {
        private final List<String> pendingStrings;

        private Youpi(List<String> pendingStrings) {
            this.pendingStrings = pendingStrings;
        }

        @Override
        public void nextRowIsMissing() {
            this.pendingStrings.add("");
        }

        @Override
        public void nextRowIsInvalid(CharSequence charSequence) {
            this.pendingStrings.add(charSequence.toString());
        }

        @Override
        public void accept(CharSequence t) {
            this.pendingStrings.add(t.toString());
        }
    }
}

