/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.csv;

import com.google.common.base.CharMatcher;
import java.util.Comparator;
import java.util.Optional;
import java.util.OptionalInt;

public class CsvFormatHelper {
    protected CsvFormatHelper() {
    }

    public static String defaultSeparatorCandidates() {
        return ";,|\t";
    }

    public static OptionalInt guessSeparator(String row) {
        return CsvFormatHelper.guessSeparator(CharMatcher.anyOf((CharSequence)CsvFormatHelper.defaultSeparatorCandidates()), row);
    }

    public static OptionalInt guessSeparator(CharMatcher allowedSeparators, String row) {
        if (row == null || row.isEmpty()) {
            return OptionalInt.empty();
        }
        String candidateSeparators = allowedSeparators.retainFrom((CharSequence)row);
        Optional<Integer> optMax = candidateSeparators.chars().mapToObj(Integer::valueOf).max(Comparator.comparing(i -> CharMatcher.is((char)((char)i.intValue())).countIn((CharSequence)row)));
        if (optMax.isPresent()) {
            int max = optMax.get();
            return OptionalInt.of(max);
        }
        return OptionalInt.empty();
    }
}

