/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.miniapp.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaRedisBetterConfigImpl;
import com.binarywang.spring.starter.wxjava.miniapp.properties.ConfigStorage;
import com.binarywang.spring.starter.wxjava.miniapp.properties.RedisProperties;
import com.binarywang.spring.starter.wxjava.miniapp.properties.WxMaProperties;
import me.chanjar.weixin.common.redis.JedisWxRedisOps;
import me.chanjar.weixin.common.redis.RedisTemplateWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.util.Pool;

@Configuration
@ConditionalOnClass(value={WxMaService.class})
@EnableConfigurationProperties(value={WxMaProperties.class})
@ConditionalOnProperty(prefix="wx.miniapp", value={"enabled"}, matchIfMissing=true)
public class WxMaAutoConfiguration {
    private final WxMaProperties wxMaProperties;
    private final ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(value={WxMaService.class})
    public WxMaService service(WxMaConfig wxMaConfig) {
        WxMaServiceImpl service = new WxMaServiceImpl();
        service.setWxMaConfig(wxMaConfig);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean(value={WxMaConfig.class})
    public WxMaConfig wxMaConfig() {
        WxMaDefaultConfigImpl config;
        switch (this.wxMaProperties.getConfigStorage().getType()) {
            case Jedis: {
                config = this.wxMaJedisConfigStorage();
                break;
            }
            case RedisTemplate: {
                config = this.wxMaRedisTemplateConfigStorage();
                break;
            }
            default: {
                config = this.wxMaDefaultConfigStorage();
            }
        }
        config.setAppid(StringUtils.trimToNull((String)this.wxMaProperties.getAppid()));
        config.setSecret(StringUtils.trimToNull((String)this.wxMaProperties.getSecret()));
        config.setToken(StringUtils.trimToNull((String)this.wxMaProperties.getToken()));
        config.setAesKey(StringUtils.trimToNull((String)this.wxMaProperties.getAesKey()));
        config.setMsgDataFormat(StringUtils.trimToNull((String)this.wxMaProperties.getMsgDataFormat()));
        ConfigStorage configStorageProperties = this.wxMaProperties.getConfigStorage();
        config.setHttpProxyHost(configStorageProperties.getHttpProxyHost());
        config.setHttpProxyUsername(configStorageProperties.getHttpProxyUsername());
        config.setHttpProxyPassword(configStorageProperties.getHttpProxyPassword());
        if (configStorageProperties.getHttpProxyPort() != null) {
            config.setHttpProxyPort(configStorageProperties.getHttpProxyPort().intValue());
        }
        return config;
    }

    private WxMaDefaultConfigImpl wxMaDefaultConfigStorage() {
        return new WxMaDefaultConfigImpl();
    }

    private WxMaDefaultConfigImpl wxMaJedisConfigStorage() {
        RedisProperties redisProperties = this.wxMaProperties.getConfigStorage().getRedis();
        JedisPool jedisPool = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getJedisPool() : (JedisPool)this.applicationContext.getBean(JedisPool.class);
        JedisWxRedisOps redisOps = new JedisWxRedisOps((Pool)jedisPool);
        return new WxMaRedisBetterConfigImpl((WxRedisOps)redisOps, this.wxMaProperties.getConfigStorage().getKeyPrefix());
    }

    private WxMaDefaultConfigImpl wxMaRedisTemplateConfigStorage() {
        StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        RedisTemplateWxRedisOps redisOps = new RedisTemplateWxRedisOps(redisTemplate);
        return new WxMaRedisBetterConfigImpl((WxRedisOps)redisOps, this.wxMaProperties.getConfigStorage().getKeyPrefix());
    }

    private JedisPool getJedisPool() {
        ConfigStorage storage = this.wxMaProperties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        return new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
    }

    public WxMaAutoConfiguration(WxMaProperties wxMaProperties, ApplicationContext applicationContext) {
        this.wxMaProperties = wxMaProperties;
        this.applicationContext = applicationContext;
    }
}

