/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.solon.wxjava.miniapp.config.storage;

import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaRedissonConfigImpl;
import com.binarywang.solon.wxjava.miniapp.config.storage.AbstractWxMaConfigStorageConfiguration;
import com.binarywang.solon.wxjava.miniapp.properties.RedisProperties;
import com.binarywang.solon.wxjava.miniapp.properties.WxMaProperties;
import org.apache.commons.lang3.StringUtils;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.core.AppContext;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.TransportMode;

@Configuration
@Condition(onProperty="${wx.miniapp.configStorage.type} = redisson", onClass=Redisson.class)
public class WxMaInRedissonConfigStorageConfiguration
extends AbstractWxMaConfigStorageConfiguration {
    private final WxMaProperties properties;
    private final AppContext applicationContext;

    @Bean
    @Condition(onMissingBean=WxMaConfig.class)
    public WxMaConfig wxMaConfig() {
        WxMaRedissonConfigImpl config = this.getWxMaInRedissonConfigStorage();
        return this.config((WxMaDefaultConfigImpl)config, this.properties);
    }

    private WxMaRedissonConfigImpl getWxMaInRedissonConfigStorage() {
        RedisProperties redisProperties = this.properties.getConfigStorage().getRedis();
        RedissonClient redissonClient = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getRedissonClient() : (RedissonClient)this.applicationContext.getBean(RedissonClient.class);
        return new WxMaRedissonConfigImpl(redissonClient, this.properties.getConfigStorage().getKeyPrefix());
    }

    private RedissonClient getRedissonClient() {
        WxMaProperties.ConfigStorage storage = this.properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + redis.getHost() + ":" + redis.getPort()).setDatabase(redis.getDatabase()).setPassword(redis.getPassword());
        config.setTransportMode(TransportMode.NIO);
        return Redisson.create((Config)config);
    }

    public WxMaInRedissonConfigStorageConfiguration(WxMaProperties properties, AppContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }
}

