/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.miniapp.configuration.services;

import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaRedisConfigImpl;
import com.binarywang.spring.starter.wxjava.miniapp.configuration.services.AbstractWxMaConfiguration;
import com.binarywang.spring.starter.wxjava.miniapp.properties.WxMaMultiProperties;
import com.binarywang.spring.starter.wxjava.miniapp.properties.WxMaMultiRedisProperties;
import com.binarywang.spring.starter.wxjava.miniapp.service.WxMaMultiServices;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@ConditionalOnProperty(prefix="wx.ma.config-storage", name={"type"}, havingValue="jedis")
public class WxMaInJedisConfiguration
extends AbstractWxMaConfiguration {
    private final WxMaMultiProperties wxMaMultiProperties;
    private final ApplicationContext applicationContext;

    @Bean
    public WxMaMultiServices wxMaMultiServices() {
        return this.wxMaMultiServices(this.wxMaMultiProperties);
    }

    @Override
    protected WxMaDefaultConfigImpl wxMaConfigStorage(WxMaMultiProperties wxMaMultiProperties) {
        return this.configRedis(wxMaMultiProperties);
    }

    private WxMaDefaultConfigImpl configRedis(WxMaMultiProperties wxMaMultiProperties) {
        WxMaMultiRedisProperties wxMaMultiRedisProperties = wxMaMultiProperties.getConfigStorage().getRedis();
        JedisPool jedisPool = wxMaMultiRedisProperties != null && StringUtils.isNotEmpty((CharSequence)wxMaMultiRedisProperties.getHost()) ? this.getJedisPool(wxMaMultiProperties) : (JedisPool)this.applicationContext.getBean(JedisPool.class);
        return new WxMaRedisConfigImpl(jedisPool);
    }

    private JedisPool getJedisPool(WxMaMultiProperties wxMaMultiProperties) {
        WxMaMultiProperties.ConfigStorage storage = wxMaMultiProperties.getConfigStorage();
        WxMaMultiRedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        return new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
    }

    public WxMaInJedisConfiguration(WxMaMultiProperties wxMaMultiProperties, ApplicationContext applicationContext) {
        this.wxMaMultiProperties = wxMaMultiProperties;
        this.applicationContext = applicationContext;
    }
}

