/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.cp.configuration.services;

import com.binarywang.spring.starter.wxjava.cp.configuration.services.AbstractWxCpConfiguration;
import com.binarywang.spring.starter.wxjava.cp.properties.WxCpMultiProperties;
import com.binarywang.spring.starter.wxjava.cp.properties.WxCpMultiRedisProperties;
import com.binarywang.spring.starter.wxjava.cp.service.WxCpMultiServices;
import me.chanjar.weixin.cp.config.impl.WxCpDefaultConfigImpl;
import me.chanjar.weixin.cp.config.impl.WxCpRedissonConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.TransportMode;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="wx.cp.config-storage", name={"type"}, havingValue="redisson")
public class WxCpInRedissonConfiguration
extends AbstractWxCpConfiguration {
    private final WxCpMultiProperties wxCpMultiProperties;
    private final ApplicationContext applicationContext;

    @Bean
    public WxCpMultiServices wxCpMultiServices() {
        return this.wxCpMultiServices(this.wxCpMultiProperties);
    }

    @Override
    protected WxCpDefaultConfigImpl wxCpConfigStorage(WxCpMultiProperties wxCpMultiProperties) {
        return this.configRedisson(wxCpMultiProperties);
    }

    private WxCpDefaultConfigImpl configRedisson(WxCpMultiProperties wxCpMultiProperties) {
        WxCpMultiRedisProperties redisProperties = wxCpMultiProperties.getConfigStorage().getRedis();
        RedissonClient redissonClient = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getRedissonClient(wxCpMultiProperties) : (RedissonClient)this.applicationContext.getBean(RedissonClient.class);
        return new WxCpRedissonConfigImpl(redissonClient, wxCpMultiProperties.getConfigStorage().getKeyPrefix());
    }

    private RedissonClient getRedissonClient(WxCpMultiProperties wxCpMultiProperties) {
        WxCpMultiProperties.ConfigStorage storage = wxCpMultiProperties.getConfigStorage();
        WxCpMultiRedisProperties redis = storage.getRedis();
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + redis.getHost() + ":" + redis.getPort()).setDatabase(redis.getDatabase()).setPassword(redis.getPassword());
        config.setTransportMode(TransportMode.NIO);
        return Redisson.create((Config)config);
    }

    public WxCpInRedissonConfiguration(WxCpMultiProperties wxCpMultiProperties, ApplicationContext applicationContext) {
        this.wxCpMultiProperties = wxCpMultiProperties;
        this.applicationContext = applicationContext;
    }
}

