/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.cp.configuration.services;

import com.binarywang.spring.starter.wxjava.cp.configuration.services.AbstractWxCpConfiguration;
import com.binarywang.spring.starter.wxjava.cp.properties.WxCpMultiProperties;
import com.binarywang.spring.starter.wxjava.cp.service.WxCpMultiServices;
import me.chanjar.weixin.cp.config.impl.WxCpDefaultConfigImpl;
import me.chanjar.weixin.cp.config.impl.WxCpRedisTemplateConfigImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnProperty(prefix="wx.cp.config-storage", name={"type"}, havingValue="redistemplate")
public class WxCpInRedisTemplateConfiguration
extends AbstractWxCpConfiguration {
    private final WxCpMultiProperties wxCpMultiProperties;
    private final ApplicationContext applicationContext;

    @Bean
    public WxCpMultiServices wxCpMultiServices() {
        return this.wxCpMultiServices(this.wxCpMultiProperties);
    }

    @Override
    protected WxCpDefaultConfigImpl wxCpConfigStorage(WxCpMultiProperties wxCpMultiProperties) {
        return this.configRedisTemplate(wxCpMultiProperties);
    }

    private WxCpDefaultConfigImpl configRedisTemplate(WxCpMultiProperties wxCpMultiProperties) {
        StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        return new WxCpRedisTemplateConfigImpl(redisTemplate, wxCpMultiProperties.getConfigStorage().getKeyPrefix());
    }

    public WxCpInRedisTemplateConfiguration(WxCpMultiProperties wxCpMultiProperties, ApplicationContext applicationContext) {
        this.wxCpMultiProperties = wxCpMultiProperties;
        this.applicationContext = applicationContext;
    }
}

