/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.solon.wxjava.channel.config.storage;

import com.binarywang.solon.wxjava.channel.config.storage.AbstractWxChannelConfigStorageConfiguration;
import com.binarywang.solon.wxjava.channel.properties.RedisProperties;
import com.binarywang.solon.wxjava.channel.properties.WxChannelProperties;
import me.chanjar.weixin.channel.config.WxChannelConfig;
import me.chanjar.weixin.channel.config.impl.WxChannelDefaultConfigImpl;
import me.chanjar.weixin.channel.config.impl.WxChannelRedissonConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.core.AppContext;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.TransportMode;

@Configuration
@Condition(onProperty="${wx.channel.configStorage.type} = redisson", onClass=Redisson.class)
public class WxChannelInRedissonConfigStorageConfiguration
extends AbstractWxChannelConfigStorageConfiguration {
    private final WxChannelProperties properties;
    private final AppContext applicationContext;

    @Bean
    @Condition(onMissingBean=WxChannelConfig.class)
    public WxChannelConfig wxChannelConfig() {
        WxChannelRedissonConfigImpl config = this.getWxChannelRedissonConfig();
        return this.config((WxChannelDefaultConfigImpl)config, this.properties);
    }

    private WxChannelRedissonConfigImpl getWxChannelRedissonConfig() {
        RedisProperties redisProperties = this.properties.getConfigStorage().getRedis();
        RedissonClient redissonClient = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getRedissonClient() : (RedissonClient)this.applicationContext.getBean(RedissonClient.class);
        return new WxChannelRedissonConfigImpl(redissonClient, this.properties.getConfigStorage().getKeyPrefix());
    }

    private RedissonClient getRedissonClient() {
        WxChannelProperties.ConfigStorage storage = this.properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + redis.getHost() + ":" + redis.getPort()).setDatabase(redis.getDatabase()).setPassword(redis.getPassword());
        config.setTransportMode(TransportMode.NIO);
        return Redisson.create((Config)config);
    }

    public WxChannelInRedissonConfigStorageConfiguration(WxChannelProperties properties, AppContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }
}

