/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.ecommerce.ApplymentsRequest;
import com.github.binarywang.wxpay.bean.ecommerce.ApplymentsResult;
import com.github.binarywang.wxpay.bean.ecommerce.ApplymentsStatusResult;
import com.github.binarywang.wxpay.bean.ecommerce.CombineTransactionsNotifyResult;
import com.github.binarywang.wxpay.bean.ecommerce.CombineTransactionsRequest;
import com.github.binarywang.wxpay.bean.ecommerce.CombineTransactionsResult;
import com.github.binarywang.wxpay.bean.ecommerce.FinishOrderRequest;
import com.github.binarywang.wxpay.bean.ecommerce.FundBalanceResult;
import com.github.binarywang.wxpay.bean.ecommerce.FundBillRequest;
import com.github.binarywang.wxpay.bean.ecommerce.FundBillResult;
import com.github.binarywang.wxpay.bean.ecommerce.NotifyResponse;
import com.github.binarywang.wxpay.bean.ecommerce.PartnerTransactionsCloseRequest;
import com.github.binarywang.wxpay.bean.ecommerce.PartnerTransactionsNotifyResult;
import com.github.binarywang.wxpay.bean.ecommerce.PartnerTransactionsQueryRequest;
import com.github.binarywang.wxpay.bean.ecommerce.PartnerTransactionsRequest;
import com.github.binarywang.wxpay.bean.ecommerce.PartnerTransactionsResult;
import com.github.binarywang.wxpay.bean.ecommerce.ProfitSharingOrdersUnSplitAmountRequest;
import com.github.binarywang.wxpay.bean.ecommerce.ProfitSharingOrdersUnSplitAmountResult;
import com.github.binarywang.wxpay.bean.ecommerce.ProfitSharingQueryRequest;
import com.github.binarywang.wxpay.bean.ecommerce.ProfitSharingReceiverRequest;
import com.github.binarywang.wxpay.bean.ecommerce.ProfitSharingReceiverResult;
import com.github.binarywang.wxpay.bean.ecommerce.ProfitSharingRequest;
import com.github.binarywang.wxpay.bean.ecommerce.ProfitSharingResult;
import com.github.binarywang.wxpay.bean.ecommerce.RefundNotifyResult;
import com.github.binarywang.wxpay.bean.ecommerce.RefundQueryResult;
import com.github.binarywang.wxpay.bean.ecommerce.RefundsRequest;
import com.github.binarywang.wxpay.bean.ecommerce.RefundsResult;
import com.github.binarywang.wxpay.bean.ecommerce.ReturnOrdersQueryRequest;
import com.github.binarywang.wxpay.bean.ecommerce.ReturnOrdersRequest;
import com.github.binarywang.wxpay.bean.ecommerce.ReturnOrdersResult;
import com.github.binarywang.wxpay.bean.ecommerce.SettlementRequest;
import com.github.binarywang.wxpay.bean.ecommerce.SettlementResult;
import com.github.binarywang.wxpay.bean.ecommerce.SignatureHeader;
import com.github.binarywang.wxpay.bean.ecommerce.SpWithdrawRequest;
import com.github.binarywang.wxpay.bean.ecommerce.SpWithdrawResult;
import com.github.binarywang.wxpay.bean.ecommerce.SpWithdrawStatusResult;
import com.github.binarywang.wxpay.bean.ecommerce.SubWithdrawRequest;
import com.github.binarywang.wxpay.bean.ecommerce.SubWithdrawResult;
import com.github.binarywang.wxpay.bean.ecommerce.SubWithdrawStatusResult;
import com.github.binarywang.wxpay.bean.ecommerce.SubsidiesCancelRequest;
import com.github.binarywang.wxpay.bean.ecommerce.SubsidiesCancelResult;
import com.github.binarywang.wxpay.bean.ecommerce.SubsidiesCreateRequest;
import com.github.binarywang.wxpay.bean.ecommerce.SubsidiesCreateResult;
import com.github.binarywang.wxpay.bean.ecommerce.SubsidiesReturnRequest;
import com.github.binarywang.wxpay.bean.ecommerce.SubsidiesReturnResult;
import com.github.binarywang.wxpay.bean.ecommerce.TradeBillRequest;
import com.github.binarywang.wxpay.bean.ecommerce.TradeBillResult;
import com.github.binarywang.wxpay.bean.ecommerce.TransactionsResult;
import com.github.binarywang.wxpay.bean.ecommerce.enums.FundBillTypeEnum;
import com.github.binarywang.wxpay.bean.ecommerce.enums.SpAccountTypeEnum;
import com.github.binarywang.wxpay.bean.ecommerce.enums.TradeTypeEnum;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.EcommerceService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.util.AesUtils;
import com.github.binarywang.wxpay.v3.util.RsaCryptoUtil;
import com.google.common.base.CaseFormat;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class EcommerceServiceImpl
implements EcommerceService {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Gson GSON_CUSTOM = new GsonBuilder().setDateFormat(0, 0).create();
    private final WxPayService payService;

    @Override
    public ApplymentsResult createApply(ApplymentsRequest request) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/applyments/", this.payService.getPayBaseUrl());
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (ApplymentsResult)GSON.fromJson(result, ApplymentsResult.class);
    }

    @Override
    public ApplymentsStatusResult queryApplyStatusByApplymentId(String applymentId) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/applyments/%s", this.payService.getPayBaseUrl(), applymentId);
        String result = this.payService.getV3(url);
        return (ApplymentsStatusResult)GSON.fromJson(result, ApplymentsStatusResult.class);
    }

    @Override
    public ApplymentsStatusResult queryApplyStatusByOutRequestNo(String outRequestNo) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/applyments/out-request-no/%s", this.payService.getPayBaseUrl(), outRequestNo);
        String result = this.payService.getV3(url);
        return (ApplymentsStatusResult)GSON.fromJson(result, ApplymentsStatusResult.class);
    }

    @Override
    public TransactionsResult combine(TradeTypeEnum tradeType, CombineTransactionsRequest request) throws WxPayException {
        String url = this.payService.getPayBaseUrl() + tradeType.getCombineUrl();
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (TransactionsResult)GSON.fromJson(response, TransactionsResult.class);
    }

    @Override
    public <T> T combineTransactions(TradeTypeEnum tradeType, CombineTransactionsRequest request) throws WxPayException {
        TransactionsResult result = this.combine(tradeType, request);
        return result.getPayInfo(tradeType, request.getCombineAppid(), request.getCombineMchid(), this.payService.getConfig().getPrivateKey());
    }

    @Override
    public CombineTransactionsNotifyResult parseCombineNotifyResult(String notifyData, SignatureHeader header) throws WxPayException {
        if (Objects.nonNull(header) && !this.verifyNotifySign(header, notifyData)) {
            throw new WxPayException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5934\u90e8\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25");
        }
        NotifyResponse response = (NotifyResponse)GSON.fromJson(notifyData, NotifyResponse.class);
        NotifyResponse.Resource resource = response.getResource();
        String cipherText = resource.getCiphertext();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.payService.getConfig().getApiV3Key();
        try {
            String result = AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key);
            CombineTransactionsResult transactionsResult = (CombineTransactionsResult)GSON.fromJson(result, CombineTransactionsResult.class);
            CombineTransactionsNotifyResult notifyResult = new CombineTransactionsNotifyResult();
            notifyResult.setRawData(response);
            notifyResult.setResult(transactionsResult);
            return notifyResult;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public CombineTransactionsResult queryCombineTransactions(String outTradeNo) throws WxPayException {
        String url = String.format("%s/v3/combine-transactions/out-trade-no/%s", this.payService.getPayBaseUrl(), outTradeNo);
        String response = this.payService.getV3(url);
        return (CombineTransactionsResult)GSON.fromJson(response, CombineTransactionsResult.class);
    }

    @Override
    public TransactionsResult partner(TradeTypeEnum tradeType, PartnerTransactionsRequest request) throws WxPayException {
        String url = this.payService.getPayBaseUrl() + tradeType.getPartnerUrl();
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (TransactionsResult)GSON.fromJson(response, TransactionsResult.class);
    }

    @Override
    public <T> T partnerTransactions(TradeTypeEnum tradeType, PartnerTransactionsRequest request) throws WxPayException {
        TransactionsResult result = this.partner(tradeType, request);
        String appId = request.getSubAppid() != null ? request.getSubAppid() : request.getSpAppid();
        return result.getPayInfo(tradeType, appId, request.getSpMchid(), this.payService.getConfig().getPrivateKey());
    }

    @Override
    public PartnerTransactionsNotifyResult parsePartnerNotifyResult(String notifyData, SignatureHeader header) throws WxPayException {
        if (Objects.nonNull(header) && !this.verifyNotifySign(header, notifyData)) {
            throw new WxPayException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5934\u90e8\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25");
        }
        NotifyResponse response = (NotifyResponse)GSON.fromJson(notifyData, NotifyResponse.class);
        NotifyResponse.Resource resource = response.getResource();
        String cipherText = resource.getCiphertext();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.payService.getConfig().getApiV3Key();
        try {
            String result = AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key);
            PartnerTransactionsResult transactionsResult = (PartnerTransactionsResult)GSON.fromJson(result, PartnerTransactionsResult.class);
            PartnerTransactionsNotifyResult notifyResult = new PartnerTransactionsNotifyResult();
            notifyResult.setRawData(response);
            notifyResult.setResult(transactionsResult);
            return notifyResult;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public PartnerTransactionsResult queryPartnerTransactions(PartnerTransactionsQueryRequest request) throws WxPayException {
        String url = String.format("%s/v3/pay/partner/transactions/out-trade-no/%s", this.payService.getPayBaseUrl(), request.getOutTradeNo());
        if (Objects.isNull(request.getOutTradeNo())) {
            url = String.format("%s/v3/pay/partner/transactions/id/%s", this.payService.getPayBaseUrl(), request.getTransactionId());
        }
        String query = String.format("?sp_mchid=%s&sub_mchid=%s", request.getSpMchid(), request.getSubMchid());
        String response = this.payService.getV3(url + query);
        return (PartnerTransactionsResult)GSON.fromJson(response, PartnerTransactionsResult.class);
    }

    @Override
    public String closePartnerTransactions(PartnerTransactionsCloseRequest request) throws WxPayException {
        String url = String.format("%s/v3/pay/partner/transactions/out-trade-no/%s/close", this.payService.getPayBaseUrl(), request.getOutTradeNo());
        return this.payService.postV3(url, GSON.toJson((Object)request));
    }

    @Override
    public FundBalanceResult spNowBalance(SpAccountTypeEnum accountType) throws WxPayException {
        String url = String.format("%s/v3/merchant/fund/balance/%s", new Object[]{this.payService.getPayBaseUrl(), accountType});
        String response = this.payService.getV3(url);
        return (FundBalanceResult)GSON.fromJson(response, FundBalanceResult.class);
    }

    @Override
    public FundBalanceResult spDayEndBalance(SpAccountTypeEnum accountType, String date) throws WxPayException {
        String url = String.format("%s/v3/merchant/fund/dayendbalance/%s?date=%s", new Object[]{this.payService.getPayBaseUrl(), accountType, date});
        String response = this.payService.getV3(url);
        return (FundBalanceResult)GSON.fromJson(response, FundBalanceResult.class);
    }

    @Override
    public FundBalanceResult subNowBalance(String subMchid) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/fund/balance/%s", this.payService.getPayBaseUrl(), subMchid);
        String response = this.payService.getV3(url);
        return (FundBalanceResult)GSON.fromJson(response, FundBalanceResult.class);
    }

    @Override
    public FundBalanceResult subNowBalance(String subMchid, SpAccountTypeEnum accountType) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/fund/balance/%s", this.payService.getPayBaseUrl(), subMchid);
        if (Objects.nonNull((Object)accountType)) {
            url = url + "?account_type=" + accountType.getValue();
        }
        String response = this.payService.getV3(url);
        return (FundBalanceResult)GSON.fromJson(response, FundBalanceResult.class);
    }

    @Override
    public FundBalanceResult subDayEndBalance(String subMchid, String date) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/fund/enddaybalance/%s?date=%s", this.payService.getPayBaseUrl(), subMchid, date);
        String response = this.payService.getV3(url);
        return (FundBalanceResult)GSON.fromJson(response, FundBalanceResult.class);
    }

    @Override
    public ProfitSharingResult profitSharing(ProfitSharingRequest request) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/profitsharing/orders", this.payService.getPayBaseUrl());
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        String response = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (ProfitSharingResult)GSON.fromJson(response, ProfitSharingResult.class);
    }

    @Override
    public ProfitSharingResult queryProfitSharing(ProfitSharingQueryRequest request) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/profitsharing/orders?sub_mchid=%s&transaction_id=%s&out_order_no=%s", this.payService.getPayBaseUrl(), request.getSubMchid(), request.getTransactionId(), request.getOutOrderNo());
        String response = this.payService.getV3(url);
        return (ProfitSharingResult)GSON.fromJson(response, ProfitSharingResult.class);
    }

    @Override
    public ProfitSharingOrdersUnSplitAmountResult queryProfitSharingOrdersUnsplitAmount(ProfitSharingOrdersUnSplitAmountRequest request) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/profitsharing/orders/%s/amounts", this.payService.getPayBaseUrl(), request.getTransactionId());
        String response = this.payService.getV3(url);
        return (ProfitSharingOrdersUnSplitAmountResult)GSON.fromJson(response, ProfitSharingOrdersUnSplitAmountResult.class);
    }

    @Override
    public ProfitSharingReceiverResult addReceivers(ProfitSharingReceiverRequest request) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/profitsharing/receivers/add", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (ProfitSharingReceiverResult)GSON.fromJson(response, ProfitSharingReceiverResult.class);
    }

    @Override
    public ProfitSharingReceiverResult deleteReceivers(ProfitSharingReceiverRequest request) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/profitsharing/receivers/delete", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (ProfitSharingReceiverResult)GSON.fromJson(response, ProfitSharingReceiverResult.class);
    }

    @Override
    public ReturnOrdersResult returnOrders(ReturnOrdersRequest request) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/profitsharing/returnorders", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (ReturnOrdersResult)GSON.fromJson(response, ReturnOrdersResult.class);
    }

    @Override
    public ReturnOrdersResult queryReturnOrders(ReturnOrdersQueryRequest request) throws WxPayException {
        String subMchid = request.getSubMchid();
        String orderId = request.getOrderId();
        String outOrderNo = request.getOutOrderNo();
        String outReturnNo = request.getOutReturnNo();
        String url = null;
        url = StringUtils.isBlank((CharSequence)orderId) ? String.format("%s/v3/ecommerce/profitsharing/returnorders?sub_mchid=%s&out_order_no=%s&out_return_no=%s", this.payService.getPayBaseUrl(), subMchid, outOrderNo, outReturnNo) : String.format("%s/v3/ecommerce/profitsharing/returnorders?sub_mchid=%s&order_id=%s&out_return_no=%s", this.payService.getPayBaseUrl(), subMchid, orderId, outReturnNo);
        String response = this.payService.getV3(url);
        return (ReturnOrdersResult)GSON.fromJson(response, ReturnOrdersResult.class);
    }

    @Override
    public ProfitSharingResult finishOrder(FinishOrderRequest request) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/profitsharing/finish-order", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (ProfitSharingResult)GSON.fromJson(response, ProfitSharingResult.class);
    }

    @Override
    public RefundsResult refunds(RefundsRequest request) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/refunds/apply", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (RefundsResult)GSON.fromJson(response, RefundsResult.class);
    }

    @Override
    public RefundQueryResult queryRefundByRefundId(String subMchid, String refundId) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/refunds/id/%s?sub_mchid=%s", this.payService.getPayBaseUrl(), refundId, subMchid);
        String response = this.payService.getV3(url);
        return (RefundQueryResult)GSON.fromJson(response, RefundQueryResult.class);
    }

    @Override
    public RefundQueryResult queryRefundByOutRefundNo(String subMchid, String outRefundNo) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/refunds/out-refund-no/%s?sub_mchid=%s", this.payService.getPayBaseUrl(), outRefundNo, subMchid);
        String response = this.payService.getV3(url);
        return (RefundQueryResult)GSON.fromJson(response, RefundQueryResult.class);
    }

    @Override
    public RefundNotifyResult parseRefundNotifyResult(String notifyData, SignatureHeader header) throws WxPayException {
        if (Objects.nonNull(header) && !this.verifyNotifySign(header, notifyData)) {
            throw new WxPayException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5934\u90e8\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25");
        }
        NotifyResponse response = (NotifyResponse)GSON.fromJson(notifyData, NotifyResponse.class);
        NotifyResponse.Resource resource = response.getResource();
        String cipherText = resource.getCiphertext();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.payService.getConfig().getApiV3Key();
        try {
            String result = AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key);
            RefundNotifyResult notifyResult = (RefundNotifyResult)GSON.fromJson(result, RefundNotifyResult.class);
            notifyResult.setRawData(response);
            return notifyResult;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public SubWithdrawResult subWithdraw(SubWithdrawRequest request) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/fund/withdraw", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (SubWithdrawResult)GSON.fromJson(response, SubWithdrawResult.class);
    }

    @Override
    public SpWithdrawResult spWithdraw(SpWithdrawRequest request) throws WxPayException {
        String url = String.format("%s/v3/merchant/fund/withdraw", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (SpWithdrawResult)GSON.fromJson(response, SpWithdrawResult.class);
    }

    @Override
    public SubWithdrawStatusResult querySubWithdrawByOutRequestNo(String subMchid, String outRequestNo) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/fund/withdraw/out-request-no/%s?sub_mchid=%s", this.payService.getPayBaseUrl(), outRequestNo, subMchid);
        String response = this.payService.getV3(url);
        return (SubWithdrawStatusResult)GSON.fromJson(response, SubWithdrawStatusResult.class);
    }

    @Override
    public SpWithdrawStatusResult querySpWithdrawByOutRequestNo(String outRequestNo) throws WxPayException {
        String url = String.format("%s/v3/merchant/fund/withdraw/out-request-no/%s", this.payService.getPayBaseUrl(), outRequestNo);
        String response = this.payService.getV3(url);
        return (SpWithdrawStatusResult)GSON.fromJson(response, SpWithdrawStatusResult.class);
    }

    @Override
    public void modifySettlement(String subMchid, SettlementRequest request) throws WxPayException {
        String url = String.format("%s/v3/apply4sub/sub_merchants/%s/modify-settlement", this.payService.getPayBaseUrl(), subMchid);
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
    }

    @Override
    public SettlementResult querySettlement(String subMchid) throws WxPayException {
        String url = String.format("%s/v3/apply4sub/sub_merchants/%s/settlement", this.payService.getPayBaseUrl(), subMchid);
        String response = this.payService.getV3(url);
        return (SettlementResult)GSON.fromJson(response, SettlementResult.class);
    }

    @Override
    public TradeBillResult applyBill(TradeBillRequest request) throws WxPayException {
        String url = String.format("%s/v3/bill/tradebill?%s", this.payService.getPayBaseUrl(), this.parseURLPair(request));
        String response = this.payService.getV3(url);
        return (TradeBillResult)GSON.fromJson(response, TradeBillResult.class);
    }

    @Override
    public FundBillResult applyFundBill(FundBillTypeEnum billType, FundBillRequest request) throws WxPayException {
        String url = String.format(billType.getUrl(), this.payService.getPayBaseUrl(), this.parseURLPair(request));
        String response = this.payService.getV3(url);
        return (FundBillResult)GSON.fromJson(response, FundBillResult.class);
    }

    @Override
    public InputStream downloadBill(String url) throws WxPayException {
        return this.payService.downloadV3(url);
    }

    @Override
    public SubsidiesCreateResult subsidiesCreate(SubsidiesCreateRequest subsidiesCreateRequest) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/subsidies/create", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)subsidiesCreateRequest));
        return (SubsidiesCreateResult)GSON.fromJson(response, SubsidiesCreateResult.class);
    }

    @Override
    public SubsidiesReturnResult subsidiesReturn(SubsidiesReturnRequest subsidiesReturnRequest) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/subsidies/return", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)subsidiesReturnRequest));
        return (SubsidiesReturnResult)GSON.fromJson(response, SubsidiesReturnResult.class);
    }

    @Override
    public SubsidiesCancelResult subsidiesCancel(SubsidiesCancelRequest subsidiesCancelRequest) throws WxPayException {
        String url = String.format("%s/v3/ecommerce/subsidies/cancel", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)subsidiesCancelRequest));
        return (SubsidiesCancelResult)GSON.fromJson(response, SubsidiesCancelResult.class);
    }

    private boolean verifyNotifySign(SignatureHeader header, String data) {
        String beforeSign = String.format("%s\n%s\n%s\n", header.getTimeStamp(), header.getNonce(), data);
        return this.payService.getConfig().getVerifier().verify(header.getSerialNo(), beforeSign.getBytes(StandardCharsets.UTF_8), header.getSigned());
    }

    private String parseURLPair(Object o) {
        Map<Object, Object> map = EcommerceServiceImpl.getObjectToMap(o);
        Set<Map.Entry<Object, Object>> set = map.entrySet();
        Iterator<Map.Entry<Object, Object>> it = set.iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            Map.Entry<Object, Object> e = it.next();
            if ("class".equals(e.getKey()) || e.getValue() == null) continue;
            sb.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, String.valueOf(e.getKey()))).append("=").append(e.getValue()).append("&");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public static Map<Object, Object> getObjectToMap(Object obj) {
        try {
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
            Class<?> beanClass = obj.getClass();
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            if (propertyDescriptors != null) {
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    if (propertyDescriptor == null) continue;
                    String name = propertyDescriptor.getName();
                    Method readMethod = propertyDescriptor.getReadMethod();
                    if (readMethod == null) continue;
                    result.put(name, readMethod.invoke(obj, new Object[0]));
                }
            }
            return result;
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException ignored) {
            return null;
        }
    }

    public EcommerceServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

