/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.businesscircle.BusinessCircleNotifyData;
import com.github.binarywang.wxpay.bean.businesscircle.PaidResult;
import com.github.binarywang.wxpay.bean.businesscircle.PointsNotifyRequest;
import com.github.binarywang.wxpay.bean.businesscircle.RefundResult;
import com.github.binarywang.wxpay.bean.ecommerce.SignatureHeader;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.BusinessCircleService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.util.AesUtils;
import com.github.binarywang.wxpay.v3.util.RsaCryptoUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessCircleServiceImpl
implements BusinessCircleService {
    private static final Logger log = LoggerFactory.getLogger(BusinessCircleServiceImpl.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService payService;

    @Override
    public void notifyPoints(PointsNotifyRequest request) throws WxPayException {
        String url = String.format("%s/v3/businesscircle/points/notify", this.payService.getPayBaseUrl());
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
    }

    private boolean verifyNotifySign(SignatureHeader header, String data) {
        String beforeSign = String.format("%s\n%s\n%s\n", header.getTimeStamp(), header.getNonce(), data);
        return this.payService.getConfig().getVerifier().verify(header.getSerialNo(), beforeSign.getBytes(StandardCharsets.UTF_8), header.getSigned());
    }

    @Override
    public BusinessCircleNotifyData parseNotifyData(String data, SignatureHeader header) throws WxPayException {
        if (Objects.nonNull(header) && !this.verifyNotifySign(header, data)) {
            throw new WxPayException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5934\u90e8\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25");
        }
        return (BusinessCircleNotifyData)GSON.fromJson(data, BusinessCircleNotifyData.class);
    }

    @Override
    public PaidResult decryptPaidNotifyDataResource(BusinessCircleNotifyData data) throws WxPayException {
        BusinessCircleNotifyData.Resource resource = data.getResource();
        String cipherText = resource.getCipherText();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.payService.getConfig().getApiV3Key();
        try {
            return (PaidResult)GSON.fromJson(AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key), PaidResult.class);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public RefundResult decryptRefundNotifyDataResource(BusinessCircleNotifyData data) throws WxPayException {
        BusinessCircleNotifyData.Resource resource = data.getResource();
        String cipherText = resource.getCipherText();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.payService.getConfig().getApiV3Key();
        try {
            return (RefundResult)GSON.fromJson(AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key), RefundResult.class);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    public BusinessCircleServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

