/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.notify.SignatureHeader;
import com.github.binarywang.wxpay.bean.profitsharing.v3.ProfitSharingBillRequest;
import com.github.binarywang.wxpay.bean.profitsharing.v3.ProfitSharingBillResult;
import com.github.binarywang.wxpay.bean.profitsharing.v3.ProfitSharingMerchantMaxRatioQueryResult;
import com.github.binarywang.wxpay.bean.profitsharing.v3.ProfitSharingNotifyData;
import com.github.binarywang.wxpay.bean.profitsharing.v3.ProfitSharingNotifyResult;
import com.github.binarywang.wxpay.bean.profitsharing.v3.ProfitSharingReceiver;
import com.github.binarywang.wxpay.bean.profitsharing.v3.ProfitSharingRequest;
import com.github.binarywang.wxpay.bean.profitsharing.v3.ProfitSharingResult;
import com.github.binarywang.wxpay.bean.profitsharing.v3.ProfitSharingReturnRequest;
import com.github.binarywang.wxpay.bean.profitsharing.v3.ProfitSharingReturnResult;
import com.github.binarywang.wxpay.bean.profitsharing.v3.ProfitSharingUnfreezeRequest;
import com.github.binarywang.wxpay.bean.profitsharing.v3.ProfitSharingUnfreezeResult;
import com.github.binarywang.wxpay.bean.profitsharing.v3.ProfitSharingUnsplitResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.ProfitSharingV3Service;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.auth.Verifier;
import com.github.binarywang.wxpay.v3.util.AesUtils;
import com.github.binarywang.wxpay.v3.util.RsaCryptoUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfitSharingV3ServiceImpl
implements ProfitSharingV3Service {
    private static final Logger log = LoggerFactory.getLogger(ProfitSharingV3ServiceImpl.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService payService;

    @Override
    public ProfitSharingMerchantMaxRatioQueryResult getProfitSharingMerchantMaxRatio(String subMchId) throws WxPayException {
        String url = String.format("%s/v3/profitsharing/merchant-configs/%s", this.payService.getPayBaseUrl(), subMchId);
        String result = this.payService.getV3(url);
        return (ProfitSharingMerchantMaxRatioQueryResult)GSON.fromJson(result, ProfitSharingMerchantMaxRatioQueryResult.class);
    }

    @Override
    public ProfitSharingResult profitSharing(ProfitSharingRequest request) throws WxPayException {
        String url = String.format("%s/v3/profitsharing/orders", this.payService.getPayBaseUrl());
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (ProfitSharingResult)GSON.fromJson(result, ProfitSharingResult.class);
    }

    @Override
    public ProfitSharingResult getProfitSharingResult(String outOrderNo, String transactionId) throws WxPayException {
        String url = String.format("%s/v3/profitsharing/orders/%s?transaction_id=%s", this.payService.getPayBaseUrl(), outOrderNo, transactionId);
        String result = this.payService.getV3(url);
        return (ProfitSharingResult)GSON.fromJson(result, ProfitSharingResult.class);
    }

    @Override
    public ProfitSharingResult getProfitSharingResult(String outOrderNo, String transactionId, String subMchId) throws WxPayException {
        String url = String.format("%s/v3/profitsharing/orders/%s?sub_mchid=%s&transaction_id=%s", this.payService.getPayBaseUrl(), outOrderNo, subMchId, transactionId);
        String result = this.payService.getV3(url);
        return (ProfitSharingResult)GSON.fromJson(result, ProfitSharingResult.class);
    }

    @Override
    public ProfitSharingReturnResult profitSharingReturn(ProfitSharingReturnRequest request) throws WxPayException {
        String url = String.format("%s/v3/profitsharing/return-orders", this.payService.getPayBaseUrl());
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (ProfitSharingReturnResult)GSON.fromJson(result, ProfitSharingReturnResult.class);
    }

    @Override
    public ProfitSharingReturnResult getProfitSharingReturnResult(String outOrderNo, String outReturnNo) throws WxPayException {
        String url = String.format("%s/v3/profitsharing/return-orders/%s?out_order_no=%s", this.payService.getPayBaseUrl(), outReturnNo, outOrderNo);
        String result = this.payService.getV3(url);
        return (ProfitSharingReturnResult)GSON.fromJson(result, ProfitSharingReturnResult.class);
    }

    @Override
    public ProfitSharingReturnResult getProfitSharingReturnResult(String outOrderNo, String outReturnNo, String subMchId) throws WxPayException {
        String url = String.format("%s/v3/profitsharing/return-orders/%s?sub_mchid=%s&out_order_no=%s", this.payService.getPayBaseUrl(), outReturnNo, subMchId, outOrderNo);
        String result = this.payService.getV3(url);
        return (ProfitSharingReturnResult)GSON.fromJson(result, ProfitSharingReturnResult.class);
    }

    @Override
    public ProfitSharingUnfreezeResult profitSharingUnfreeze(ProfitSharingUnfreezeRequest request) throws WxPayException {
        String url = String.format("%s/v3/profitsharing/orders/unfreeze", this.payService.getPayBaseUrl());
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (ProfitSharingUnfreezeResult)GSON.fromJson(result, ProfitSharingUnfreezeResult.class);
    }

    @Override
    public ProfitSharingUnsplitResult getProfitSharingUnsplitAmount(String transactionId) throws WxPayException {
        String url = String.format("%s/v3/profitsharing/transactions/%s/amounts", this.payService.getPayBaseUrl(), transactionId);
        String result = this.payService.getV3(url);
        return (ProfitSharingUnsplitResult)GSON.fromJson(result, ProfitSharingUnsplitResult.class);
    }

    @Override
    public ProfitSharingReceiver addProfitSharingReceiver(ProfitSharingReceiver request) throws WxPayException {
        String url = String.format("%s/v3/profitsharing/receivers/add", this.payService.getPayBaseUrl());
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (ProfitSharingReceiver)GSON.fromJson(result, ProfitSharingReceiver.class);
    }

    @Override
    public ProfitSharingReceiver deleteProfitSharingReceiver(ProfitSharingReceiver request) throws WxPayException {
        String url = String.format("%s/v3/profitsharing/receivers/delete", this.payService.getPayBaseUrl());
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (ProfitSharingReceiver)GSON.fromJson(result, ProfitSharingReceiver.class);
    }

    @Override
    public ProfitSharingNotifyResult getProfitSharingNotifyResult(String notifyData, SignatureHeader header) throws WxPayException {
        ProfitSharingNotifyData response = this.parseNotifyData(notifyData, header);
        ProfitSharingNotifyData.Resource resource = response.getResource();
        String cipherText = resource.getCipherText();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.payService.getConfig().getApiV3Key();
        try {
            String result = AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key);
            return (ProfitSharingNotifyResult)GSON.fromJson(result, ProfitSharingNotifyResult.class);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public ProfitSharingBillResult getProfitSharingBill(ProfitSharingBillRequest request) throws WxPayException {
        String url = String.format("%s/v3/profitsharing/bills?bill_date=%s", this.payService.getPayBaseUrl(), request.getBillDate());
        if (StringUtils.isNotBlank((CharSequence)request.getSubMchId())) {
            url = String.format("%s&sub_mchid=%s", url, request.getSubMchId());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getTarType())) {
            url = String.format("%s&tar_type=%s", url, request.getTarType());
        }
        String result = this.payService.getV3(url);
        return (ProfitSharingBillResult)GSON.fromJson(result, ProfitSharingBillResult.class);
    }

    private ProfitSharingNotifyData parseNotifyData(String data, SignatureHeader header) throws WxPayException {
        if (Objects.nonNull(header) && !this.verifyNotifySign(header, data)) {
            throw new WxPayException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5934\u90e8\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25");
        }
        return (ProfitSharingNotifyData)GSON.fromJson(data, ProfitSharingNotifyData.class);
    }

    private boolean verifyNotifySign(SignatureHeader header, String data) throws WxPayException {
        String beforeSign = String.format("%s%n%s%n%s%n", header.getTimeStamp(), header.getNonce(), data);
        Verifier verifier = this.payService.getConfig().getVerifier();
        if (verifier == null) {
            throw new WxPayException("\u8bc1\u4e66\u68c0\u9a8c\u5bf9\u8c61\u4e3a\u7a7a");
        }
        return verifier.verify(header.getSerial(), beforeSign.getBytes(StandardCharsets.UTF_8), header.getSignature());
    }

    public ProfitSharingV3ServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

