/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.constant.WxPayConstants;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.util.SignUtils;
import com.github.binarywang.wxpay.util.XmlConfig;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.BeanUtils;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.common.util.xml.XStreamInitializer;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class BaseWxPayRequest
implements Serializable {
    private static final long serialVersionUID = -4766915659779847060L;
    @XStreamAlias(value="appid")
    protected String appid;
    @XStreamAlias(value="mch_id")
    protected String mchId;
    @XStreamAlias(value="sub_appid")
    protected String subAppId;
    @XStreamAlias(value="sub_mch_id")
    protected String subMchId;
    @XStreamAlias(value="nonce_str")
    protected String nonceStr;
    @XStreamAlias(value="sign")
    protected String sign;
    @XStreamAlias(value="sign_type")
    private String signType;
    @XStreamAlias(value="workwx_sign")
    private String workWxSign;

    public String getWorkWxSign() {
        return this.workWxSign;
    }

    public void setWorkWxSign(String workWxSign) {
        this.workWxSign = workWxSign;
    }

    public static Integer yuanToFen(String yuan) {
        return new BigDecimal(yuan).setScale(2, 4).multiply(new BigDecimal(100)).intValue();
    }

    private void checkFields() throws WxPayException {
        try {
            BeanUtils.checkRequiredFields((Object)this);
        }
        catch (WxErrorException e) {
            throw new WxPayException(e.getError().getErrorMsg(), e);
        }
        this.checkConstraints();
    }

    protected abstract void checkConstraints() throws WxPayException;

    protected boolean needNonceStr() {
        return true;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String toString() {
        return WxGsonBuilder.create().toJson((Object)this);
    }

    public String toXML() {
        this.setSubAppId(StringUtils.trimToNull((String)this.getSubAppId()));
        this.setSubMchId(StringUtils.trimToNull((String)this.getSubMchId()));
        if (XmlConfig.fastMode) {
            return this.toFastXml();
        }
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(this.getClass());
        return xstream.toXML((Object)this);
    }

    private String toFastXml() {
        try {
            Document document = DocumentHelper.createDocument();
            Element root = document.addElement(this.xmlRootTagName());
            Map<String, String> signParams = this.getSignParams();
            signParams.put("sign", this.sign);
            for (Map.Entry<String, String> entry : signParams.entrySet()) {
                if (entry.getValue() == null) continue;
                Element elm = root.addElement(entry.getKey());
                elm.addText(entry.getValue());
            }
            return document.asXML();
        }
        catch (Exception e) {
            throw new WxRuntimeException("generate xml error", (Throwable)e);
        }
    }

    protected String xmlRootTagName() {
        return "xml";
    }

    protected boolean ignoreAppid() {
        return false;
    }

    protected boolean ignoreSubAppId() {
        return false;
    }

    protected boolean ignoreSubMchId() {
        return false;
    }

    protected boolean isWxWorkSign() {
        return false;
    }

    protected String[] getIgnoredParamsForSign() {
        return new String[0];
    }

    public Map<String, String> getSignParams() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("appid", this.appid);
        map.put("mch_id", this.mchId);
        map.put("sub_appid", this.subAppId);
        map.put("sub_mch_id", this.subMchId);
        map.put("nonce_str", this.nonceStr);
        map.put("sign_type", this.signType);
        this.storeMap(map);
        return map;
    }

    protected abstract void storeMap(Map<String, String> var1);

    public void checkAndSign(WxPayConfig config) throws WxPayException {
        this.checkFields();
        if (!this.ignoreAppid() && StringUtils.isBlank((CharSequence)this.getAppid())) {
            this.setAppid(config.getAppId());
        }
        if (StringUtils.isBlank((CharSequence)this.getMchId())) {
            this.setMchId(config.getMchId());
        }
        if (!this.ignoreSubAppId() && StringUtils.isBlank((CharSequence)this.getSubAppId())) {
            this.setSubAppId(config.getSubAppId());
        }
        if (!this.ignoreSubMchId() && StringUtils.isBlank((CharSequence)this.getSubMchId())) {
            this.setSubMchId(config.getSubMchId());
        }
        if (StringUtils.isBlank((CharSequence)this.getSignType())) {
            if (config.getSignType() != null && !WxPayConstants.SignType.ALL_SIGN_TYPES.contains(config.getSignType())) {
                throw new WxPayException("\u975e\u6cd5\u7684signType\u914d\u7f6e\uff1a" + config.getSignType() + "\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
            }
            this.setSignType(StringUtils.trimToNull((String)config.getSignType()));
        } else if (!WxPayConstants.SignType.ALL_SIGN_TYPES.contains(this.getSignType())) {
            throw new WxPayException("\u975e\u6cd5\u7684sign_type\u53c2\u6570\uff1a" + this.getSignType());
        }
        if (this.needNonceStr() && StringUtils.isBlank((CharSequence)this.getNonceStr())) {
            this.setNonceStr(String.valueOf(System.currentTimeMillis()));
        }
        this.setSign(SignUtils.createSign(this, this.getSignType(), config.getMchKey(), this.getIgnoredParamsForSign()));
    }

    public String getAppid() {
        return this.appid;
    }

    public String getMchId() {
        return this.mchId;
    }

    public String getSubAppId() {
        return this.subAppId;
    }

    public String getSubMchId() {
        return this.subMchId;
    }

    public String getNonceStr() {
        return this.nonceStr;
    }

    public String getSign() {
        return this.sign;
    }

    public String getSignType() {
        return this.signType;
    }

    public BaseWxPayRequest setSubAppId(String subAppId) {
        this.subAppId = subAppId;
        return this;
    }

    public BaseWxPayRequest setSubMchId(String subMchId) {
        this.subMchId = subMchId;
        return this;
    }

    public BaseWxPayRequest setSign(String sign) {
        this.sign = sign;
        return this;
    }

    public BaseWxPayRequest setSignType(String signType) {
        this.signType = signType;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseWxPayRequest)) {
            return false;
        }
        BaseWxPayRequest other = (BaseWxPayRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appid = this.getAppid();
        String other$appid = other.getAppid();
        if (this$appid == null ? other$appid != null : !this$appid.equals(other$appid)) {
            return false;
        }
        String this$mchId = this.getMchId();
        String other$mchId = other.getMchId();
        if (this$mchId == null ? other$mchId != null : !this$mchId.equals(other$mchId)) {
            return false;
        }
        String this$subAppId = this.getSubAppId();
        String other$subAppId = other.getSubAppId();
        if (this$subAppId == null ? other$subAppId != null : !this$subAppId.equals(other$subAppId)) {
            return false;
        }
        String this$subMchId = this.getSubMchId();
        String other$subMchId = other.getSubMchId();
        if (this$subMchId == null ? other$subMchId != null : !this$subMchId.equals(other$subMchId)) {
            return false;
        }
        String this$nonceStr = this.getNonceStr();
        String other$nonceStr = other.getNonceStr();
        if (this$nonceStr == null ? other$nonceStr != null : !this$nonceStr.equals(other$nonceStr)) {
            return false;
        }
        String this$sign = this.getSign();
        String other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
            return false;
        }
        String this$signType = this.getSignType();
        String other$signType = other.getSignType();
        if (this$signType == null ? other$signType != null : !this$signType.equals(other$signType)) {
            return false;
        }
        String this$workWxSign = this.getWorkWxSign();
        String other$workWxSign = other.getWorkWxSign();
        return !(this$workWxSign == null ? other$workWxSign != null : !this$workWxSign.equals(other$workWxSign));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseWxPayRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appid = this.getAppid();
        result = result * 59 + ($appid == null ? 43 : $appid.hashCode());
        String $mchId = this.getMchId();
        result = result * 59 + ($mchId == null ? 43 : $mchId.hashCode());
        String $subAppId = this.getSubAppId();
        result = result * 59 + ($subAppId == null ? 43 : $subAppId.hashCode());
        String $subMchId = this.getSubMchId();
        result = result * 59 + ($subMchId == null ? 43 : $subMchId.hashCode());
        String $nonceStr = this.getNonceStr();
        result = result * 59 + ($nonceStr == null ? 43 : $nonceStr.hashCode());
        String $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
        String $signType = this.getSignType();
        result = result * 59 + ($signType == null ? 43 : $signType.hashCode());
        String $workWxSign = this.getWorkWxSign();
        result = result * 59 + ($workWxSign == null ? 43 : $workWxSign.hashCode());
        return result;
    }
}

