/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import java.util.Objects;
import me.chanjar.weixin.common.annotation.Required;

@XStreamAlias(value="xml")
public class WxMpEntrustRequest
extends BaseWxPayRequest {
    @Required
    @XStreamAlias(value="plan_id")
    private String planId;
    @Required
    @XStreamAlias(value="contract_code")
    private String contractCode;
    @Required
    @XStreamAlias(value="request_serial")
    private Long requestSerial;
    @Required
    @XStreamAlias(value="contract_display_account")
    private String contractDisplayAccount;
    @Required
    @XStreamAlias(value="notify_url")
    private String notifyUrl;
    @Required
    @XStreamAlias(value="version")
    private String version;
    @Required
    @XStreamAlias(value="timestamp")
    private String timestamp;
    @XStreamAlias(value="return_web")
    private Integer returnWeb;
    @XStreamAlias(value="outerid")
    private String outerId;

    @Override
    protected void checkConstraints() throws WxPayException {
    }

    @Override
    protected boolean needNonceStr() {
        return false;
    }

    @Override
    protected void storeMap(Map<String, String> map) {
        map.put("plan_id", this.planId);
        map.put("contract_code", this.contractCode);
        map.put("request_serial", String.valueOf(this.requestSerial));
        map.put("contract_display_account", this.contractDisplayAccount);
        map.put("notify_url", this.notifyUrl);
        map.put("version", this.version);
        map.put("timestamp", this.timestamp);
        if (Objects.nonNull(this.returnWeb)) {
            map.put("return_web", String.valueOf(this.returnWeb));
        }
        map.put("outerid", this.outerId);
    }

    public static WxMpEntrustRequestBuilder newBuilder() {
        return new WxMpEntrustRequestBuilder();
    }

    public String getPlanId() {
        return this.planId;
    }

    public String getContractCode() {
        return this.contractCode;
    }

    public Long getRequestSerial() {
        return this.requestSerial;
    }

    public String getContractDisplayAccount() {
        return this.contractDisplayAccount;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Integer getReturnWeb() {
        return this.returnWeb;
    }

    public String getOuterId() {
        return this.outerId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public void setRequestSerial(Long requestSerial) {
        this.requestSerial = requestSerial;
    }

    public void setContractDisplayAccount(String contractDisplayAccount) {
        this.contractDisplayAccount = contractDisplayAccount;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setReturnWeb(Integer returnWeb) {
        this.returnWeb = returnWeb;
    }

    public void setOuterId(String outerId) {
        this.outerId = outerId;
    }

    @Override
    public String toString() {
        return "WxMpEntrustRequest(planId=" + this.getPlanId() + ", contractCode=" + this.getContractCode() + ", requestSerial=" + this.getRequestSerial() + ", contractDisplayAccount=" + this.getContractDisplayAccount() + ", notifyUrl=" + this.getNotifyUrl() + ", version=" + this.getVersion() + ", timestamp=" + this.getTimestamp() + ", returnWeb=" + this.getReturnWeb() + ", outerId=" + this.getOuterId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxMpEntrustRequest)) {
            return false;
        }
        WxMpEntrustRequest other = (WxMpEntrustRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$planId = this.getPlanId();
        String other$planId = other.getPlanId();
        if (this$planId == null ? other$planId != null : !this$planId.equals(other$planId)) {
            return false;
        }
        String this$contractCode = this.getContractCode();
        String other$contractCode = other.getContractCode();
        if (this$contractCode == null ? other$contractCode != null : !this$contractCode.equals(other$contractCode)) {
            return false;
        }
        Long this$requestSerial = this.getRequestSerial();
        Long other$requestSerial = other.getRequestSerial();
        if (this$requestSerial == null ? other$requestSerial != null : !((Object)this$requestSerial).equals(other$requestSerial)) {
            return false;
        }
        String this$contractDisplayAccount = this.getContractDisplayAccount();
        String other$contractDisplayAccount = other.getContractDisplayAccount();
        if (this$contractDisplayAccount == null ? other$contractDisplayAccount != null : !this$contractDisplayAccount.equals(other$contractDisplayAccount)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        Integer this$returnWeb = this.getReturnWeb();
        Integer other$returnWeb = other.getReturnWeb();
        if (this$returnWeb == null ? other$returnWeb != null : !((Object)this$returnWeb).equals(other$returnWeb)) {
            return false;
        }
        String this$outerId = this.getOuterId();
        String other$outerId = other.getOuterId();
        return !(this$outerId == null ? other$outerId != null : !this$outerId.equals(other$outerId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxMpEntrustRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $planId = this.getPlanId();
        result = result * 59 + ($planId == null ? 43 : $planId.hashCode());
        String $contractCode = this.getContractCode();
        result = result * 59 + ($contractCode == null ? 43 : $contractCode.hashCode());
        Long $requestSerial = this.getRequestSerial();
        result = result * 59 + ($requestSerial == null ? 43 : ((Object)$requestSerial).hashCode());
        String $contractDisplayAccount = this.getContractDisplayAccount();
        result = result * 59 + ($contractDisplayAccount == null ? 43 : $contractDisplayAccount.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        Integer $returnWeb = this.getReturnWeb();
        result = result * 59 + ($returnWeb == null ? 43 : ((Object)$returnWeb).hashCode());
        String $outerId = this.getOuterId();
        result = result * 59 + ($outerId == null ? 43 : $outerId.hashCode());
        return result;
    }

    public WxMpEntrustRequest() {
    }

    public WxMpEntrustRequest(String planId, String contractCode, Long requestSerial, String contractDisplayAccount, String notifyUrl, String version, String timestamp, Integer returnWeb, String outerId) {
        this.planId = planId;
        this.contractCode = contractCode;
        this.requestSerial = requestSerial;
        this.contractDisplayAccount = contractDisplayAccount;
        this.notifyUrl = notifyUrl;
        this.version = version;
        this.timestamp = timestamp;
        this.returnWeb = returnWeb;
        this.outerId = outerId;
    }

    public static class WxMpEntrustRequestBuilder {
        private String planId;
        private String contractCode;
        private Long requestSerial;
        private String contractDisplayAccount;
        private String notifyUrl;
        private String version;
        private String timestamp;
        private Integer returnWeb;
        private String outerId;

        WxMpEntrustRequestBuilder() {
        }

        public WxMpEntrustRequestBuilder planId(String planId) {
            this.planId = planId;
            return this;
        }

        public WxMpEntrustRequestBuilder contractCode(String contractCode) {
            this.contractCode = contractCode;
            return this;
        }

        public WxMpEntrustRequestBuilder requestSerial(Long requestSerial) {
            this.requestSerial = requestSerial;
            return this;
        }

        public WxMpEntrustRequestBuilder contractDisplayAccount(String contractDisplayAccount) {
            this.contractDisplayAccount = contractDisplayAccount;
            return this;
        }

        public WxMpEntrustRequestBuilder notifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
            return this;
        }

        public WxMpEntrustRequestBuilder version(String version) {
            this.version = version;
            return this;
        }

        public WxMpEntrustRequestBuilder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public WxMpEntrustRequestBuilder returnWeb(Integer returnWeb) {
            this.returnWeb = returnWeb;
            return this;
        }

        public WxMpEntrustRequestBuilder outerId(String outerId) {
            this.outerId = outerId;
            return this;
        }

        public WxMpEntrustRequest build() {
            return new WxMpEntrustRequest(this.planId, this.contractCode, this.requestSerial, this.contractDisplayAccount, this.notifyUrl, this.version, this.timestamp, this.returnWeb, this.outerId);
        }

        public String toString() {
            return "WxMpEntrustRequest.WxMpEntrustRequestBuilder(planId=" + this.planId + ", contractCode=" + this.contractCode + ", requestSerial=" + this.requestSerial + ", contractDisplayAccount=" + this.contractDisplayAccount + ", notifyUrl=" + this.notifyUrl + ", version=" + this.version + ", timestamp=" + this.timestamp + ", returnWeb=" + this.returnWeb + ", outerId=" + this.outerId + ")";
        }
    }
}

