/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.ecommerce.SignatureHeader;
import com.github.binarywang.wxpay.bean.payscore.PayScoreNotifyData;
import com.github.binarywang.wxpay.bean.payscore.UserAuthorizationStatusNotifyResult;
import com.github.binarywang.wxpay.bean.payscore.WxPayScoreRequest;
import com.github.binarywang.wxpay.bean.payscore.WxPayScoreResult;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.PayScoreService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.util.AesUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Objects;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;

public class PayScoreServiceImpl
implements PayScoreService {
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService payService;

    @Override
    public WxPayScoreResult permissions(WxPayScoreRequest request) throws WxPayException {
        WxPayConfig config = this.payService.getConfig();
        String url = this.payService.getPayBaseUrl() + "/v3/payscore/permissions";
        request.setAppid(config.getAppId());
        request.setServiceId(config.getServiceId());
        String permissionNotifyUrl = config.getPayScorePermissionNotifyUrl();
        if (StringUtils.isBlank((CharSequence)permissionNotifyUrl)) {
            throw new WxPayException("\u6388\u6743\u56de\u8c03\u5730\u5740\u672a\u914d\u7f6e");
        }
        String authorizationCode = request.getAuthorizationCode();
        if (StringUtils.isBlank((CharSequence)authorizationCode)) {
            throw new WxPayException("authorizationCode\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        request.setNotifyUrl(permissionNotifyUrl);
        String result = this.payService.postV3(url, request.toJson());
        return WxPayScoreResult.fromJson(result);
    }

    @Override
    public WxPayScoreResult permissionsQueryByAuthorizationCode(String authorizationCode) throws WxPayException {
        URIBuilder uriBuilder;
        WxPayConfig config = this.payService.getConfig();
        if (StringUtils.isBlank((CharSequence)authorizationCode)) {
            throw new WxPayException("authorizationCode\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String url = String.format("%s/v3/payscore/permissions/authorization-code/%s", this.payService.getPayBaseUrl(), authorizationCode);
        try {
            uriBuilder = new URIBuilder(url);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
        uriBuilder.setParameter("service_id", config.getServiceId());
        try {
            String result = this.payService.getV3(uriBuilder.build().toString());
            return WxPayScoreResult.fromJson(result);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public WxPayScoreResult permissionsTerminateByAuthorizationCode(String authorizationCode, String reason) throws WxPayException {
        WxPayConfig config = this.payService.getConfig();
        if (StringUtils.isBlank((CharSequence)authorizationCode)) {
            throw new WxPayException("authorizationCode\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String url = String.format("%s/v3/payscore/permissions/authorization-code/%s/terminate", this.payService.getPayBaseUrl(), authorizationCode);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("service_id", config.getServiceId());
        map.put("reason", reason);
        String result = this.payService.postV3(url, WxGsonBuilder.create().toJson(map));
        return WxPayScoreResult.fromJson(result);
    }

    @Override
    public WxPayScoreResult permissionsQueryByOpenId(String openId) throws WxPayException {
        URIBuilder uriBuilder;
        WxPayConfig config = this.payService.getConfig();
        if (StringUtils.isBlank((CharSequence)openId)) {
            throw new WxPayException("openId\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String url = String.format("%s/v3/payscore/permissions/openid/%s", this.payService.getPayBaseUrl(), openId);
        try {
            uriBuilder = new URIBuilder(url);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
        uriBuilder.setParameter("appid", config.getAppId());
        uriBuilder.setParameter("service_id", config.getServiceId());
        try {
            String result = this.payService.getV3(uriBuilder.build().toString());
            return WxPayScoreResult.fromJson(result);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public WxPayScoreResult permissionsTerminateByOpenId(String openId, String reason) throws WxPayException {
        WxPayConfig config = this.payService.getConfig();
        if (StringUtils.isBlank((CharSequence)openId)) {
            throw new WxPayException("openId\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String url = String.format("%s/v3/payscore/permissions/openid/%s/terminate", this.payService.getPayBaseUrl(), openId);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("service_id", config.getServiceId());
        map.put("appid", config.getAppId());
        map.put("reason", reason);
        String result = this.payService.postV3(url, WxGsonBuilder.create().toJson(map));
        return WxPayScoreResult.fromJson(result);
    }

    @Override
    public WxPayScoreResult createServiceOrder(WxPayScoreRequest request) throws WxPayException {
        boolean needUserConfirm = request.getNeedUserConfirm();
        WxPayConfig config = this.payService.getConfig();
        String url = this.payService.getPayBaseUrl() + "/v3/payscore/serviceorder";
        request.setAppid(config.getAppId());
        request.setServiceId(config.getServiceId());
        request.setNotifyUrl(config.getPayScoreNotifyUrl());
        String result = this.payService.postV3(url, request.toJson());
        WxPayScoreResult wxPayScoreCreateResult = WxPayScoreResult.fromJson(result);
        String currentTimeMillis = System.currentTimeMillis() + "";
        HashMap<String, String> signMap = new HashMap<String, String>(8);
        signMap.put("mch_id", config.getMchId());
        if (needUserConfirm) {
            signMap.put("package", wxPayScoreCreateResult.getPackageX());
        } else {
            signMap.put("service_id", config.getServiceId());
            signMap.put("out_order_no", request.getOutOrderNo());
        }
        signMap.put("timestamp", currentTimeMillis);
        signMap.put("nonce_str", currentTimeMillis);
        signMap.put("sign_type", "HMAC-SHA256");
        String sign = AesUtils.createSign(signMap, config.getMchKey());
        signMap.put("sign", sign);
        wxPayScoreCreateResult.setPayScoreSignInfo(signMap);
        return wxPayScoreCreateResult;
    }

    @Override
    public WxPayScoreResult queryServiceOrder(String outOrderNo, String queryId) throws WxPayException {
        URIBuilder uriBuilder;
        WxPayConfig config = this.payService.getConfig();
        String url = this.payService.getPayBaseUrl() + "/v3/payscore/serviceorder";
        try {
            uriBuilder = new URIBuilder(url);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{outOrderNo, queryId}) || !StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{outOrderNo, queryId})) {
            throw new WxPayException("out_order_no,query_id\u4e0d\u5141\u8bb8\u90fd\u586b\u5199\u6216\u90fd\u4e0d\u586b\u5199");
        }
        if (StringUtils.isNotEmpty((CharSequence)outOrderNo)) {
            uriBuilder.setParameter("out_order_no", outOrderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)queryId)) {
            uriBuilder.setParameter("query_id", queryId);
        }
        uriBuilder.setParameter("service_id", config.getServiceId());
        uriBuilder.setParameter("appid", config.getAppId());
        try {
            String result = this.payService.getV3(uriBuilder.build().toString());
            return WxPayScoreResult.fromJson(result);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public WxPayScoreResult cancelServiceOrder(String outOrderNo, String reason) throws WxPayException {
        WxPayConfig config = this.payService.getConfig();
        String url = String.format("%s/v3/payscore/serviceorder/%s/cancel", this.payService.getPayBaseUrl(), outOrderNo);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("appid", config.getAppId());
        map.put("service_id", config.getServiceId());
        map.put("reason", reason);
        String result = this.payService.postV3(url, WxGsonBuilder.create().toJson(map));
        return WxPayScoreResult.fromJson(result);
    }

    @Override
    public WxPayScoreResult modifyServiceOrder(WxPayScoreRequest request) throws WxPayException {
        WxPayConfig config = this.payService.getConfig();
        String outOrderNo = request.getOutOrderNo();
        String url = String.format("%s/v3/payscore/serviceorder/%s/modify", this.payService.getPayBaseUrl(), outOrderNo);
        request.setAppid(config.getAppId());
        request.setServiceId(config.getServiceId());
        request.setOutOrderNo(null);
        String result = this.payService.postV3(url, request.toJson());
        return WxPayScoreResult.fromJson(result);
    }

    @Override
    public WxPayScoreResult completeServiceOrder(WxPayScoreRequest request) throws WxPayException {
        WxPayConfig config = this.payService.getConfig();
        String outOrderNo = request.getOutOrderNo();
        String url = String.format("%s/v3/payscore/serviceorder/%s/complete", this.payService.getPayBaseUrl(), outOrderNo);
        request.setAppid(config.getAppId());
        request.setServiceId(config.getServiceId());
        request.setOutOrderNo(null);
        String result = this.payService.postV3(url, request.toJson());
        return WxPayScoreResult.fromJson(result);
    }

    @Override
    public WxPayScoreResult payServiceOrder(String outOrderNo) throws WxPayException {
        WxPayConfig config = this.payService.getConfig();
        String url = String.format("%s/v3/payscore/serviceorder/%s/pay", this.payService.getPayBaseUrl(), outOrderNo);
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("appid", config.getAppId());
        map.put("service_id", config.getServiceId());
        String result = this.payService.postV3(url, WxGsonBuilder.create().toJson(map));
        return WxPayScoreResult.fromJson(result);
    }

    @Override
    public WxPayScoreResult syncServiceOrder(WxPayScoreRequest request) throws WxPayException {
        WxPayConfig config = this.payService.getConfig();
        String outOrderNo = request.getOutOrderNo();
        String url = String.format("%s/v3/payscore/serviceorder/%s/sync", this.payService.getPayBaseUrl(), outOrderNo);
        request.setAppid(config.getAppId());
        request.setServiceId(config.getServiceId());
        request.setOutOrderNo(null);
        String result = this.payService.postV3(url, request.toJson());
        return WxPayScoreResult.fromJson(result);
    }

    @Override
    public UserAuthorizationStatusNotifyResult parseUserAuthorizationStatusNotifyResult(String notifyData, SignatureHeader header) throws WxPayException {
        PayScoreNotifyData response = this.parseNotifyData(notifyData, header);
        PayScoreNotifyData.Resource resource = response.getResource();
        String cipherText = resource.getCipherText();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.payService.getConfig().getApiV3Key();
        try {
            String result = AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key);
            UserAuthorizationStatusNotifyResult notifyResult = (UserAuthorizationStatusNotifyResult)GSON.fromJson(result, UserAuthorizationStatusNotifyResult.class);
            notifyResult.setRawData(response);
            return notifyResult;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public PayScoreNotifyData parseNotifyData(String data, SignatureHeader header) throws WxPayException {
        if (Objects.nonNull(header) && !this.verifyNotifySign(header, data)) {
            throw new WxPayException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5934\u90e8\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25");
        }
        return (PayScoreNotifyData)GSON.fromJson(data, PayScoreNotifyData.class);
    }

    @Override
    public WxPayScoreResult decryptNotifyDataResource(PayScoreNotifyData data) throws WxPayException {
        PayScoreNotifyData.Resource resource = data.getResource();
        String cipherText = resource.getCipherText();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.payService.getConfig().getApiV3Key();
        try {
            return WxPayScoreResult.fromJson(AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    private boolean verifyNotifySign(SignatureHeader header, String data) {
        String beforeSign = String.format("%s%n%s%n%s%n", header.getTimeStamp(), header.getNonce(), data);
        return this.payService.getConfig().getVerifier().verify(header.getSerialNo(), beforeSign.getBytes(StandardCharsets.UTF_8), header.getSigned());
    }

    public PayScoreServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

