/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import jodd.io.IOUtil;
import jodd.util.ClassUtil;

public class ResourcesUtils {
    public static URL getResourceUrl(String resourceName) {
        return ResourcesUtils.getResourceUrl(resourceName, null);
    }

    public static URL getResourceUrl(String resourceName, ClassLoader classLoader) {
        URL resourceUrl;
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if (classLoader != null && (resourceUrl = classLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentThreadClassLoader != null && currentThreadClassLoader != classLoader && (resourceUrl = currentThreadClassLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        Class callerClass = ClassUtil.getCallerClass((int)2);
        ClassLoader callerClassLoader = callerClass.getClassLoader();
        if (callerClassLoader != classLoader && callerClassLoader != currentThreadClassLoader) {
            resourceUrl = callerClassLoader.getResource(resourceName);
            return resourceUrl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceAsString(String resourceName) throws IOException {
        InputStream inputStream = ResourcesUtils.getResourceAsStream(resourceName);
        try {
            char[] data = IOUtil.readChars((InputStream)inputStream);
            String string = new String(data);
            return string;
        }
        finally {
            IOUtil.close((Closeable)inputStream);
        }
    }

    public static InputStream getResourceAsStream(String resourceName) throws IOException {
        return ResourcesUtils.getResourceAsStream(resourceName, null);
    }

    public static InputStream getResourceAsStream(String resourceName, ClassLoader callingClass) throws IOException {
        URL url = ResourcesUtils.getResourceUrl(resourceName, callingClass);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public static InputStream getResourceAsStream(String resourceName, ClassLoader callingClass, boolean useCache) throws IOException {
        URL url = ResourcesUtils.getResourceUrl(resourceName, callingClass);
        if (url != null) {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(useCache);
            return urlConnection.getInputStream();
        }
        return null;
    }
}

