/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.utils.qrcode.QrcodeUtils;
import com.github.binarywang.wxpay.bean.WxPayApiData;
import com.github.binarywang.wxpay.bean.coupon.WxPayCouponInfoQueryRequest;
import com.github.binarywang.wxpay.bean.coupon.WxPayCouponInfoQueryResult;
import com.github.binarywang.wxpay.bean.coupon.WxPayCouponSendRequest;
import com.github.binarywang.wxpay.bean.coupon.WxPayCouponSendResult;
import com.github.binarywang.wxpay.bean.coupon.WxPayCouponStockQueryRequest;
import com.github.binarywang.wxpay.bean.coupon.WxPayCouponStockQueryResult;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxScanPayNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayMwebOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayNativeOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayAuthcode2OpenidRequest;
import com.github.binarywang.wxpay.bean.request.WxPayDefaultRequest;
import com.github.binarywang.wxpay.bean.request.WxPayDownloadBillRequest;
import com.github.binarywang.wxpay.bean.request.WxPayDownloadFundFlowRequest;
import com.github.binarywang.wxpay.bean.request.WxPayMicropayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderCloseRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderReverseRequest;
import com.github.binarywang.wxpay.bean.request.WxPayQueryCommentRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRedpackQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundRequest;
import com.github.binarywang.wxpay.bean.request.WxPayReportRequest;
import com.github.binarywang.wxpay.bean.request.WxPaySendRedpackRequest;
import com.github.binarywang.wxpay.bean.request.WxPayShorturlRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.bean.result.WxPayAuthcode2OpenidResult;
import com.github.binarywang.wxpay.bean.result.WxPayBillResult;
import com.github.binarywang.wxpay.bean.result.WxPayCommonResult;
import com.github.binarywang.wxpay.bean.result.WxPayFundFlowBaseResult;
import com.github.binarywang.wxpay.bean.result.WxPayFundFlowResult;
import com.github.binarywang.wxpay.bean.result.WxPayMicropayResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderCloseResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderReverseResult;
import com.github.binarywang.wxpay.bean.result.WxPayRedpackQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundResult;
import com.github.binarywang.wxpay.bean.result.WxPaySandboxSignKeyResult;
import com.github.binarywang.wxpay.bean.result.WxPaySendRedpackResult;
import com.github.binarywang.wxpay.bean.result.WxPayShorturlResult;
import com.github.binarywang.wxpay.bean.result.WxPayUnifiedOrderResult;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.constant.WxPayConstants;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.EntPayService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.EntPayServiceImpl;
import com.github.binarywang.wxpay.util.SignUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import jodd.io.ZipUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWxPayServiceImpl
implements WxPayService {
    private static final String PAY_BASE_URL = "https://api.mch.weixin.qq.com";
    private static final String TOTAL_FUND_COUNT = "\u8d44\u91d1\u6d41\u6c34\u603b\u7b14\u6570";
    final Logger log = LoggerFactory.getLogger(this.getClass());
    static ThreadLocal<WxPayApiData> wxApiData = new ThreadLocal();
    private EntPayService entPayService = new EntPayServiceImpl(this);
    protected WxPayConfig config;

    @Override
    public EntPayService getEntPayService() {
        return this.entPayService;
    }

    @Override
    public void setEntPayService(EntPayService entPayService) {
        this.entPayService = entPayService;
    }

    @Override
    public WxPayConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(WxPayConfig config) {
        this.config = config;
    }

    @Override
    public String getPayBaseUrl() {
        if (this.getConfig().isUseSandboxEnv()) {
            return "https://api.mch.weixin.qq.com/sandboxnew";
        }
        return PAY_BASE_URL;
    }

    @Override
    public WxPayRefundResult refund(WxPayRefundRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/secapi/pay/refund";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayRefundResult result = WxPayRefundResult.fromXML(responseContent);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayRefundQueryResult refundQuery(String transactionId, String outTradeNo, String outRefundNo, String refundId) throws WxPayException {
        WxPayRefundQueryRequest request = new WxPayRefundQueryRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setTransactionId(StringUtils.trimToNull((String)transactionId));
        request.setOutRefundNo(StringUtils.trimToNull((String)outRefundNo));
        request.setRefundId(StringUtils.trimToNull((String)refundId));
        return this.refundQuery(request);
    }

    @Override
    public WxPayRefundQueryResult refundQuery(WxPayRefundQueryRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/refundquery";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayRefundQueryResult result = BaseWxPayResult.fromXML(responseContent, WxPayRefundQueryResult.class);
        result.composeRefundRecords();
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayOrderNotifyResult parseOrderNotifyResult(String xmlData) throws WxPayException {
        try {
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)xmlData);
            WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u8bf7\u6c42\u89e3\u6790\u540e\u7684\u5bf9\u8c61\uff1a{}", (Object)result);
            result.checkResult(this, this.getConfig().getSignType(), false);
            return result;
        }
        catch (WxPayException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new WxPayException("\u53d1\u751f\u5f02\u5e38\uff0c" + e.getMessage(), e);
        }
    }

    @Override
    public WxPayRefundNotifyResult parseRefundNotifyResult(String xmlData) throws WxPayException {
        try {
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u9000\u6b3e\u5f02\u6b65\u901a\u77e5\u53c2\u6570\uff1a{}", (Object)xmlData);
            WxPayRefundNotifyResult result = WxPayRefundNotifyResult.fromXML(xmlData, this.getConfig().getMchKey());
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u9000\u6b3e\u5f02\u6b65\u901a\u77e5\u89e3\u6790\u540e\u7684\u5bf9\u8c61\uff1a{}", (Object)result);
            return result;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new WxPayException("\u53d1\u751f\u5f02\u5e38\uff0c" + e.getMessage(), e);
        }
    }

    @Override
    public WxScanPayNotifyResult parseScanPayNotifyResult(String xmlData) throws WxPayException {
        try {
            this.log.debug("\u626b\u7801\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)xmlData);
            WxScanPayNotifyResult result = BaseWxPayResult.fromXML(xmlData, WxScanPayNotifyResult.class);
            this.log.debug("\u626b\u7801\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u89e3\u6790\u540e\u7684\u5bf9\u8c61\uff1a{}", (Object)result);
            result.checkResult(this, this.getConfig().getSignType(), false);
            return result;
        }
        catch (WxPayException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new WxPayException("\u53d1\u751f\u5f02\u5e38\uff0c" + e.getMessage(), e);
        }
    }

    @Override
    public WxPaySendRedpackResult sendRedpack(WxPaySendRedpackRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/sendredpack";
        if (request.getAmtType() != null) {
            url = this.getPayBaseUrl() + "/mmpaymkttransfers/sendgroupredpack";
        }
        String responseContent = this.post(url, request.toXML(), true);
        return BaseWxPayResult.fromXML(responseContent, WxPaySendRedpackResult.class);
    }

    @Override
    public WxPayRedpackQueryResult queryRedpack(String mchBillNo) throws WxPayException {
        WxPayRedpackQueryRequest request = new WxPayRedpackQueryRequest();
        request.setMchBillNo(mchBillNo);
        request.setBillType("MCHT");
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/gethbinfo";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayRedpackQueryResult result = BaseWxPayResult.fromXML(responseContent, WxPayRedpackQueryResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayOrderQueryResult queryOrder(String transactionId, String outTradeNo) throws WxPayException {
        WxPayOrderQueryRequest request = new WxPayOrderQueryRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setTransactionId(StringUtils.trimToNull((String)transactionId));
        return this.queryOrder(request);
    }

    @Override
    public WxPayOrderQueryResult queryOrder(WxPayOrderQueryRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/orderquery";
        String responseContent = this.post(url, request.toXML(), false);
        if (StringUtils.isBlank((CharSequence)responseContent)) {
            throw new WxPayException("\u65e0\u54cd\u5e94\u7ed3\u679c");
        }
        WxPayOrderQueryResult result = BaseWxPayResult.fromXML(responseContent, WxPayOrderQueryResult.class);
        result.composeCoupons();
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayOrderCloseResult closeOrder(String outTradeNo) throws WxPayException {
        if (StringUtils.isBlank((CharSequence)outTradeNo)) {
            throw new WxPayException("out_trade_no\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WxPayOrderCloseRequest request = new WxPayOrderCloseRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        return this.closeOrder(request);
    }

    @Override
    public WxPayOrderCloseResult closeOrder(WxPayOrderCloseRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/closeorder";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayOrderCloseResult result = BaseWxPayResult.fromXML(responseContent, WxPayOrderCloseResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public <T> T createOrder(WxPayUnifiedOrderRequest request) throws WxPayException {
        WxPayUnifiedOrderResult unifiedOrderResult = this.unifiedOrder(request);
        String prepayId = unifiedOrderResult.getPrepayId();
        if (StringUtils.isBlank((CharSequence)prepayId)) {
            throw new WxPayException(String.format("\u65e0\u6cd5\u83b7\u53d6prepay id\uff0c\u9519\u8bef\u4ee3\u7801\uff1a '%s'\uff0c\u4fe1\u606f\uff1a%s\u3002", unifiedOrderResult.getErrCode(), unifiedOrderResult.getErrCodeDes()));
        }
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonceStr = String.valueOf(System.currentTimeMillis());
        switch (request.getTradeType()) {
            case "MWEB": {
                return (T)new WxPayMwebOrderResult(unifiedOrderResult.getMwebUrl());
            }
            case "NATIVE": {
                return (T)new WxPayNativeOrderResult(unifiedOrderResult.getCodeURL());
            }
            case "APP": {
                String appId = unifiedOrderResult.getAppid();
                if (StringUtils.isNotEmpty((CharSequence)unifiedOrderResult.getSubAppId())) {
                    appId = unifiedOrderResult.getSubAppId();
                }
                HashMap<String, String> configMap = new HashMap<String, String>(8);
                String partnerId = StringUtils.isEmpty((CharSequence)request.getMchId()) ? this.getConfig().getMchId() : request.getMchId();
                configMap.put("prepayid", prepayId);
                configMap.put("partnerid", partnerId);
                String packageValue = "Sign=WXPay";
                configMap.put("package", packageValue);
                configMap.put("timestamp", timestamp);
                configMap.put("noncestr", nonceStr);
                configMap.put("appid", appId);
                WxPayAppOrderResult result = WxPayAppOrderResult.builder().sign(SignUtils.createSign(configMap, null, this.getConfig().getMchKey(), null)).prepayId(prepayId).partnerId(partnerId).appId(appId).packageValue(packageValue).timeStamp(timestamp).nonceStr(nonceStr).build();
                return (T)result;
            }
            case "JSAPI": {
                String signType = "MD5";
                String appid = unifiedOrderResult.getAppid();
                if (StringUtils.isNotEmpty((CharSequence)unifiedOrderResult.getSubAppId())) {
                    appid = unifiedOrderResult.getSubAppId();
                }
                WxPayMpOrderResult payResult = WxPayMpOrderResult.builder().appId(appid).timeStamp(timestamp).nonceStr(nonceStr).packageValue("prepay_id=" + prepayId).signType(signType).build();
                payResult.setPaySign(SignUtils.createSign(payResult, signType, this.getConfig().getMchKey(), null));
                return (T)payResult;
            }
        }
        throw new WxPayException("\u8be5\u4ea4\u6613\u7c7b\u578b\u6682\u4e0d\u652f\u6301");
    }

    @Override
    public WxPayUnifiedOrderResult unifiedOrder(WxPayUnifiedOrderRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/unifiedorder";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayUnifiedOrderResult result = BaseWxPayResult.fromXML(responseContent, WxPayUnifiedOrderResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    @Deprecated
    public Map<String, String> getPayInfo(WxPayUnifiedOrderRequest request) throws WxPayException {
        WxPayUnifiedOrderResult unifiedOrderResult = this.unifiedOrder(request);
        String prepayId = unifiedOrderResult.getPrepayId();
        if (StringUtils.isBlank((CharSequence)prepayId)) {
            throw new RuntimeException(String.format("\u65e0\u6cd5\u83b7\u53d6prepay id\uff0c\u9519\u8bef\u4ee3\u7801\uff1a '%s'\uff0c\u4fe1\u606f\uff1a%s\u3002", unifiedOrderResult.getErrCode(), unifiedOrderResult.getErrCodeDes()));
        }
        HashMap<String, String> payInfo = new HashMap<String, String>();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonceStr = String.valueOf(System.currentTimeMillis());
        if ("NATIVE".equals(request.getTradeType())) {
            payInfo.put("codeUrl", unifiedOrderResult.getCodeURL());
        } else if ("APP".equals(request.getTradeType())) {
            String appId = this.getConfig().getAppId();
            HashMap<String, String> configMap = new HashMap<String, String>();
            String partnerId = this.getConfig().getMchId();
            configMap.put("prepayid", prepayId);
            configMap.put("partnerid", partnerId);
            String packageValue = "Sign=WXPay";
            configMap.put("package", packageValue);
            configMap.put("timestamp", timestamp);
            configMap.put("noncestr", nonceStr);
            configMap.put("appid", appId);
            payInfo.put("sign", SignUtils.createSign(configMap, null, this.getConfig().getMchKey(), null));
            payInfo.put("prepayId", prepayId);
            payInfo.put("partnerId", partnerId);
            payInfo.put("appId", appId);
            payInfo.put("packageValue", packageValue);
            payInfo.put("timeStamp", timestamp);
            payInfo.put("nonceStr", nonceStr);
        } else if ("JSAPI".equals(request.getTradeType())) {
            payInfo.put("appId", unifiedOrderResult.getAppid());
            payInfo.put("timeStamp", timestamp);
            payInfo.put("nonceStr", nonceStr);
            payInfo.put("package", "prepay_id=" + prepayId);
            payInfo.put("signType", "MD5");
            payInfo.put("paySign", SignUtils.createSign(payInfo, null, this.getConfig().getMchKey(), null));
        }
        return payInfo;
    }

    @Override
    public byte[] createScanPayQrcodeMode1(String productId, File logoFile, Integer sideLength) {
        String content = this.createScanPayQrcodeMode1(productId);
        return this.createQrcode(content, logoFile, sideLength);
    }

    @Override
    public String createScanPayQrcodeMode1(String productId) {
        StringBuilder codeUrl = new StringBuilder("weixin://wxpay/bizpayurl?");
        HashMap params = Maps.newHashMap();
        params.put("appid", this.getConfig().getAppId());
        params.put("mch_id", this.getConfig().getMchId());
        params.put("product_id", productId);
        params.put("time_stamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("nonce_str", String.valueOf(System.currentTimeMillis()));
        String sign = SignUtils.createSign(params, null, this.getConfig().getMchKey(), null);
        params.put("sign", sign);
        for (String key : params.keySet()) {
            codeUrl.append(key).append("=").append((String)params.get(key)).append("&");
        }
        String content = codeUrl.toString().substring(0, codeUrl.length() - 1);
        this.log.debug("\u626b\u7801\u652f\u4ed8\u6a21\u5f0f\u4e00\u751f\u6210\u4e8c\u7ef4\u7801\u7684URL:{}", (Object)content);
        return content;
    }

    @Override
    public byte[] createScanPayQrcodeMode2(String codeUrl, File logoFile, Integer sideLength) {
        return this.createQrcode(codeUrl, logoFile, sideLength);
    }

    private byte[] createQrcode(String content, File logoFile, Integer sideLength) {
        if (sideLength == null || sideLength < 1) {
            return QrcodeUtils.createQrcode((String)content, (File)logoFile);
        }
        return QrcodeUtils.createQrcode((String)content, (int)sideLength, (File)logoFile);
    }

    @Override
    public void report(WxPayReportRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/payitil/report";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayCommonResult result = BaseWxPayResult.fromXML(responseContent, WxPayCommonResult.class);
        result.checkResult(this, request.getSignType(), true);
    }

    @Override
    public String downloadRawBill(String billDate, String billType, String tarType, String deviceInfo) throws WxPayException {
        return this.downloadRawBill(this.buildDownloadBillRequest(billDate, billType, tarType, deviceInfo));
    }

    @Override
    public WxPayBillResult downloadBill(String billDate, String billType, String tarType, String deviceInfo) throws WxPayException {
        return this.downloadBill(this.buildDownloadBillRequest(billDate, billType, tarType, deviceInfo));
    }

    private WxPayDownloadBillRequest buildDownloadBillRequest(String billDate, String billType, String tarType, String deviceInfo) throws WxPayException {
        if (!"ALL".equals(billType)) {
            throw new WxPayException("\u76ee\u524d\u4ec5\u652f\u6301ALL\u7c7b\u578b\u7684\u5bf9\u8d26\u5355\u4e0b\u8f7d");
        }
        WxPayDownloadBillRequest request = new WxPayDownloadBillRequest();
        request.setBillType(billType);
        request.setBillDate(billDate);
        request.setTarType(tarType);
        request.setDeviceInfo(deviceInfo);
        return request;
    }

    @Override
    public WxPayBillResult downloadBill(WxPayDownloadBillRequest request) throws WxPayException {
        String responseContent = this.downloadRawBill(request);
        if (StringUtils.isEmpty((CharSequence)responseContent)) {
            return null;
        }
        return this.handleBill(request.getBillType(), responseContent);
    }

    @Override
    public String downloadRawBill(WxPayDownloadBillRequest request) throws WxPayException {
        String responseContent;
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/downloadbill";
        if ("GZIP".equals(request.getTarType())) {
            responseContent = this.handleGzipBill(url, request.toXML());
        } else {
            responseContent = this.post(url, request.toXML(), false);
            if (responseContent.startsWith("<")) {
                throw WxPayException.from(BaseWxPayResult.fromXML(responseContent, WxPayCommonResult.class));
            }
        }
        return responseContent;
    }

    private WxPayBillResult handleBill(String billType, String responseContent) {
        if (!"ALL".equals(billType)) {
            return null;
        }
        return WxPayBillResult.fromRawBillResultString(responseContent);
    }

    private String handleGzipBill(String url, String requestStr) {
        try {
            byte[] responseBytes = this.postForBytes(url, requestStr, false);
            Path tempDirectory = Files.createTempDirectory("bill", new FileAttribute[0]);
            Path path = Paths.get(tempDirectory.toString(), System.currentTimeMillis() + ".gzip");
            Files.write(path, responseBytes, new OpenOption[0]);
            try {
                List<String> allLines = Files.readAllLines(ZipUtil.ungzip((File)path.toFile()).toPath(), StandardCharsets.UTF_8);
                return Joiner.on((String)"\n").join(allLines);
            }
            catch (ZipException e) {
                if (e.getMessage().contains("Not in GZIP format")) {
                    throw WxPayException.from(BaseWxPayResult.fromXML(new String(responseBytes, StandardCharsets.UTF_8), WxPayCommonResult.class));
                }
                this.log.error("\u89e3\u538bzip\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.log.error("\u89e3\u6790\u5bf9\u8d26\u5355\u6587\u4ef6\u65f6\u51fa\u9519", (Throwable)e);
        }
        return null;
    }

    @Override
    public WxPayFundFlowResult downloadFundFlow(String billDate, String accountType, String tarType) throws WxPayException {
        WxPayDownloadFundFlowRequest request = new WxPayDownloadFundFlowRequest();
        request.setBillDate(billDate);
        request.setAccountType(accountType);
        request.setTarType(tarType);
        return this.downloadFundFlow(request);
    }

    @Override
    public WxPayFundFlowResult downloadFundFlow(WxPayDownloadFundFlowRequest request) throws WxPayException {
        String responseContent;
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/downloadfundflow";
        if ("GZIP".equals(request.getTarType())) {
            responseContent = this.handleGzipFundFlow(url, request.toXML());
        } else {
            responseContent = this.post(url, request.toXML(), true);
            if (responseContent.startsWith("<")) {
                throw WxPayException.from(BaseWxPayResult.fromXML(responseContent, WxPayCommonResult.class));
            }
        }
        return this.handleFundFlow(responseContent);
    }

    private String handleGzipFundFlow(String url, String requestStr) throws WxPayException {
        try {
            byte[] responseBytes = this.postForBytes(url, requestStr, true);
            Path tempDirectory = Files.createTempDirectory("fundFlow", new FileAttribute[0]);
            Path path = Paths.get(tempDirectory.toString(), System.currentTimeMillis() + ".gzip");
            Files.write(path, responseBytes, new OpenOption[0]);
            try {
                List<String> allLines = Files.readAllLines(ZipUtil.ungzip((File)path.toFile()).toPath(), StandardCharsets.UTF_8);
                return Joiner.on((String)"\n").join(allLines);
            }
            catch (ZipException e) {
                if (e.getMessage().contains("Not in GZIP format")) {
                    throw WxPayException.from(BaseWxPayResult.fromXML(new String(responseBytes, StandardCharsets.UTF_8), WxPayCommonResult.class));
                }
                this.log.error("\u89e3\u538bzip\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                throw new WxPayException("\u89e3\u538bzip\u6587\u4ef6\u51fa\u9519");
            }
        }
        catch (WxPayException wxPayException) {
            throw wxPayException;
        }
        catch (Exception e) {
            this.log.error("\u89e3\u6790\u5bf9\u8d26\u5355\u6587\u4ef6\u65f6\u51fa\u9519", (Throwable)e);
            throw new WxPayException("\u89e3\u538bzip\u6587\u4ef6\u51fa\u9519");
        }
    }

    private WxPayFundFlowResult handleFundFlow(String responseContent) {
        WxPayFundFlowResult wxPayFundFlowResult = new WxPayFundFlowResult();
        String listStr = "";
        String objStr = "";
        if (StringUtils.isNotBlank((CharSequence)responseContent) && responseContent.contains(TOTAL_FUND_COUNT)) {
            listStr = responseContent.substring(0, responseContent.indexOf(TOTAL_FUND_COUNT));
            objStr = responseContent.substring(responseContent.indexOf(TOTAL_FUND_COUNT));
        }
        LinkedList<WxPayFundFlowBaseResult> wxPayFundFlowBaseResultList = new LinkedList<WxPayFundFlowBaseResult>();
        String newStr = listStr.replaceAll(",", " ");
        String[] tempStr = newStr.split("`");
        String[] t = tempStr[0].split(" ");
        int j = tempStr.length / t.length;
        int k = 1;
        for (int i = 0; i < j; ++i) {
            WxPayFundFlowBaseResult wxPayFundFlowBaseResult = new WxPayFundFlowBaseResult();
            wxPayFundFlowBaseResult.setBillingTime(tempStr[k].trim());
            wxPayFundFlowBaseResult.setBizTransactionId(tempStr[k + 1].trim());
            wxPayFundFlowBaseResult.setFundFlowId(tempStr[k + 2].trim());
            wxPayFundFlowBaseResult.setBizName(tempStr[k + 3].trim());
            wxPayFundFlowBaseResult.setBizType(tempStr[k + 4].trim());
            wxPayFundFlowBaseResult.setFinancialType(tempStr[k + 5].trim());
            wxPayFundFlowBaseResult.setFinancialFee(tempStr[k + 6].trim());
            wxPayFundFlowBaseResult.setAccountBalance(tempStr[k + 7].trim());
            wxPayFundFlowBaseResult.setFundApplicant(tempStr[k + 8].trim());
            wxPayFundFlowBaseResult.setMemo(tempStr[k + 9].trim());
            wxPayFundFlowBaseResult.setBizVoucherId(tempStr[k + 10].trim());
            wxPayFundFlowBaseResultList.add(wxPayFundFlowBaseResult);
            k += t.length;
        }
        wxPayFundFlowResult.setWxPayFundFlowBaseResultList(wxPayFundFlowBaseResultList);
        String totalStr = objStr.replaceAll(",", " ");
        String[] totalTempStr = totalStr.split("`");
        wxPayFundFlowResult.setTotalRecord(totalTempStr[1]);
        wxPayFundFlowResult.setIncomeRecord(totalTempStr[2]);
        wxPayFundFlowResult.setIncomeAmount(totalTempStr[3]);
        wxPayFundFlowResult.setExpenditureRecord(totalTempStr[4]);
        wxPayFundFlowResult.setExpenditureAmount(totalTempStr[5]);
        return wxPayFundFlowResult;
    }

    @Override
    public WxPayMicropayResult micropay(WxPayMicropayRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/micropay";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayMicropayResult result = BaseWxPayResult.fromXML(responseContent, WxPayMicropayResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayOrderReverseResult reverseOrder(WxPayOrderReverseRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/secapi/pay/reverse";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayOrderReverseResult result = BaseWxPayResult.fromXML(responseContent, WxPayOrderReverseResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public String shorturl(WxPayShorturlRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/tools/shorturl";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayShorturlResult result = BaseWxPayResult.fromXML(responseContent, WxPayShorturlResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result.getShortUrl();
    }

    @Override
    public String shorturl(String longUrl) throws WxPayException {
        return this.shorturl(new WxPayShorturlRequest(longUrl));
    }

    @Override
    public String authcode2Openid(WxPayAuthcode2OpenidRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/tools/authcodetoopenid";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayAuthcode2OpenidResult result = BaseWxPayResult.fromXML(responseContent, WxPayAuthcode2OpenidResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result.getOpenid();
    }

    @Override
    public String authcode2Openid(String authCode) throws WxPayException {
        return this.authcode2Openid(new WxPayAuthcode2OpenidRequest(authCode));
    }

    @Override
    public String getSandboxSignKey() throws WxPayException {
        WxPayDefaultRequest request = new WxPayDefaultRequest();
        request.checkAndSign(this.getConfig());
        String url = "https://api.mch.weixin.qq.com/sandboxnew/pay/getsignkey";
        String responseContent = this.post(url, request.toXML(), false);
        WxPaySandboxSignKeyResult result = BaseWxPayResult.fromXML(responseContent, WxPaySandboxSignKeyResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result.getSandboxSignKey();
    }

    @Override
    public WxPayCouponSendResult sendCoupon(WxPayCouponSendRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/send_coupon";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayCouponSendResult result = BaseWxPayResult.fromXML(responseContent, WxPayCouponSendResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayCouponStockQueryResult queryCouponStock(WxPayCouponStockQueryRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/query_coupon_stock";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayCouponStockQueryResult result = BaseWxPayResult.fromXML(responseContent, WxPayCouponStockQueryResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayCouponInfoQueryResult queryCouponInfo(WxPayCouponInfoQueryRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/querycouponsinfo";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayCouponInfoQueryResult result = BaseWxPayResult.fromXML(responseContent, WxPayCouponInfoQueryResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayApiData getWxApiData() {
        try {
            WxPayApiData wxPayApiData = wxApiData.get();
            return wxPayApiData;
        }
        finally {
            wxApiData.remove();
        }
    }

    @Override
    public String queryComment(Date beginDate, Date endDate, Integer offset, Integer limit) throws WxPayException {
        WxPayQueryCommentRequest request = new WxPayQueryCommentRequest();
        request.setBeginTime(WxPayConstants.QUERY_COMMENT_DATE_FORMAT.format(beginDate));
        request.setEndTime(WxPayConstants.QUERY_COMMENT_DATE_FORMAT.format(endDate));
        request.setOffset(offset);
        request.setLimit(limit);
        request.setSignType("HMAC-SHA256");
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/billcommentsp/batchquerycomment";
        String responseContent = this.post(url, request.toXML(), true);
        if (responseContent.startsWith("<")) {
            throw WxPayException.from(BaseWxPayResult.fromXML(responseContent, WxPayCommonResult.class));
        }
        return responseContent;
    }
}

