/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.util;

import com.google.common.collect.Lists;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import me.chanjar.weixin.common.util.BeanUtils;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtils {
    private static final Logger log = LoggerFactory.getLogger(SignUtils.class);

    public static String createSign(Object xmlBean, String signType, String signKey, boolean isIgnoreSignType) {
        return SignUtils.createSign(BeanUtils.xmlBean2Map((Object)xmlBean), signType, signKey, isIgnoreSignType);
    }

    public static String createSign(Map<String, String> params, String signType, String signKey, boolean isIgnoreSignType) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(params);
        StringBuilder toSign = new StringBuilder();
        for (String key : sortedMap.keySet()) {
            String value = params.get(key);
            boolean shouldSign = false;
            if (isIgnoreSignType && "sign_type".equals(key)) {
                shouldSign = false;
            } else if (StringUtils.isNotEmpty((CharSequence)value) && !Lists.newArrayList((Object[])new String[]{"sign", "key"}).contains(key)) {
                shouldSign = true;
            }
            if (!shouldSign) continue;
            toSign.append(key).append("=").append(value).append("&");
        }
        toSign.append("key=").append(signKey);
        if ("HMAC-SHA256".equals(signType)) {
            return SignUtils.createHMACSha256Sign(toSign.toString(), signKey);
        }
        return DigestUtils.md5Hex((String)toSign.toString()).toUpperCase();
    }

    private static String createHMACSha256Sign(String message, String key) {
        try {
            Mac hmacSHA256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), "HmacSHA256");
            hmacSHA256.init(secretKeySpec);
            byte[] bytes = hmacSHA256.doFinal(message.getBytes());
            return Hex.encodeHexString((byte[])bytes).toUpperCase();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean checkSign(Object xmlBean, String signType, String signKey) {
        return SignUtils.checkSign(BeanUtils.xmlBean2Map((Object)xmlBean), signType, signKey);
    }

    public static boolean checkSign(Map<String, String> params, String signType, String signKey) {
        String sign = SignUtils.createSign(params, signType, signKey, false);
        return sign.equals(params.get("sign"));
    }
}

