/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.config;

import com.github.binarywang.wxpay.exception.WxPayException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ssl.SSLContexts;

public class WxPayConfig {
    private String appId;
    private String subAppId;
    private String mchId;
    private String mchKey;
    private String subMchId;
    private String notifyUrl;
    private String tradeType;
    private SSLContext sslContext;
    private String keyPath;
    private boolean useSandboxEnv = false;

    public String getKeyPath() {
        return this.keyPath;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
    }

    public String getMchId() {
        return this.mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getMchKey() {
        return this.mchKey;
    }

    public void setMchKey(String mchKey) {
        this.mchKey = mchKey;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSubAppId() {
        return this.subAppId;
    }

    public void setSubAppId(String subAppId) {
        this.subAppId = subAppId;
    }

    public String getSubMchId() {
        return this.subMchId;
    }

    public void setSubMchId(String subMchId) {
        this.subMchId = subMchId;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public boolean useSandbox() {
        return this.useSandboxEnv;
    }

    public void setUseSandboxEnv(boolean useSandboxEnv) {
        this.useSandboxEnv = useSandboxEnv;
    }

    public SSLContext initSSLContext() throws WxPayException {
        InputStream inputStream;
        if (StringUtils.isBlank((CharSequence)this.mchId)) {
            throw new IllegalArgumentException("\u8bf7\u786e\u4fdd\u5546\u6237\u53f7mchId\u5df2\u8bbe\u7f6e");
        }
        if (StringUtils.isBlank((CharSequence)this.keyPath)) {
            throw new IllegalArgumentException("\u8bf7\u786e\u4fdd\u8bc1\u4e66\u6587\u4ef6\u5730\u5740keyPath\u5df2\u914d\u7f6e");
        }
        String prefix = "classpath:";
        if (this.keyPath.startsWith("classpath:")) {
            inputStream = WxPayConfig.class.getResourceAsStream(this.keyPath.replace("classpath:", ""));
        } else {
            try {
                File file = new File(this.keyPath);
                if (!file.exists()) {
                    throw new WxPayException("\u8bc1\u4e66\u6587\u4ef6\u3010" + file.getPath() + "\u3011\u4e0d\u5b58\u5728\uff01");
                }
                inputStream = new FileInputStream(file);
            }
            catch (IOException e) {
                throw new WxPayException("\u8bc1\u4e66\u6587\u4ef6\u6709\u95ee\u9898\uff0c\u8bf7\u6838\u5b9e\uff01", e);
            }
        }
        try {
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            char[] partnerId2charArray = this.mchId.toCharArray();
            keystore.load(inputStream, partnerId2charArray);
            SSLContext sSLContext = this.sslContext = SSLContexts.custom().loadKeyMaterial(keystore, partnerId2charArray).build();
            return sSLContext;
        }
        catch (Exception e) {
            throw new WxPayException("\u8bc1\u4e66\u6587\u4ef6\u6709\u95ee\u9898\uff0c\u8bf7\u6838\u5b9e\uff01", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

