/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.WxPayBaseRequest;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import me.chanjar.weixin.common.annotation.Required;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="xml")
public class WxPayUnifiedOrderRequest
extends WxPayBaseRequest {
    private static final String[] TRADE_TYPES = new String[]{"JSAPI", "NATIVE", "APP", "MWEB"};
    @XStreamAlias(value="device_info")
    private String deviceInfo;
    @Required
    @XStreamAlias(value="body")
    private String body;
    @XStreamAlias(value="detail")
    private String detail;
    @XStreamAlias(value="attach")
    private String attach;
    @Required
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @XStreamAlias(value="fee_type")
    private String feeType;
    @Required
    @XStreamAlias(value="total_fee")
    private Integer totalFee;
    @Required
    @XStreamAlias(value="spbill_create_ip")
    private String spbillCreateIp;
    @XStreamAlias(value="time_start")
    private String timeStart;
    @XStreamAlias(value="time_expire")
    private String timeExpire;
    @XStreamAlias(value="goods_tag")
    private String goodsTag;
    @Required
    @XStreamAlias(value="notify_url")
    private String notifyURL;
    @Required
    @XStreamAlias(value="trade_type")
    private String tradeType;
    @XStreamAlias(value="product_id")
    private String productId;
    @XStreamAlias(value="limit_pay")
    private String limitPay;
    @XStreamAlias(value="openid")
    private String openid;

    private WxPayUnifiedOrderRequest(Builder builder) {
        this.setAppid(builder.appid);
        this.setDeviceInfo(builder.deviceInfo);
        this.setMchId(builder.mchId);
        this.setBody(builder.body);
        this.setSubAppId(builder.subAppId);
        this.setSubMchId(builder.subMchId);
        this.setNonceStr(builder.nonceStr);
        this.setSign(builder.sign);
        this.setDetail(builder.detail);
        this.setAttach(builder.attach);
        this.setOutTradeNo(builder.outTradeNo);
        this.setFeeType(builder.feeType);
        this.setTotalFee(builder.totalFee);
        this.setSpbillCreateIp(builder.spbillCreateIp);
        this.setTimeStart(builder.timeStart);
        this.setTimeExpire(builder.timeExpire);
        this.setGoodsTag(builder.goodsTag);
        this.setNotifyURL(builder.notifyURL);
        this.setTradeType(builder.tradeType);
        this.setProductId(builder.productId);
        this.setLimitPay(builder.limitPay);
        this.setOpenid(builder.openid);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getAttach() {
        return this.attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public Integer getTotalFee() {
        return this.totalFee;
    }

    public void setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
    }

    public String getSpbillCreateIp() {
        return this.spbillCreateIp;
    }

    public void setSpbillCreateIp(String spbillCreateIp) {
        this.spbillCreateIp = spbillCreateIp;
    }

    public String getTimeStart() {
        return this.timeStart;
    }

    public void setTimeStart(String timeStart) {
        this.timeStart = timeStart;
    }

    public String getTimeExpire() {
        return this.timeExpire;
    }

    public void setTimeExpire(String timeExpire) {
        this.timeExpire = timeExpire;
    }

    public String getGoodsTag() {
        return this.goodsTag;
    }

    public void setGoodsTag(String goodsTag) {
        this.goodsTag = goodsTag;
    }

    public String getNotifyURL() {
        return this.notifyURL;
    }

    public void setNotifyURL(String notifyURL) {
        this.notifyURL = notifyURL;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getLimitPay() {
        return this.limitPay;
    }

    public void setLimitPay(String limitPay) {
        this.limitPay = limitPay;
    }

    public String getOpenid() {
        return this.openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    @Override
    protected void checkConstraints() {
        if ("JSAPI".equals(this.getTradeType()) && this.getOpenid() == null) {
            throw new IllegalArgumentException("\u5f53 trade_type\u662f'JSAPI'\u65f6\u672a\u6307\u5b9aopenid");
        }
        if ("NATIVE".equals(this.getTradeType()) && this.getProductId() == null) {
            throw new IllegalArgumentException("\u5f53 trade_type\u662f'NATIVE'\u65f6\u672a\u6307\u5b9aproduct_id");
        }
    }

    @Override
    public void checkAndSign(WxPayConfig config) throws WxPayException {
        if (StringUtils.isBlank((CharSequence)this.getNotifyURL())) {
            this.setNotifyURL(config.getNotifyUrl());
        }
        if (StringUtils.isBlank((CharSequence)this.getTradeType())) {
            this.setTradeType(config.getTradeType());
        }
        super.checkAndSign(config);
    }

    public static final class Builder {
        private String appid;
        private String deviceInfo;
        private String mchId;
        private String body;
        private String subAppId;
        private String subMchId;
        private String nonceStr;
        private String sign;
        private String detail;
        private String attach;
        private String outTradeNo;
        private String feeType;
        private Integer totalFee;
        private String spbillCreateIp;
        private String timeStart;
        private String timeExpire;
        private String goodsTag;
        private String notifyURL;
        private String tradeType;
        private String productId;
        private String limitPay;
        private String openid;

        private Builder() {
        }

        public Builder appid(String appid) {
            this.appid = appid;
            return this;
        }

        public Builder deviceInfo(String deviceInfo) {
            this.deviceInfo = deviceInfo;
            return this;
        }

        public Builder mchId(String mchId) {
            this.mchId = mchId;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder subAppId(String subAppId) {
            this.subAppId = subAppId;
            return this;
        }

        public Builder subMchId(String subMchId) {
            this.subMchId = subMchId;
            return this;
        }

        public Builder nonceStr(String nonceStr) {
            this.nonceStr = nonceStr;
            return this;
        }

        public Builder sign(String sign) {
            this.sign = sign;
            return this;
        }

        public Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public Builder attach(String attach) {
            this.attach = attach;
            return this;
        }

        public Builder outTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
            return this;
        }

        public Builder feeType(String feeType) {
            this.feeType = feeType;
            return this;
        }

        public Builder totalFee(Integer totalFee) {
            this.totalFee = totalFee;
            return this;
        }

        public Builder spbillCreateIp(String spbillCreateIp) {
            this.spbillCreateIp = spbillCreateIp;
            return this;
        }

        public Builder timeStart(String timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public Builder timeExpire(String timeExpire) {
            this.timeExpire = timeExpire;
            return this;
        }

        public Builder goodsTag(String goodsTag) {
            this.goodsTag = goodsTag;
            return this;
        }

        public Builder notifyURL(String notifyURL) {
            this.notifyURL = notifyURL;
            return this;
        }

        public Builder tradeType(String tradeType) {
            this.tradeType = tradeType;
            return this;
        }

        public Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public Builder limitPay(String limitPay) {
            this.limitPay = limitPay;
            return this;
        }

        public Builder openid(String openid) {
            this.openid = openid;
            return this;
        }

        public WxPayUnifiedOrderRequest build() {
            return new WxPayUnifiedOrderRequest(this);
        }
    }
}

