/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.BeanUtils;
import me.chanjar.weixin.common.util.xml.XStreamInitializer;
import me.chanjar.weixin.mp.api.WxMpPayService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.pay.WxPayJsSDKCallback;
import me.chanjar.weixin.mp.bean.pay.request.WxEntPayQueryRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxEntPayRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxPayOrderCloseRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxPayOrderQueryRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxPayRefundRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxPaySendRedpackRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxPayUnifiedOrderRequest;
import me.chanjar.weixin.mp.bean.pay.result.WxEntPayQueryResult;
import me.chanjar.weixin.mp.bean.pay.result.WxEntPayResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPayBaseResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPayOrderCloseResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPayOrderQueryResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPayRefundResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPaySendRedpackResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPayUnifiedOrderResult;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpPayServiceImpl
implements WxMpPayService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String PAY_BASE_URL = "https://api.mch.weixin.qq.com";
    private static final String[] TRADE_TYPES = new String[]{"JSAPI", "NATIVE", "APP"};
    private static final String[] REFUND_ACCOUNT = new String[]{"REFUND_SOURCE_RECHARGE_FUNDS", "REFUND_SOURCE_UNSETTLED_FUNDS"};
    private WxMpService wxMpService;

    public WxMpPayServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public WxPayRefundResult refund(WxPayRefundRequest request, File keyFile) throws WxErrorException {
        this.checkParameters(request);
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxPayRefundResult.class);
        xstream.processAnnotations(WxPayRefundRequest.class);
        request.setAppid(this.wxMpService.getWxMpConfigStorage().getAppId());
        String partnerId = this.wxMpService.getWxMpConfigStorage().getPartnerId();
        request.setMchId(partnerId);
        request.setNonceStr(System.currentTimeMillis() + "");
        request.setOpUserId(partnerId);
        String sign = this.createSign(BeanUtils.xmlBean2Map(request), this.wxMpService.getWxMpConfigStorage().getPartnerKey());
        request.setSign(sign);
        String url = "https://api.mch.weixin.qq.com/secapi/pay/refund";
        String responseContent = this.executeRequestWithKeyFile(url, keyFile, xstream.toXML(request), partnerId);
        WxPayRefundResult result = (WxPayRefundResult)xstream.fromXML(responseContent);
        this.checkResult(result);
        return result;
    }

    private void checkResult(WxPayBaseResult result) throws WxErrorException {
        if (!"SUCCESS".equalsIgnoreCase(result.getReturnCode()) || !"SUCCESS".equalsIgnoreCase(result.getResultCode())) {
            throw new WxErrorException(WxError.newBuilder().setErrorCode(-1).setErrorMsg("\u8fd4\u56de\u4ee3\u7801:" + result.getReturnCode() + ", \u8fd4\u56de\u4fe1\u606f: " + result.getReturnMsg() + ", \u7ed3\u679c\u4ee3\u7801: " + result.getResultCode() + ", \u9519\u8bef\u4ee3\u7801: " + result.getErrCode() + ", \u9519\u8bef\u8be6\u60c5: " + result.getErrCodeDes()).build());
        }
    }

    private void checkParameters(WxPayRefundRequest request) throws WxErrorException {
        BeanUtils.checkRequiredFields(request);
        if (StringUtils.isNotBlank((CharSequence)request.getRefundAccount()) && !ArrayUtils.contains((Object[])REFUND_ACCOUNT, (Object)request.getRefundAccount())) {
            throw new IllegalArgumentException("refund_account\u76ee\u524d\u5fc5\u987b\u4e3a" + Arrays.toString(REFUND_ACCOUNT) + "\u5176\u4e2d\u4e4b\u4e00");
        }
        if (StringUtils.isBlank((CharSequence)request.getOutTradeNo()) && StringUtils.isBlank((CharSequence)request.getTransactionId())) {
            throw new IllegalArgumentException("transaction_id \u548c out_trade_no \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u5fc5\u987b\u63d0\u4f9b\u4e00\u4e2a");
        }
    }

    @Override
    public WxPayJsSDKCallback getJSSDKCallbackData(String xmlData) throws WxErrorException {
        try {
            XStream xstream = XStreamInitializer.getInstance();
            xstream.alias("xml", WxPayJsSDKCallback.class);
            return (WxPayJsSDKCallback)xstream.fromXML(xmlData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u53d1\u751f\u5f02\u5e38" + e.getMessage()).build());
        }
    }

    @Override
    public boolean checkJSSDKCallbackDataSignature(Map<String, String> kvm, String signature) {
        return signature.equals(this.createSign(kvm, this.wxMpService.getWxMpConfigStorage().getPartnerKey()));
    }

    @Override
    public WxPaySendRedpackResult sendRedpack(WxPaySendRedpackRequest request, File keyFile) throws WxErrorException {
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxPaySendRedpackRequest.class);
        xstream.processAnnotations(WxPaySendRedpackResult.class);
        request.setWxAppid(this.wxMpService.getWxMpConfigStorage().getAppId());
        String mchId = this.wxMpService.getWxMpConfigStorage().getPartnerId();
        request.setMchId(mchId);
        request.setNonceStr(System.currentTimeMillis() + "");
        String sign = this.createSign(BeanUtils.xmlBean2Map(request), this.wxMpService.getWxMpConfigStorage().getPartnerKey());
        request.setSign(sign);
        String url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendredpack";
        if (request.getAmtType() != null) {
            url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendgroupredpack";
        }
        String responseContent = this.executeRequestWithKeyFile(url, keyFile, xstream.toXML(request), mchId);
        WxPaySendRedpackResult result = (WxPaySendRedpackResult)xstream.fromXML(responseContent);
        this.checkResult(result);
        return result;
    }

    private String createSign(Map<String, String> packageParams, String signKey) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(packageParams);
        StringBuffer toSign = new StringBuffer();
        for (String key : sortedMap.keySet()) {
            String value = packageParams.get(key);
            if (null == value || "".equals(value) || "sign".equals(key) || "key".equals(key)) continue;
            toSign.append(key + "=" + value + "&");
        }
        toSign.append("key=" + signKey);
        return DigestUtils.md5Hex((String)toSign.toString()).toUpperCase();
    }

    @Override
    public WxPayOrderQueryResult queryOrder(String transactionId, String outTradeNo) throws WxErrorException {
        if (StringUtils.isBlank((CharSequence)transactionId) && StringUtils.isBlank((CharSequence)outTradeNo) || StringUtils.isNotBlank((CharSequence)transactionId) && StringUtils.isNotBlank((CharSequence)outTradeNo)) {
            throw new IllegalArgumentException("transaction_id \u548c out_trade_no \u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u6216\u540c\u65f6\u4e3a\u7a7a\uff0c\u5fc5\u987b\u4e8c\u9009\u4e00");
        }
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxPayOrderQueryRequest.class);
        xstream.processAnnotations(WxPayOrderQueryResult.class);
        WxPayOrderQueryRequest request = new WxPayOrderQueryRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setTransactionId(StringUtils.trimToNull((String)transactionId));
        request.setAppid(this.wxMpService.getWxMpConfigStorage().getAppId());
        request.setMchId(this.wxMpService.getWxMpConfigStorage().getPartnerId());
        request.setNonceStr(System.currentTimeMillis() + "");
        String sign = this.createSign(BeanUtils.xmlBean2Map(request), this.wxMpService.getWxMpConfigStorage().getPartnerKey());
        request.setSign(sign);
        String url = "https://api.mch.weixin.qq.com/pay/orderquery";
        String responseContent = this.executeRequest(url, xstream.toXML(request));
        WxPayOrderQueryResult result = (WxPayOrderQueryResult)xstream.fromXML(responseContent);
        result.composeCoupons(responseContent);
        this.checkResult(result);
        return result;
    }

    @Override
    public WxPayOrderCloseResult closeOrder(String outTradeNo) throws WxErrorException {
        if (StringUtils.isBlank((CharSequence)outTradeNo)) {
            throw new IllegalArgumentException("out_trade_no \u4e0d\u80fd\u4e3a\u7a7a");
        }
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxPayOrderCloseRequest.class);
        xstream.processAnnotations(WxPayOrderCloseResult.class);
        WxPayOrderCloseRequest request = new WxPayOrderCloseRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setAppid(this.wxMpService.getWxMpConfigStorage().getAppId());
        request.setMchId(this.wxMpService.getWxMpConfigStorage().getPartnerId());
        request.setNonceStr(System.currentTimeMillis() + "");
        String sign = this.createSign(BeanUtils.xmlBean2Map(request), this.wxMpService.getWxMpConfigStorage().getPartnerKey());
        request.setSign(sign);
        String url = "https://api.mch.weixin.qq.com/pay/closeorder";
        String responseContent = this.executeRequest(url, xstream.toXML(request));
        WxPayOrderCloseResult result = (WxPayOrderCloseResult)xstream.fromXML(responseContent);
        this.checkResult(result);
        return result;
    }

    @Override
    public WxPayUnifiedOrderResult unifiedOrder(WxPayUnifiedOrderRequest request) throws WxErrorException {
        this.checkParameters(request);
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxPayUnifiedOrderRequest.class);
        xstream.processAnnotations(WxPayUnifiedOrderResult.class);
        request.setAppid(this.wxMpService.getWxMpConfigStorage().getAppId());
        request.setMchId(this.wxMpService.getWxMpConfigStorage().getPartnerId());
        request.setNonceStr(System.currentTimeMillis() + "");
        String sign = this.createSign(BeanUtils.xmlBean2Map(request), this.wxMpService.getWxMpConfigStorage().getPartnerKey());
        request.setSign(sign);
        String url = "https://api.mch.weixin.qq.com/pay/unifiedorder";
        String responseContent = this.executeRequest(url, xstream.toXML(request));
        WxPayUnifiedOrderResult result = (WxPayUnifiedOrderResult)xstream.fromXML(responseContent);
        this.checkResult(result);
        return result;
    }

    private void checkParameters(WxPayUnifiedOrderRequest request) throws WxErrorException {
        BeanUtils.checkRequiredFields(request);
        if (!ArrayUtils.contains((Object[])TRADE_TYPES, (Object)request.getTradeType())) {
            throw new IllegalArgumentException("trade_type\u76ee\u524d\u5fc5\u987b\u4e3a" + Arrays.toString(TRADE_TYPES) + "\u5176\u4e2d\u4e4b\u4e00");
        }
        if ("JSAPI".equals(request.getTradeType()) && request.getOpenid() == null) {
            throw new IllegalArgumentException("\u5f53 trade_type\u662f'JSAPI'\u65f6\u672a\u6307\u5b9aopenid");
        }
        if ("NATIVE".equals(request.getTradeType()) && request.getProductId() == null) {
            throw new IllegalArgumentException("\u5f53 trade_type\u662f'NATIVE'\u65f6\u672a\u6307\u5b9aproduct_id");
        }
    }

    @Override
    public Map<String, String> getPayInfo(WxPayUnifiedOrderRequest request) throws WxErrorException {
        WxPayUnifiedOrderResult unifiedOrderResult = this.unifiedOrder(request);
        String prepayId = unifiedOrderResult.getPrepayId();
        if (StringUtils.isBlank((CharSequence)prepayId)) {
            throw new RuntimeException(String.format("Failed to get prepay id due to error code '%s'(%s).", unifiedOrderResult.getErrCode(), unifiedOrderResult.getErrCodeDes()));
        }
        HashMap<String, String> payInfo = new HashMap<String, String>();
        payInfo.put("appId", this.wxMpService.getWxMpConfigStorage().getAppId());
        payInfo.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        payInfo.put("nonceStr", System.currentTimeMillis() + "");
        payInfo.put("package", "prepay_id=" + prepayId);
        payInfo.put("signType", "MD5");
        if ("NATIVE".equals(request.getTradeType())) {
            payInfo.put("codeUrl", unifiedOrderResult.getCodeURL());
        }
        String finalSign = this.createSign(payInfo, this.wxMpService.getWxMpConfigStorage().getPartnerKey());
        payInfo.put("paySign", finalSign);
        return payInfo;
    }

    @Override
    public WxEntPayResult entPay(WxEntPayRequest request, File keyFile) throws WxErrorException {
        BeanUtils.checkRequiredFields(request);
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxEntPayRequest.class);
        xstream.processAnnotations(WxEntPayResult.class);
        request.setMchAppid(this.wxMpService.getWxMpConfigStorage().getAppId());
        request.setMchId(this.wxMpService.getWxMpConfigStorage().getPartnerId());
        request.setNonceStr(System.currentTimeMillis() + "");
        String sign = this.createSign(BeanUtils.xmlBean2Map(request), this.wxMpService.getWxMpConfigStorage().getPartnerKey());
        request.setSign(sign);
        String url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers";
        String responseContent = this.executeRequestWithKeyFile(url, keyFile, xstream.toXML(request), request.getMchId());
        WxEntPayResult result = (WxEntPayResult)xstream.fromXML(responseContent);
        this.checkResult(result);
        return result;
    }

    @Override
    public WxEntPayQueryResult queryEntPay(String partnerTradeNo, File keyFile) throws WxErrorException {
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxEntPayQueryRequest.class);
        xstream.processAnnotations(WxEntPayQueryResult.class);
        WxEntPayQueryRequest request = new WxEntPayQueryRequest();
        request.setAppid(this.wxMpService.getWxMpConfigStorage().getAppId());
        request.setMchId(this.wxMpService.getWxMpConfigStorage().getPartnerId());
        request.setNonceStr(System.currentTimeMillis() + "");
        String sign = this.createSign(BeanUtils.xmlBean2Map(request), this.wxMpService.getWxMpConfigStorage().getPartnerKey());
        request.setSign(sign);
        String url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/gettransferinfo";
        String responseContent = this.executeRequestWithKeyFile(url, keyFile, xstream.toXML(request), request.getMchId());
        WxEntPayQueryResult result = (WxEntPayQueryResult)xstream.fromXML(responseContent);
        this.checkResult(result);
        return result;
    }

    /*
     * Exception decompiling
     */
    private String executeRequest(String url, String requestStr) throws WxErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String executeRequestWithKeyFile(String url, File keyFile, String requestStr, String mchId) throws WxErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

