/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.requestexecuter.material;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.util.requestexecuter.material.MaterialVoiceAndImageDownloadRequestExecutor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialVoiceAndImageDownloadOkhttpRequestExecutor
extends MaterialVoiceAndImageDownloadRequestExecutor<OkHttpClient, OkHttpProxyInfo> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public MaterialVoiceAndImageDownloadOkhttpRequestExecutor(RequestHttp requestHttp, File tmpDirFile) {
        super(requestHttp, tmpDirFile);
    }

    public InputStream execute(String uri, String materialId, WxType wxType) throws WxErrorException, IOException {
        this.logger.debug("MaterialVoiceAndImageDownloadOkhttpRequestExecutor is running");
        OkHttpClient client = (OkHttpClient)this.requestHttp.getRequestHttpClient();
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)WxGsonBuilder.create().toJson((Object)ImmutableMap.of((Object)"media_id", (Object)materialId)));
        Request request = new Request.Builder().url(uri).get().post(requestBody).build();
        Response response = client.newCall(request).execute();
        String contentTypeHeader = response.header("Content-Type");
        if ("text/plain".equals(contentTypeHeader) || "application/json; charset=utf-8".equals(contentTypeHeader) || "application/json; encoding=utf-8".equals(contentTypeHeader)) {
            String responseContent = response.body().string();
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MP));
        }
        byte[] responseContent = IOUtils.toByteArray((InputStream)response.body().source().inputStream());
        return new ByteArrayInputStream(responseContent);
    }
}

