/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http;

import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.Utf8ResponseHandler;
import me.chanjar.weixin.mp.bean.material.WxMediaImgUploadResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

public class MediaImgUploadRequestExecutor
implements RequestExecutor<WxMediaImgUploadResult, File> {
    public WxMediaImgUploadResult execute(CloseableHttpClient httpclient, HttpHost httpProxy, String uri, File data) throws WxErrorException, IOException {
        if (data == null) {
            throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u6587\u4ef6\u5bf9\u8c61\u4e3a\u7a7a").build());
        }
        HttpPost httpPost = new HttpPost(uri);
        if (httpProxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(httpProxy).build();
            httpPost.setConfig(config);
        }
        HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("media", data).setMode(HttpMultipartMode.RFC6532).build();
        httpPost.setEntity(entity);
        httpPost.setHeader("Content-Type", ContentType.MULTIPART_FORM_DATA.toString());
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
            String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
            WxError error = WxError.fromJson((String)responseContent);
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error);
            }
            WxMediaImgUploadResult wxMediaImgUploadResult = WxMediaImgUploadResult.fromJson(responseContent);
            return wxMediaImgUploadResult;
        }
    }
}

