/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.executor;

import cn.binarywang.wx.miniapp.bean.WxMaApiResponse;
import cn.binarywang.wx.miniapp.executor.ApiSignaturePostRequestExecutor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.hc.Utf8ResponseHandler;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class HttpComponentsApiSignaturePostRequestExecutor
extends ApiSignaturePostRequestExecutor<CloseableHttpClient, HttpHost> {
    public HttpComponentsApiSignaturePostRequestExecutor(RequestHttp<CloseableHttpClient, HttpHost> requestHttp) {
        super(requestHttp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WxMaApiResponse execute(String uri, Map<String, String> headers, String postEntity, WxType wxType) throws WxErrorException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((HttpPost)httpPost).addHeader(arg_0, arg_1));
        }
        if (postEntity != null) {
            StringEntity entity = new StringEntity(postEntity, ContentType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_8));
            httpPost.setEntity((HttpEntity)entity);
        }
        try (CloseableHttpResponse response = ((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((ClassicHttpRequest)httpPost);){
            String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((ClassicHttpResponse)response);
            HashMap<String, String> respHeaders = new HashMap<String, String>();
            Header[] rHeaders = response.getHeaders();
            if (rHeaders != null) {
                for (Header h : rHeaders) {
                    respHeaders.putIfAbsent(h.getName(), h.getValue());
                }
            }
            WxMaApiResponse wxMaApiResponse = this.handleResponse(wxType, responseContent, respHeaders);
            return wxMaApiResponse;
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException.getMessage(), (Throwable)httpException);
        }
    }
}

