/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.executor;

import cn.binarywang.wx.miniapp.bean.vod.WxMaVodUploadPartResult;
import cn.binarywang.wx.miniapp.executor.VodUploadPartRequestExecutor;
import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.apache.Utf8ResponseHandler;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

public class ApacheVodUploadPartRequestExecutor
extends VodUploadPartRequestExecutor<CloseableHttpClient, HttpHost> {
    public ApacheVodUploadPartRequestExecutor(RequestHttp<CloseableHttpClient, HttpHost> requestHttp, String uploadId, Integer partNumber, Integer resourceType) {
        super(requestHttp, uploadId, partNumber, resourceType);
    }

    /*
     * Loose catch block
     */
    public WxMaVodUploadPartResult execute(String uri, File file, WxType wxType) throws WxErrorException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        if (file != null) {
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532).addTextBody("upload_id", this.uploadId).addTextBody("part_number", String.valueOf(this.partNumber)).addTextBody("resource_type", String.valueOf(this.resourceType)).addBinaryBody("data", file);
            httpPost.setEntity(entityBuilder.build());
        }
        try {
            try (CloseableHttpResponse response = ((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((HttpUriRequest)httpPost);){
                String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
                WxError error = WxError.fromJson((String)responseContent, (WxType)wxType);
                if (error.getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                WxMaVodUploadPartResult wxMaVodUploadPartResult = WxMaVodUploadPartResult.fromJson(responseContent);
                return wxMaVodUploadPartResult;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            httpPost.releaseConnection();
        }
    }
}

