/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.impl.BaseWxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaStableAccessTokenRequest;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import java.io.Closeable;
import java.io.IOException;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.common.util.http.apache.DefaultApacheHttpClientBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaServiceHttpClientImpl
extends BaseWxMaServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(WxMaServiceHttpClientImpl.class);
    private CloseableHttpClient httpClient;
    private HttpHost httpProxy;

    @Override
    public void initHttp() {
        WxMaConfig configStorage = this.getWxMaConfig();
        ApacheHttpClientBuilder apacheHttpClientBuilder = configStorage.getApacheHttpClientBuilder();
        if (null == apacheHttpClientBuilder) {
            apacheHttpClientBuilder = DefaultApacheHttpClientBuilder.get();
        }
        apacheHttpClientBuilder.httpProxyHost(configStorage.getHttpProxyHost()).httpProxyPort(configStorage.getHttpProxyPort()).httpProxyUsername(configStorage.getHttpProxyUsername()).httpProxyPassword(configStorage.getHttpProxyPassword());
        if (configStorage.getHttpProxyHost() != null && configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new HttpHost(configStorage.getHttpProxyHost(), configStorage.getHttpProxyPort());
        }
        this.httpClient = apacheHttpClientBuilder.build();
    }

    public CloseableHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public HttpHost getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.APACHE_HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doGetAccessTokenRequest() throws IOException {
        String string;
        CloseableHttpResponse response;
        block4: {
            String url = StringUtils.isNotEmpty((CharSequence)this.getWxMaConfig().getAccessTokenUrl()) ? this.getWxMaConfig().getAccessTokenUrl() : (StringUtils.isNotEmpty((CharSequence)this.getWxMaConfig().getApiHostUrl()) ? "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s".replace("https://api.weixin.qq.com", this.getWxMaConfig().getApiHostUrl()) : "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s");
            url = String.format(url, this.getWxMaConfig().getAppid(), this.getWxMaConfig().getSecret());
            HttpGet httpGet = null;
            response = null;
            try {
                httpGet = new HttpGet(url);
                if (this.getRequestHttpProxy() != null) {
                    RequestConfig config = RequestConfig.custom().setProxy(this.getRequestHttpProxy()).build();
                    httpGet.setConfig(config);
                }
                response = this.getRequestHttpClient().execute((HttpUriRequest)httpGet);
                string = new BasicResponseHandler().handleResponse((HttpResponse)response);
                if (httpGet == null) break block4;
            }
            catch (Throwable throwable) {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
                IOUtils.closeQuietly(response);
                throw throwable;
            }
            httpGet.releaseConnection();
        }
        IOUtils.closeQuietly((Closeable)response);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doGetStableAccessTokenRequest(boolean forceRefresh) throws IOException {
        String string;
        CloseableHttpResponse response;
        block4: {
            String url = StringUtils.isNotEmpty((CharSequence)this.getWxMaConfig().getAccessTokenUrl()) ? this.getWxMaConfig().getAccessTokenUrl() : (StringUtils.isNotEmpty((CharSequence)this.getWxMaConfig().getApiHostUrl()) ? "https://api.weixin.qq.com/cgi-bin/stable_token".replace("https://api.weixin.qq.com", this.getWxMaConfig().getApiHostUrl()) : "https://api.weixin.qq.com/cgi-bin/stable_token");
            HttpPost httpPost = null;
            response = null;
            try {
                httpPost = new HttpPost(url);
                if (this.getRequestHttpProxy() != null) {
                    RequestConfig config = RequestConfig.custom().setProxy(this.getRequestHttpProxy()).build();
                    httpPost.setConfig(config);
                }
                WxMaStableAccessTokenRequest wxMaAccessTokenRequest = new WxMaStableAccessTokenRequest();
                wxMaAccessTokenRequest.setAppid(this.getWxMaConfig().getAppid());
                wxMaAccessTokenRequest.setSecret(this.getWxMaConfig().getSecret());
                wxMaAccessTokenRequest.setGrantType("client_credential");
                wxMaAccessTokenRequest.setForceRefresh(forceRefresh);
                httpPost.setEntity((HttpEntity)new StringEntity(wxMaAccessTokenRequest.toJson(), ContentType.APPLICATION_JSON));
                response = this.getRequestHttpClient().execute((HttpUriRequest)httpPost);
                string = new BasicResponseHandler().handleResponse((HttpResponse)response);
                if (httpPost == null) break block4;
            }
            catch (Throwable throwable) {
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
                IOUtils.closeQuietly(response);
                throw throwable;
            }
            httpPost.releaseConnection();
        }
        IOUtils.closeQuietly((Closeable)response);
        return string;
    }
}

