/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaProductOrderService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.product.WxMiniBatchGetAfterSaleOrderResponse;
import cn.binarywang.wx.miniapp.bean.product.WxMiniGetAfterSaleOrderResponse;
import cn.binarywang.wx.miniapp.bean.product.WxMiniOrderDeliveryRequest;
import cn.binarywang.wx.miniapp.bean.product.WxMinishopOrderDetailResponse;
import cn.binarywang.wx.miniapp.bean.product.WxMinishopOrderListResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopBaseResponse;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import java.util.List;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaProductOrderServiceImpl
implements WxMaProductOrderService {
    private static final Logger log = LoggerFactory.getLogger(WxMaProductOrderServiceImpl.class);
    private final WxMaService wxMaService;

    @Override
    public WxMinishopOrderListResponse getOrderList(String startCreateTime, String endCreateTime, String startUpdateTime, String endUpdateTime, Integer status, Integer page, Integer pageSize, Integer source) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/product/order/get_list", GsonHelper.buildJsonObject((Object[])new Object[]{"start_create_time", startCreateTime, "end_create_time", endCreateTime, "start_update_time", startUpdateTime, "end_update_time", endUpdateTime, "status", status, "page", page, "page_size", pageSize, "source", source}));
        WxMinishopOrderListResponse response = (WxMinishopOrderListResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMinishopOrderListResponse.class);
        if (response.getErrCode() != 0) {
            throw new WxErrorException(new WxError(response.getErrCode().intValue(), response.getErrMsg()));
        }
        return response;
    }

    @Override
    public WxMinishopOrderDetailResponse getOrderDetail(Long orderId) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/product/order/get", GsonHelper.buildJsonObject((Object[])new Object[]{"order_id", orderId}));
        WxMinishopOrderDetailResponse getDetailResponse = (WxMinishopOrderDetailResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMinishopOrderDetailResponse.class);
        if (getDetailResponse.getErrCode() != 0) {
            throw new WxErrorException(new WxError(getDetailResponse.getErrCode().intValue(), getDetailResponse.getErrMsg()));
        }
        return getDetailResponse;
    }

    @Override
    public void changeMerchantNotes(Long orderId, String merchantNotes) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/product/order/change_merchant_notes", GsonHelper.buildJsonObject((Object[])new Object[]{"order_id", orderId, "merchant_notes", merchantNotes}));
        WxMaShopBaseResponse changeResult = (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
        if (changeResult.getErrCode() != 0) {
            throw new WxErrorException(new WxError(changeResult.getErrCode().intValue(), changeResult.getErrMsg()));
        }
    }

    @Override
    public WxMaShopBaseResponse deliverySend(WxMiniOrderDeliveryRequest request) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/delivery/send", request);
        WxMaShopBaseResponse baseResponse = (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(response, WxMaShopBaseResponse.class);
        if (baseResponse.getErrCode() != 0) {
            throw new WxErrorException(new WxError(baseResponse.getErrCode().intValue(), baseResponse.getErrMsg()));
        }
        return baseResponse;
    }

    @Override
    public WxMiniGetAfterSaleOrderResponse getAfterSaleOrder(Long afterSaleOrderId) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/order/getaftersaleorder", GsonHelper.buildJsonObject((Object[])new Object[]{"after_sale_order_id", afterSaleOrderId}));
        WxMiniGetAfterSaleOrderResponse orderResponse = (WxMiniGetAfterSaleOrderResponse)WxMaGsonBuilder.create().fromJson(response, WxMiniGetAfterSaleOrderResponse.class);
        if (orderResponse.getErrCode() != 0) {
            throw new WxErrorException(new WxError(orderResponse.getErrCode().intValue(), orderResponse.getErrMsg()));
        }
        return orderResponse;
    }

    @Override
    public WxMiniBatchGetAfterSaleOrderResponse batchGetAfterSaleOrder(List<Long> afterSaleOrderIdList) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/order/batchgetaftersaleorder", GsonHelper.buildJsonObject((Object[])new Object[]{"after_sale_order_id_list", afterSaleOrderIdList}));
        WxMiniBatchGetAfterSaleOrderResponse orderResponse = (WxMiniBatchGetAfterSaleOrderResponse)WxMaGsonBuilder.create().fromJson(response, WxMiniBatchGetAfterSaleOrderResponse.class);
        if (orderResponse.getAfterSaleOrderList() == null) {
            throw new WxErrorException(new WxError(orderResponse.getErrCode().intValue(), "\u552e\u540e\u67e5\u8be2\u4e0d\u5b58\u5728"));
        }
        return orderResponse;
    }

    @Override
    public WxMaShopBaseResponse afterSaleAccept(Long orderId, Long addressId) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/order/acceptapply", GsonHelper.buildJsonObject((Object[])new Object[]{"order_id", orderId, "address_id", addressId}));
        WxMaShopBaseResponse baseResponse = (WxMaShopBaseResponse)WxGsonBuilder.create().fromJson(response, WxMaShopBaseResponse.class);
        if (baseResponse.getErrCode() != 0) {
            throw new WxErrorException(new WxError(baseResponse.getErrCode().intValue(), baseResponse.getErrMsg()));
        }
        return baseResponse;
    }

    @Override
    public WxMaShopBaseResponse afterSaleReject(Long afterSaleOrderId, String rejectReason) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/product/order/rejectrefund", GsonHelper.buildJsonObject((Object[])new Object[]{"order_id", afterSaleOrderId, "reject_reason", rejectReason}));
        WxMaShopBaseResponse baseResponse = (WxMaShopBaseResponse)WxGsonBuilder.create().fromJson(response, WxMaShopBaseResponse.class);
        if (baseResponse.getErrCode() != 0) {
            throw new WxErrorException(new WxError(baseResponse.getErrCode().intValue(), baseResponse.getErrMsg()));
        }
        return baseResponse;
    }

    public WxMaProductOrderServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

