/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaVodService;
import cn.binarywang.wx.miniapp.bean.WxMaBaseResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodAuditDramaRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodAuditDramaResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodDeleteMediaRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodDramaInfo;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetDramaRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetDramaResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetMediaLinkRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetMediaLinkResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetMediaRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodGetMediaResponse;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodListDramaRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodListMediaRequest;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodMediaInfo;
import cn.binarywang.wx.miniapp.bean.vod.WxMaVodMediaPlaybackInfo;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaVodServiceImpl
implements WxMaVodService {
    private static final Logger log = LoggerFactory.getLogger(WxMaVodServiceImpl.class);
    private final WxMaService service;

    @Override
    public List<WxMaVodMediaInfo> listMedia(WxMaVodListMediaRequest mediaRequest) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/listmedia", mediaRequest.toJson());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        boolean hasMediaInfoList = jsonObject.has("media_info_list");
        if (hasMediaInfoList) {
            return (List)WxMaGsonBuilder.create().fromJson((JsonElement)jsonObject.getAsJsonArray("media_info_list"), new TypeToken<List<WxMaVodMediaInfo>>(){}.getType());
        }
        return null;
    }

    @Override
    public List<WxMaVodDramaInfo> listDrama(WxMaVodListDramaRequest mediaRequest) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/listdramas", mediaRequest.toJson());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        boolean hasMediaInfoList = jsonObject.has("drama_info_list");
        if (hasMediaInfoList) {
            return (List)WxMaGsonBuilder.create().fromJson((JsonElement)jsonObject.getAsJsonArray("drama_info_list"), new TypeToken<List<WxMaVodDramaInfo>>(){}.getType());
        }
        return null;
    }

    @Override
    public WxMaVodMediaPlaybackInfo getMediaLink(WxMaVodGetMediaLinkRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/getmedialink", request.toJson());
        WxMaVodGetMediaLinkResponse getDetailResponse = (WxMaVodGetMediaLinkResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaVodGetMediaLinkResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return getDetailResponse.getMediaInfo();
    }

    @Override
    public WxMaVodMediaInfo getMedia(WxMaVodGetMediaRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/getmedia", request.toJson());
        WxMaVodGetMediaResponse getDetailResponse = (WxMaVodGetMediaResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaVodGetMediaResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return getDetailResponse.getMediaInfo();
    }

    @Override
    public boolean deleteMedia(WxMaVodDeleteMediaRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/deletemedia", request.toJson());
        WxMaBaseResponse getDetailResponse = (WxMaBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaBaseResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(new WxError(getDetailResponse.getErrcode().intValue(), getDetailResponse.getErrmsg()));
        }
        return true;
    }

    @Override
    public WxMaVodDramaInfo getDrama(WxMaVodGetDramaRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/getdrama", request.toJson());
        WxMaVodGetDramaResponse getDetailResponse = (WxMaVodGetDramaResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaVodGetDramaResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(new WxError(getDetailResponse.getErrcode().intValue(), getDetailResponse.getErrmsg()));
        }
        return getDetailResponse.getDramaInfo();
    }

    @Override
    public Integer auditDrama(WxMaVodAuditDramaRequest request) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/sec/vod/auditdrama", request.toJson());
        WxMaVodAuditDramaResponse getDetailResponse = (WxMaVodAuditDramaResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaVodAuditDramaResponse.class);
        if (getDetailResponse.getErrcode() != 0) {
            throw new WxErrorException(new WxError(getDetailResponse.getErrcode().intValue(), getDetailResponse.getErrmsg()));
        }
        return getDetailResponse.getDramaId();
    }

    public WxMaVodServiceImpl(WxMaService service) {
        this.service = service;
    }
}

