/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaShopCouponService;
import cn.binarywang.wx.miniapp.bean.shop.WxMaShopCouponInfo;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopBaseResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopCouponListResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopCouponResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopUserCouponListResponse;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonObject;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaShopCouponServiceImpl
implements WxMaShopCouponService {
    private static final Logger log = LoggerFactory.getLogger(WxMaShopCouponServiceImpl.class);
    private final WxMaService wxMaService;

    @Override
    public WxMaShopBaseResponse addCoupon(WxMaShopCouponInfo couponInfo) throws WxErrorException {
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"coupon", couponInfo});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/coupon/add", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopCouponResponse getCoupon(String outCouponId) throws WxErrorException {
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"out_coupon_id", outCouponId});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/coupon/get", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopCouponResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopCouponResponse.class);
    }

    @Override
    public WxMaShopCouponListResponse getCouponList(Integer pageSize, Integer offset) throws WxErrorException {
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"page_size", pageSize, "offset", offset});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/coupon/get_list", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopCouponListResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopCouponListResponse.class);
    }

    @Override
    public WxMaShopBaseResponse updateCoupon(WxMaShopCouponInfo couponInfo) throws WxErrorException {
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"coupon", couponInfo});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/coupon/update", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopBaseResponse updateCouponStatus(String outCouponId, Integer status) throws WxErrorException {
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"out_coupon_id", outCouponId, "status", status});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/coupon/update_status", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopBaseResponse updateCouponStock(String outCouponId, Integer isUsedNum, Integer receiveNum) throws WxErrorException {
        JsonObject stockInfo = GsonHelper.buildJsonObject((Object[])new Object[]{"issued_num", isUsedNum, "receive_num", receiveNum});
        JsonObject stock = GsonHelper.buildJsonObject((Object[])new Object[]{"out_coupon_id", outCouponId, "stock_info", stockInfo});
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"coupon_stock", stock});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/coupon/update_coupon_stock", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopBaseResponse addUserCoupon(String openid, String outUserCouponId, String outCouponId, Integer status, Long recvTime) throws WxErrorException {
        JsonObject userCoupon = GsonHelper.buildJsonObject((Object[])new Object[]{"out_user_coupon_id", outUserCouponId, "out_coupon_id", outCouponId, "status", status});
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"openid", openid, "user_coupon", userCoupon, "recv_time", recvTime});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/coupon/add_user_coupon", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopUserCouponListResponse getUserCouponList(Integer pageSize, Integer offset, String openid) throws WxErrorException {
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"page_size", pageSize, "offset", offset, "openid", openid});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/coupon/get_usercoupon_list", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopUserCouponListResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopUserCouponListResponse.class);
    }

    @Override
    public WxMaShopBaseResponse updateUserCoupon(String openid, String outUserCouponId, String outCouponId, Long useTime, Long recvTime) throws WxErrorException {
        JsonObject extInfo = GsonHelper.buildJsonObject((Object[])new Object[]{"use_time", useTime});
        JsonObject userCoupon = GsonHelper.buildJsonObject((Object[])new Object[]{"out_user_coupon_id", outUserCouponId, "out_coupon_id", outCouponId, "ext_info", extInfo});
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"openid", openid, "user_coupon", userCoupon, "recv_time", recvTime});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/coupon/update_user_coupon", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopBaseResponse updateUserCouponStatus(String openid, String outUserCouponId, String outCouponId, Integer status) throws WxErrorException {
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"openid", openid, "out_user_coupon_id", outUserCouponId, "out_coupon_id", outCouponId, "status", status});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/coupon/update_usercoupon_status", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    public WxMaShopCouponServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

