/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.message;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaMessage;
import cn.binarywang.wx.miniapp.message.WxMaMessageRouterRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import me.chanjar.weixin.common.api.WxErrorExceptionHandler;
import me.chanjar.weixin.common.api.WxMessageDuplicateChecker;
import me.chanjar.weixin.common.api.WxMessageInMemoryDuplicateChecker;
import me.chanjar.weixin.common.session.InternalSession;
import me.chanjar.weixin.common.session.InternalSessionManager;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.LogExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaMessageRouter {
    private static final int DEFAULT_THREAD_POOL_SIZE = 100;
    private final Logger log = LoggerFactory.getLogger(WxMaMessageRouter.class);
    private final List<WxMaMessageRouterRule> rules = new ArrayList<WxMaMessageRouterRule>();
    private final WxMaService wxMaService;
    private ExecutorService executorService;
    private WxMessageDuplicateChecker messageDuplicateChecker;
    private WxSessionManager sessionManager;
    private WxErrorExceptionHandler exceptionHandler;

    public WxMaMessageRouter(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
        this.executorService = Executors.newFixedThreadPool(100);
        this.messageDuplicateChecker = new WxMessageInMemoryDuplicateChecker();
        this.sessionManager = new StandardSessionManager();
        this.exceptionHandler = new LogExceptionHandler();
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setMessageDuplicateChecker(WxMessageDuplicateChecker messageDuplicateChecker) {
        this.messageDuplicateChecker = messageDuplicateChecker;
    }

    public void setSessionManager(WxSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setExceptionHandler(WxErrorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    List<WxMaMessageRouterRule> getRules() {
        return this.rules;
    }

    public WxMaMessageRouterRule rule() {
        return new WxMaMessageRouterRule(this);
    }

    public void route(final WxMaMessage wxMessage, final Map<String, Object> context) {
        ArrayList<WxMaMessageRouterRule> matchRules = new ArrayList<WxMaMessageRouterRule>();
        for (WxMaMessageRouterRule rule : this.rules) {
            if (!rule.test(wxMessage)) continue;
            matchRules.add(rule);
            if (rule.isReEnter()) continue;
            break;
        }
        if (matchRules.size() == 0) {
            return;
        }
        final ArrayList futures = new ArrayList();
        for (final WxMaMessageRouterRule rule : matchRules) {
            if (rule.isAsync()) {
                futures.add(this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        rule.service(wxMessage, context, WxMaMessageRouter.this.wxMaService, WxMaMessageRouter.this.sessionManager, WxMaMessageRouter.this.exceptionHandler);
                    }
                }));
                continue;
            }
            rule.service(wxMessage, context, this.wxMaService, this.sessionManager, this.exceptionHandler);
            this.log.debug("End session access: async=false, sessionId={}", (Object)wxMessage.getFromUser());
            this.sessionEndAccess(wxMessage);
        }
        if (futures.size() > 0) {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    for (Future future : futures) {
                        try {
                            future.get();
                            WxMaMessageRouter.this.log.debug("End session access: async=true, sessionId={}", (Object)wxMessage.getFromUser());
                            WxMaMessageRouter.this.sessionEndAccess(wxMessage);
                        }
                        catch (InterruptedException | ExecutionException e) {
                            WxMaMessageRouter.this.log.error("Error happened when wait task finish", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public void route(WxMaMessage wxMessage) {
        this.route(wxMessage, new HashMap<String, Object>());
    }

    protected void sessionEndAccess(WxMaMessage wxMessage) {
        InternalSession session = ((InternalSessionManager)this.sessionManager).findSession(wxMessage.getFromUser());
        if (session != null) {
            session.endAccess();
        }
    }
}

