/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.bean;

import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.util.crypt.WxMaCryptUtils;
import cn.binarywang.wx.miniapp.util.json.WxMaGsonBuilder;
import cn.binarywang.wx.miniapp.util.xml.XStreamTransformer;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.util.ToStringUtils;
import me.chanjar.weixin.common.util.xml.XStreamCDataConverter;
import org.apache.commons.io.IOUtils;

@XStreamAlias(value="xml")
public class WxMaMessage
implements Serializable {
    private static final long serialVersionUID = -3586245291677274914L;
    @SerializedName(value="Encrypt")
    @XStreamAlias(value="Encrypt")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String encrypt;
    @SerializedName(value="ToUserName")
    @XStreamAlias(value="ToUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String toUser;
    @SerializedName(value="FromUserName")
    @XStreamAlias(value="FromUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String fromUser;
    @SerializedName(value="CreateTime")
    @XStreamAlias(value="CreateTime")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private Integer createTime;
    @SerializedName(value="MsgDataFormat")
    @XStreamAlias(value="MsgDataFormat")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String msgType;
    @SerializedName(value="Content")
    @XStreamAlias(value="Content")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String content;
    @SerializedName(value="MsgId")
    @XStreamAlias(value="MsgId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private Long msgId;
    @SerializedName(value="PicUrl")
    @XStreamAlias(value="PicUrl")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String picUrl;
    @SerializedName(value="MediaId")
    @XStreamAlias(value="MediaId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String mediaId;
    @SerializedName(value="Event")
    @XStreamAlias(value="Event")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String event;
    @SerializedName(value="SessionFrom")
    @XStreamAlias(value="SessionFrom")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String sessionFrom;

    public static WxMaMessage fromXml(String xml) {
        return XStreamTransformer.fromXml(WxMaMessage.class, xml);
    }

    public static WxMaMessage fromXml(InputStream is) {
        return XStreamTransformer.fromXml(WxMaMessage.class, is);
    }

    public static WxMaMessage fromEncryptedXml(String encryptedXml, WxMaConfig wxMaConfig, String timestamp, String nonce, String msgSignature) {
        String plainText = new WxMaCryptUtils(wxMaConfig).decrypt(msgSignature, timestamp, nonce, encryptedXml);
        return WxMaMessage.fromXml(plainText);
    }

    public static WxMaMessage fromEncryptedXml(InputStream is, WxMaConfig wxMaConfig, String timestamp, String nonce, String msgSignature) {
        try {
            return WxMaMessage.fromEncryptedXml(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8), wxMaConfig, timestamp, nonce, msgSignature);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static WxMaMessage fromJson(String json) {
        return (WxMaMessage)WxMaGsonBuilder.create().fromJson(json, WxMaMessage.class);
    }

    public static WxMaMessage fromEncryptedJson(String encryptedJson, WxMaConfig config) {
        try {
            WxMaMessage encryptedMessage = WxMaMessage.fromJson(encryptedJson);
            String plainText = new WxMaCryptUtils(config).decrypt(encryptedMessage.getEncrypt());
            return WxMaMessage.fromJson(plainText);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static WxMaMessage fromEncryptedJson(InputStream inputStream, WxMaConfig config) {
        try {
            return WxMaMessage.fromEncryptedJson(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), config);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return ToStringUtils.toSimpleString((Object)this);
    }

    public String toJson() {
        return WxMaGsonBuilder.create().toJson((Object)this);
    }

    public String getToUser() {
        return this.toUser;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    public String getFromUser() {
        return this.fromUser;
    }

    public void setFromUser(String fromUser) {
        this.fromUser = fromUser;
    }

    public Integer getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Integer createTime) {
        this.createTime = createTime;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public String getPicUrl() {
        return this.picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getSessionFrom() {
        return this.sessionFrom;
    }

    public void setSessionFrom(String sessionFrom) {
        this.sessionFrom = sessionFrom;
    }

    public String getEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(String encrypt) {
        this.encrypt = encrypt;
    }
}

