/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.impl.WxMaServiceAbstractImpl;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.common.util.http.apache.DefaultApacheHttpClientBuilder;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;

public class WxMaServiceImpl
extends WxMaServiceAbstractImpl<CloseableHttpClient, HttpHost> {
    private CloseableHttpClient httpClient;
    private HttpHost httpProxy;

    public CloseableHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public HttpHost getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.APACHE_HTTP;
    }

    @Override
    public void initHttp() {
        WxMaConfig configStorage = this.getWxMaConfig();
        ApacheHttpClientBuilder apacheHttpClientBuilder = configStorage.getApacheHttpClientBuilder();
        if (null == apacheHttpClientBuilder) {
            apacheHttpClientBuilder = DefaultApacheHttpClientBuilder.get();
        }
        apacheHttpClientBuilder.httpProxyHost(configStorage.getHttpProxyHost()).httpProxyPort(configStorage.getHttpProxyPort()).httpProxyUsername(configStorage.getHttpProxyUsername()).httpProxyPassword(configStorage.getHttpProxyPassword());
        if (configStorage.getHttpProxyHost() != null && configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new HttpHost(configStorage.getHttpProxyHost(), configStorage.getHttpProxyPort());
        }
        this.httpClient = apacheHttpClientBuilder.build();
    }

    @Override
    public RequestHttp getRequestHttp() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        block23: {
            Lock lock = this.getWxMaConfig().getAccessTokenLock();
            try {
                lock.lock();
                if (forceRefresh) {
                    this.getWxMaConfig().expireAccessToken();
                }
                if (!this.getWxMaConfig().isAccessTokenExpired()) break block23;
                String url = String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", this.getWxMaConfig().getAppid(), this.getWxMaConfig().getSecret());
                try {
                    HttpGet httpGet = new HttpGet(url);
                    if (this.getRequestHttpProxy() != null) {
                        RequestConfig config = RequestConfig.custom().setProxy(this.getRequestHttpProxy()).build();
                        httpGet.setConfig(config);
                    }
                    try (CloseableHttpResponse response = this.getRequestHttpClient().execute((HttpUriRequest)httpGet);){
                        String resultContent = new BasicResponseHandler().handleResponse((HttpResponse)response);
                        WxError error = WxError.fromJson((String)resultContent);
                        if (error.getErrorCode() != 0) {
                            throw new WxErrorException(error);
                        }
                        WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
                        this.getWxMaConfig().updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
                    }
                    finally {
                        httpGet.releaseConnection();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return this.getWxMaConfig().getAccessToken();
    }
}

