/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaMediaService;
import cn.binarywang.wx.miniapp.api.WxMaMsgService;
import cn.binarywang.wx.miniapp.api.WxMaQrcodeService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaUserService;
import cn.binarywang.wx.miniapp.api.impl.WxMaMediaServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaMsgServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaQrcodeServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaUserServiceImpl;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import com.google.gson.JsonParser;
import java.io.IOException;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WxMaServiceAbstractImpl<H, P>
implements WxMaService,
RequestHttp<H, P> {
    private static final JsonParser JSON_PARSER = new JsonParser();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private WxMaConfig wxMaConfig;
    private WxMaMsgService kefuService = new WxMaMsgServiceImpl(this);
    private WxMaMediaService materialService = new WxMaMediaServiceImpl(this);
    private WxMaUserService userService = new WxMaUserServiceImpl(this);
    private WxMaQrcodeService qrCodeService = new WxMaQrcodeServiceImpl(this);
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;

    @Override
    public boolean checkSignature(String timestamp, String nonce, String signature) {
        try {
            return SHA1.gen((String[])new String[]{this.getWxMaConfig().getToken(), timestamp, nonce}).equals(signature);
        }
        catch (Exception e) {
            this.log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public String getAccessToken() throws WxErrorException {
        return this.getAccessToken(false);
    }

    @Override
    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam);
    }

    @Override
    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData);
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data);
            }
            catch (WxErrorException e) {
                if (retryTimes + 1 > this.maxRetryTimes) {
                    this.log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
                }
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        this.log.warn("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{} ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1);
                    }
                } else {
                    throw e;
                }
                if (retryTimes++ < this.maxRetryTimes) continue;
                this.log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    public synchronized <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        if (uri.contains("access_token=")) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709access_token: " + uri);
        }
        String accessToken = this.getAccessToken(false);
        String uriWithAccessToken = uri + (uri.contains("?") ? "&" : "?") + "access_token=" + accessToken;
        try {
            Object result = executor.execute(uriWithAccessToken, data);
            this.log.debug("\n[URL]:  {}\n[PARAMS]: {}\n[RESPONSE]: {}", new Object[]{uriWithAccessToken, data, result});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == 42001 || error.getErrorCode() == 40001 || error.getErrorCode() == 40014) {
                this.getWxMaConfig().expireAccessToken();
                if (this.getWxMaConfig().autoRefreshToken()) {
                    return this.execute(executor, uri, data);
                }
            }
            if (error.getErrorCode() != 0) {
                this.log.error("\n[URL]:  {}\n[PARAMS]: {}\n[RESPONSE]: {}", new Object[]{uriWithAccessToken, data, error});
                throw new WxErrorException(error);
            }
            return null;
        }
        catch (IOException e) {
            this.log.error("\n[URL]:  {}\n[PARAMS]: {}\n[EXCEPTION]: {}", new Object[]{uriWithAccessToken, data, e.getMessage()});
            throw new RuntimeException(e);
        }
    }

    @Override
    public WxMaConfig getWxMaConfig() {
        return this.wxMaConfig;
    }

    @Override
    public void setWxMaConfig(WxMaConfig wxConfigProvider) {
        this.wxMaConfig = wxConfigProvider;
        this.initHttp();
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public WxMaMsgService getMsgService() {
        return this.kefuService;
    }

    @Override
    public WxMaMediaService getMediaService() {
        return this.materialService;
    }

    @Override
    public WxMaUserService getUserService() {
        return this.userService;
    }

    @Override
    public WxMaQrcodeService getQrcodeService() {
        return this.qrCodeService;
    }
}

