/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.bean.menu.WxMenu;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSession;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.ApacheHttpClientBuilder;
import me.chanjar.weixin.common.util.http.DefaultApacheHttpClientBuilder;
import me.chanjar.weixin.common.util.http.MediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.cp.api.WxCpConfigStorage;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpDepart;
import me.chanjar.weixin.cp.bean.WxCpMessage;
import me.chanjar.weixin.cp.bean.WxCpTag;
import me.chanjar.weixin.cp.bean.WxCpUser;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpServiceImpl
implements WxCpService {
    protected final Logger log = LoggerFactory.getLogger(WxCpServiceImpl.class);
    protected final Object globalAccessTokenRefreshLock = new Object();
    protected final Object globalJsapiTicketRefreshLock = new Object();
    protected WxCpConfigStorage configStorage;
    protected CloseableHttpClient httpClient;
    protected HttpHost httpProxy;
    protected WxSessionManager sessionManager = new StandardSessionManager();
    protected File tmpDirFile;
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;

    @Override
    public boolean checkSignature(String msgSignature, String timestamp, String nonce, String data) {
        try {
            return SHA1.gen((String[])new String[]{this.configStorage.getToken(), timestamp, nonce, data}).equals(msgSignature);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void userAuthenticated(String userId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/authsucc?userid=" + userId;
        this.get(url, null);
    }

    @Override
    public String getAccessToken() throws WxErrorException {
        return this.getAccessToken(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.configStorage.expireAccessToken();
        }
        if (this.configStorage.isAccessTokenExpired()) {
            Object object = this.globalAccessTokenRefreshLock;
            synchronized (object) {
                if (this.configStorage.isAccessTokenExpired()) {
                    String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?&corpid=" + this.configStorage.getCorpId() + "&corpsecret=" + this.configStorage.getCorpSecret();
                    try {
                        HttpGet httpGet = new HttpGet(url);
                        if (this.httpProxy != null) {
                            RequestConfig config = RequestConfig.custom().setProxy(this.httpProxy).build();
                            httpGet.setConfig(config);
                        }
                        String resultContent = null;
                        try (CloseableHttpClient httpclient = this.getHttpclient();
                             CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
                            resultContent = new BasicResponseHandler().handleResponse((HttpResponse)response);
                        }
                        finally {
                            httpGet.releaseConnection();
                        }
                        WxError error = WxError.fromJson((String)resultContent);
                        if (error.getErrorCode() != 0) {
                            throw new WxErrorException(error);
                        }
                        WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
                        this.configStorage.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.configStorage.getAccessToken();
    }

    @Override
    public String getJsapiTicket() throws WxErrorException {
        return this.getJsapiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJsapiTicket(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.configStorage.expireJsapiTicket();
        }
        if (this.configStorage.isJsapiTicketExpired()) {
            Object object = this.globalJsapiTicketRefreshLock;
            synchronized (object) {
                if (this.configStorage.isJsapiTicketExpired()) {
                    String url = "https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket";
                    String responseContent = (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, null);
                    JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
                    JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
                    String jsapiTicket = tmpJsonObject.get("ticket").getAsString();
                    int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
                    this.configStorage.updateJsapiTicket(jsapiTicket, expiresInSeconds);
                }
            }
        }
        return this.configStorage.getJsapiTicket();
    }

    @Override
    public WxJsapiSignature createJsapiSignature(String url) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String noncestr = RandomUtils.getRandomStr();
        String jsapiTicket = this.getJsapiTicket(false);
        String signature = SHA1.genWithAmple((String[])new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + noncestr, "timestamp=" + timestamp, "url=" + url});
        WxJsapiSignature jsapiSignature = new WxJsapiSignature();
        jsapiSignature.setTimestamp(timestamp);
        jsapiSignature.setNoncestr(noncestr);
        jsapiSignature.setUrl(url);
        jsapiSignature.setSignature(signature);
        jsapiSignature.setAppid(this.configStorage.getCorpId());
        return jsapiSignature;
    }

    @Override
    public void messageSend(WxCpMessage message) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/message/send";
        this.post(url, message.toJson());
    }

    @Override
    public void menuCreate(WxMenu menu) throws WxErrorException {
        this.menuCreate(this.configStorage.getAgentId(), menu);
    }

    @Override
    public void menuCreate(Integer agentId, WxMenu menu) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/menu/create?agentid=" + this.configStorage.getAgentId();
        this.post(url, menu.toJson());
    }

    @Override
    public void menuDelete() throws WxErrorException {
        this.menuDelete(this.configStorage.getAgentId());
    }

    @Override
    public void menuDelete(Integer agentId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/menu/delete?agentid=" + agentId;
        this.get(url, null);
    }

    @Override
    public WxMenu menuGet() throws WxErrorException {
        return this.menuGet(this.configStorage.getAgentId());
    }

    @Override
    public WxMenu menuGet(Integer agentId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/menu/get?agentid=" + agentId;
        try {
            String resultContent = this.get(url, null);
            return WxMenu.fromJson((String)resultContent);
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == 46003) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public WxMediaUploadResult mediaUpload(String mediaType, String fileType, InputStream inputStream) throws WxErrorException, IOException {
        return this.mediaUpload(mediaType, FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)fileType));
    }

    @Override
    public WxMediaUploadResult mediaUpload(String mediaType, File file) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/media/upload?type=" + mediaType;
        return (WxMediaUploadResult)this.execute((RequestExecutor)new MediaUploadRequestExecutor(), url, (Object)file);
    }

    @Override
    public File mediaDownload(String media_id) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/media/get";
        return (File)this.execute((RequestExecutor)new MediaDownloadRequestExecutor(this.configStorage.getTmpDirFile()), url, (Object)("media_id=" + media_id));
    }

    @Override
    public Integer departCreate(WxCpDepart depart) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/create";
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)depart.toJson());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return GsonHelper.getAsInteger((JsonElement)tmpJsonElement.getAsJsonObject().get("id"));
    }

    @Override
    public void departUpdate(WxCpDepart group) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/update";
        this.post(url, group.toJson());
    }

    @Override
    public void departDelete(Integer departId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/delete?id=" + departId;
        this.get(url, null);
    }

    @Override
    public List<WxCpDepart> departGet() throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/list";
        String responseContent = this.get(url, null);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (List)WxCpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement.getAsJsonObject().get("department"), new TypeToken<List<WxCpDepart>>(){}.getType());
    }

    @Override
    public void userCreate(WxCpUser user) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/create";
        this.post(url, user.toJson());
    }

    @Override
    public void userUpdate(WxCpUser user) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/update";
        this.post(url, user.toJson());
    }

    @Override
    public void userDelete(String userid) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/delete?userid=" + userid;
        this.get(url, null);
    }

    @Override
    public void userDelete(String[] userids) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/batchdelete";
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (String userid : userids) {
            jsonArray.add((JsonElement)new JsonPrimitive(userid));
        }
        jsonObject.add("useridlist", (JsonElement)jsonArray);
        this.post(url, jsonObject.toString());
    }

    @Override
    public WxCpUser userGet(String userid) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/get?userid=" + userid;
        String responseContent = this.get(url, null);
        return WxCpUser.fromJson(responseContent);
    }

    @Override
    public List<WxCpUser> userList(Integer departId, Boolean fetchChild, Integer status) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/list?department_id=" + departId;
        String params = "";
        if (fetchChild != null) {
            params = params + "&fetch_child=" + (fetchChild != false ? "1" : "0");
        }
        params = status != null ? params + "&status=" + status : params + "&status=0";
        String responseContent = this.get(url, params);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (List)WxCpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement.getAsJsonObject().get("userlist"), new TypeToken<List<WxCpUser>>(){}.getType());
    }

    @Override
    public List<WxCpUser> departGetUsers(Integer departId, Boolean fetchChild, Integer status) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?department_id=" + departId;
        String params = "";
        if (fetchChild != null) {
            params = params + "&fetch_child=" + (fetchChild != false ? "1" : "0");
        }
        params = status != null ? params + "&status=" + status : params + "&status=0";
        String responseContent = this.get(url, params);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (List)WxCpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement.getAsJsonObject().get("userlist"), new TypeToken<List<WxCpUser>>(){}.getType());
    }

    @Override
    public String tagCreate(String tagName) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/create";
        JsonObject o = new JsonObject();
        o.addProperty("tagname", tagName);
        String responseContent = this.post(url, o.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return tmpJsonElement.getAsJsonObject().get("tagid").getAsString();
    }

    @Override
    public void tagUpdate(String tagId, String tagName) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/update";
        JsonObject o = new JsonObject();
        o.addProperty("tagid", tagId);
        o.addProperty("tagname", tagName);
        this.post(url, o.toString());
    }

    @Override
    public void tagDelete(String tagId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/delete?tagid=" + tagId;
        this.get(url, null);
    }

    @Override
    public List<WxCpTag> tagGet() throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/list";
        String responseContent = this.get(url, null);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (List)WxCpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement.getAsJsonObject().get("taglist"), new TypeToken<List<WxCpTag>>(){}.getType());
    }

    @Override
    public List<WxCpUser> tagGetUsers(String tagId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/get?tagid=" + tagId;
        String responseContent = this.get(url, null);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (List)WxCpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement.getAsJsonObject().get("userlist"), new TypeToken<List<WxCpUser>>(){}.getType());
    }

    @Override
    public void tagAddUsers(String tagId, List<String> userIds, List<String> partyIds) throws WxErrorException {
        JsonArray jsonArray;
        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/addtagusers";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("tagid", tagId);
        if (userIds != null) {
            jsonArray = new JsonArray();
            for (String userId : userIds) {
                jsonArray.add((JsonElement)new JsonPrimitive(userId));
            }
            jsonObject.add("userlist", (JsonElement)jsonArray);
        }
        if (partyIds != null) {
            jsonArray = new JsonArray();
            for (String userId : partyIds) {
                jsonArray.add((JsonElement)new JsonPrimitive(userId));
            }
            jsonObject.add("partylist", (JsonElement)jsonArray);
        }
        this.post(url, jsonObject.toString());
    }

    @Override
    public void tagRemoveUsers(String tagId, List<String> userIds) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/deltagusers";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("tagid", tagId);
        JsonArray jsonArray = new JsonArray();
        for (String userId : userIds) {
            jsonArray.add((JsonElement)new JsonPrimitive(userId));
        }
        jsonObject.add("userlist", (JsonElement)jsonArray);
        this.post(url, jsonObject.toString());
    }

    @Override
    public String oauth2buildAuthorizationUrl(String state) {
        return this.oauth2buildAuthorizationUrl(this.configStorage.getOauth2redirectUri(), state);
    }

    @Override
    public String oauth2buildAuthorizationUrl(String redirectUri, String state) {
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?";
        url = url + "appid=" + this.configStorage.getCorpId();
        url = url + "&redirect_uri=" + URIUtil.encodeURIComponent((String)redirectUri);
        url = url + "&response_type=code";
        url = url + "&scope=snsapi_base";
        if (state != null) {
            url = url + "&state=" + state;
        }
        url = url + "#wechat_redirect";
        return url;
    }

    @Override
    public String[] oauth2getUserInfo(String code) throws WxErrorException {
        return this.oauth2getUserInfo(this.configStorage.getAgentId(), code);
    }

    @Override
    public String[] oauth2getUserInfo(Integer agentId, String code) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?code=" + code + "&agentid=" + agentId;
        String responseText = this.get(url, null);
        JsonElement je = new JsonParser().parse(responseText);
        JsonObject jo = je.getAsJsonObject();
        return new String[]{GsonHelper.getString((JsonObject)jo, (String)"UserId"), GsonHelper.getString((JsonObject)jo, (String)"DeviceId")};
    }

    @Override
    public int invite(String userId, String inviteTips) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/invite/send";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        if (StringUtils.isNotEmpty((CharSequence)inviteTips)) {
            jsonObject.addProperty("invite_tips", inviteTips);
        }
        String responseContent = this.post(url, jsonObject.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return tmpJsonElement.getAsJsonObject().get("type").getAsInt();
    }

    @Override
    public String[] getCallbackIp() throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/getcallbackip";
        String responseContent = this.get(url, null);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        JsonArray jsonArray = tmpJsonElement.getAsJsonObject().get("ip_list").getAsJsonArray();
        String[] ips = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            ips[i] = jsonArray.get(i).getAsString();
        }
        return ips;
    }

    @Override
    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, (Object)queryParam);
    }

    @Override
    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)postData);
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data);
            }
            catch (WxErrorException e) {
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        this.log.debug("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{}ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1);
                    }
                } else {
                    throw e;
                }
                if (++retryTimes < this.maxRetryTimes) continue;
                throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    protected synchronized <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        if (uri.contains("access_token=")) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709access_token: " + uri);
        }
        String accessToken = this.getAccessToken(false);
        String uriWithAccessToken = uri;
        uriWithAccessToken = uriWithAccessToken + (uri.indexOf(63) == -1 ? "?access_token=" + accessToken : "&access_token=" + accessToken);
        try {
            return (T)executor.execute(this.getHttpclient(), this.httpProxy, uriWithAccessToken, data);
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == 42001 || error.getErrorCode() == 40001) {
                this.configStorage.expireAccessToken();
                return this.execute(executor, uri, data);
            }
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected CloseableHttpClient getHttpclient() {
        return this.httpClient;
    }

    @Override
    public void setWxCpConfigStorage(WxCpConfigStorage wxConfigProvider) {
        this.configStorage = wxConfigProvider;
        ApacheHttpClientBuilder apacheHttpClientBuilder = this.configStorage.getApacheHttpClientBuilder();
        if (null == apacheHttpClientBuilder) {
            apacheHttpClientBuilder = DefaultApacheHttpClientBuilder.get();
        }
        apacheHttpClientBuilder.httpProxyHost(this.configStorage.getHttpProxyHost()).httpProxyPort(this.configStorage.getHttpProxyPort()).httpProxyUsername(this.configStorage.getHttpProxyUsername()).httpProxyPassword(this.configStorage.getHttpProxyPassword());
        if (this.configStorage.getHttpProxyHost() != null && this.configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new HttpHost(this.configStorage.getHttpProxyHost(), this.configStorage.getHttpProxyPort());
        }
        this.httpClient = apacheHttpClientBuilder.build();
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public WxSession getSession(String id) {
        if (this.sessionManager == null) {
            return null;
        }
        return this.sessionManager.getSession(id);
    }

    @Override
    public WxSession getSession(String id, boolean create) {
        if (this.sessionManager == null) {
            return null;
        }
        return this.sessionManager.getSession(id, create);
    }

    @Override
    public void setSessionManager(WxSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public String replaceParty(String mediaId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/batch/replaceparty";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("media_id", mediaId);
        return this.post(url, jsonObject.toString());
    }

    @Override
    public String replaceUser(String mediaId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/batch/replaceuser";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("media_id", mediaId);
        return this.post(url, jsonObject.toString());
    }

    @Override
    public String getTaskResult(String joinId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/batch/getresult?jobid=" + joinId;
        return this.get(url, null);
    }

    public File getTmpDirFile() {
        return this.tmpDirFile;
    }

    public void setTmpDirFile(File tmpDirFile) {
        this.tmpDirFile = tmpDirFile;
    }
}

