package me.chanjar.weixin.channel.bean.order;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 物流信息
 *
 * @author <a href="https://github.com/lixize">Zeyes</a>
 */
@Data
@NoArgsConstructor
public class OrderDeliveryInfo implements Serializable {

  private static final long serialVersionUID = -5348922760017557397L;
  /** 地址信息 */
  @JsonProperty("address_info")
  private OrderAddressInfo addressInfo;

  /** 发货物流信息 */
  @JsonProperty("delivery_product_info")
  private List<DeliveryProductInfo> deliveryProductInfos;

  /** 发货完成时间，秒级时间戳 */
  @JsonProperty("ship_done_time")
  private Long shipDoneTime;

  /** 订单发货方式，0普通物流 1虚拟发货，由商品的同名字段决定 */
  @JsonProperty("deliver_method")
  private Integer deliverMethod;

}
