/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.chapter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum ChapterArticleContentType {
    ACADEMIC_CHAPTER("AcademicChapter", "Academic Chapter"),
    NON_FICTION_CHAPTER("NonFictionChapter", "Non-fiction Chapter"),
    POPULAR_SCIENCE_CHAPTER("PopularScienceChapter", "Popular Science Chapter"),
    TEXTBOOK_CHAPTER("TextbookChapter", "Textbook Chapter"),
    ENCYCLOPEDIA_CHAPTER("EncyclopediaChapter", "Encyclopedia Chapter"),
    INTRODUCTION("Introduction", "Introduction"),
    EXHIBITION_CATALOG_CHAPTER("ExhibitionCatalogChapter", "Exhibition Catalog Chapter");

    public static final String ERROR_MESSAGE_TEMPLATE = "%s not a valid ChapterContentType, expected one of: %s";
    public static final String DELIMITER = ", ";
    private final String value;
    private final String deprecatedValue;

    private ChapterArticleContentType(String value, String deprecatedValue) {
        this.value = value;
        this.deprecatedValue = deprecatedValue;
    }

    @JsonCreator
    public static ChapterArticleContentType lookup(String value) {
        return Arrays.stream(ChapterArticleContentType.values()).filter(nameType -> ChapterArticleContentType.equalsCurrentOrDeprecatedValue(value, nameType)).findAny().orElseThrow(() -> new IllegalArgumentException(ChapterArticleContentType.createErrorMessage(value)));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    private String getDeprecatedValue() {
        return this.deprecatedValue;
    }

    private static boolean equalsCurrentOrDeprecatedValue(String value, ChapterArticleContentType nameType) {
        return nameType.getValue().equalsIgnoreCase(value) || nameType.getDeprecatedValue().equalsIgnoreCase(value);
    }

    private static String createErrorMessage(String value) {
        return String.format(ERROR_MESSAGE_TEMPLATE, value, Arrays.stream(ChapterArticleContentType.values()).map(Enum::toString).collect(Collectors.joining(DELIMITER)));
    }
}

