/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.instancetypes.artistic.music;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;
import no.unit.nva.model.instancetypes.artistic.music.MusicMediaType;
import no.unit.nva.model.instancetypes.artistic.music.MusicPerformanceManifestation;
import no.unit.nva.model.instancetypes.artistic.music.MusicTrack;
import no.unit.nva.model.util.SerializationUtils;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class AudioVisualPublication
implements MusicPerformanceManifestation {
    public static final String MEDIA_TYPE = "mediaType";
    public static final String PUBLISHER = "publisher";
    public static final String CATALOGUE_NUMBER = "catalogueNumber";
    public static final String TRACK_LIST = "trackList";
    @JsonProperty(value="mediaType")
    private final MusicMediaType mediaType;
    @JsonProperty(value="publisher")
    private final String publisher;
    @JsonProperty(value="catalogueNumber")
    private final String catalogueNumber;
    @JsonProperty(value="trackList")
    private final List<MusicTrack> trackList;

    @JsonCreator
    public AudioVisualPublication(@JsonProperty(value="mediaType") MusicMediaType mediaType, @JsonProperty(value="publisher") String publisher, @JsonProperty(value="catalogueNumber") String catalogueNumber, @JsonProperty(value="trackList") List<MusicTrack> trackList) {
        this.mediaType = mediaType;
        this.publisher = publisher;
        this.catalogueNumber = catalogueNumber;
        this.trackList = SerializationUtils.nullListAsEmpty(trackList);
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.getMediaType(), this.getPublisher(), this.getCatalogueNumber(), this.getTrackList()});
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AudioVisualPublication)) {
            return false;
        }
        AudioVisualPublication that = (AudioVisualPublication)o;
        return this.getMediaType() == that.getMediaType() && Objects.equals(this.getPublisher(), that.getPublisher()) && Objects.equals(this.getCatalogueNumber(), that.getCatalogueNumber()) && Objects.equals(this.getTrackList(), that.getTrackList());
    }

    public MusicMediaType getMediaType() {
        return this.mediaType;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String getCatalogueNumber() {
        return this.catalogueNumber;
    }

    public List<MusicTrack> getTrackList() {
        return this.trackList;
    }
}

