/*
 * Decompiled with CFR 0.152.
 */
package ru.belyiz;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.function.Consumer;

public final class FileUtils {
    private FileUtils() {
    }

    public static void processFiles(File root, Consumer<File> consumer) {
        if (root.isFile()) {
            consumer.accept(root);
            return;
        }
        for (File file : root.listFiles()) {
            if (file.isDirectory()) {
                FileUtils.processFiles(file, consumer);
                continue;
            }
            consumer.accept(file);
        }
    }

    public static void processFileLines(String filePath, String encoding, Consumer<String> consumer) throws IOException {
        Files.lines(Paths.get(filePath, new String[0]), Charset.forName(encoding)).forEach(consumer);
    }

    public static String getFileExtension(File file) {
        String fileName = file.getName();
        int dotPosition = fileName.lastIndexOf(".");
        if (dotPosition != -1) {
            return fileName.substring(dotPosition);
        }
        return "";
    }
}

